/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.forms;

import com.manydesigns.elements.Element;
import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.annotations.Help;
import com.manydesigns.elements.composites.AbstractCompositeElement;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.fields.FieldUtils;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.text.TextFormat;
import com.manydesigns.elements.util.RandomUtil;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TableForm
implements Element {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected String selectInputName = "select";
    protected final Column[] columns;
    protected final Row[] rows;
    protected String prefix;
    protected String caption;
    protected boolean selectable = false;
    protected TextFormat keyTextFormat;
    protected boolean condensed = false;
    protected boolean striped = true;
    private static final String SELECTION_CELL_CLASS = "selection-cell";

    public TableForm(int nRows, PropertyAccessor ... propertyAccessors) {
        int i;
        this.rows = new Row[nRows];
        this.columns = new Column[propertyAccessors.length];
        for (i = 0; i < nRows; ++i) {
            this.rows[i] = new Row(i);
        }
        for (i = 0; i < this.columns.length; ++i) {
            this.columns[i] = new Column(propertyAccessors[i]);
        }
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        xb.openElement("table");
        xb.addAttribute("class", "table mde-table-form" + (this.condensed ? " table-condensed" : "") + (this.striped ? " table-striped" : ""));
        if (this.caption != null) {
            xb.writeCaption(this.caption);
        }
        xb.openElement("thead");
        xb.openElement("tr");
        if (this.selectable) {
            xb.openElement("th");
            xb.openElement("div");
            xb.addAttribute("class", " squared-dark ");
            xb.openElement("input");
            xb.addAttribute("type", "checkbox");
            xb.addAttribute("title", "select-all");
            String id = RandomUtil.createRandomId(10);
            xb.addAttribute("id", id);
            String js = "$(this).closest('table').find('div.selection-cell input').prop('checked', $(this).prop('checked'));";
            xb.addAttribute("onchange", js);
            xb.closeElement("input");
            xb.openElement("label");
            xb.addAttribute("for", id);
            xb.closeElement("label");
            xb.closeElement("div");
            xb.closeElement("th");
        }
        for (Column column : this.columns) {
            xb.openElement("th");
            if (column.title != null) {
                xb.addAttribute("title", column.title);
            }
            PropertyAccessor property = column.getPropertyAccessor();
            xb.addAttribute("data-property-name", property.getName());
            xb.openElement("p");
            xb.addAttribute("class", "form-control-static");
            if (column.headerTextFormat != null) {
                HashMap<String, Object> formatParameters = new HashMap<String, Object>();
                formatParameters.put("label", StringEscapeUtils.escapeHtml((String)column.getActualLabel()));
                formatParameters.put("property", property);
                xb.writeNoHtmlEscape(column.headerTextFormat.format(formatParameters));
            } else {
                xb.write(column.getActualLabel());
            }
            xb.closeElement("p");
            xb.closeElement("th");
        }
        xb.closeElement("tr");
        xb.closeElement("thead");
        if (this.rows.length > 0) {
            xb.openElement("tbody");
            for (Row row : this.rows) {
                row.toXhtml(xb);
            }
            xb.closeElement("tbody");
        }
        xb.closeElement("table");
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        for (Row row : this.rows) {
            row.readFromRequest(req);
        }
    }

    @Override
    public boolean validate() {
        boolean result = true;
        for (Row row : this.rows) {
            result = row.validate() && result;
        }
        return result;
    }

    @Override
    public void readFromObject(Object obj) {
        block5: {
            Class<?> clazz;
            block4: {
                int i;
                clazz = obj.getClass();
                if (!clazz.isArray()) break block4;
                int arrayLength = Array.getLength(obj);
                for (i = 0; i < arrayLength; ++i) {
                    Object currentObj = Array.get(obj, i);
                    this.rows[i].readFromObject(currentObj);
                }
                for (i = arrayLength; i < this.rows.length; ++i) {
                    this.rows[i].readFromObject(null);
                }
                break block5;
            }
            if (!Collection.class.isAssignableFrom(clazz)) break block5;
            Collection collection = (Collection)obj;
            int i = 0;
            for (Object currentObj : collection) {
                this.rows[i].readFromObject(currentObj);
                ++i;
            }
            while (i < this.rows.length) {
                this.rows[i].readFromObject(null);
                ++i;
            }
        }
    }

    @Override
    public void writeToObject(Object obj) {
        block3: {
            Class<?> clazz;
            block2: {
                clazz = obj.getClass();
                if (!clazz.isArray()) break block2;
                int arrayLength = Array.getLength(obj);
                for (int i = 0; i < arrayLength; ++i) {
                    Object currentObj = Array.get(obj, i);
                    this.rows[i].writeToObject(currentObj);
                }
                break block3;
            }
            if (!Collection.class.isAssignableFrom(clazz)) break block3;
            Collection collection = (Collection)obj;
            int i = 0;
            for (Object currentObj : collection) {
                this.rows[i].writeToObject(currentObj);
                ++i;
            }
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public TextFormat getKeyGenerator() {
        return this.keyTextFormat;
    }

    public void setKeyGenerator(TextFormat keyTextFormat) {
        this.keyTextFormat = keyTextFormat;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isCondensed() {
        return this.condensed;
    }

    public void setCondensed(boolean condensed) {
        this.condensed = condensed;
    }

    public boolean isStriped() {
        return this.striped;
    }

    public void setStriped(boolean striped) {
        this.striped = striped;
    }

    public class Row
    extends AbstractCompositeElement<Field> {
        public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
        protected String key;
        protected final int index;

        public Row(int index) {
            super(TableForm.this.columns.length);
            this.index = index;
        }

        @Override
        public void toXhtml(@NotNull XhtmlBuffer xb) {
            xb.openElement("tr");
            if (TableForm.this.selectable) {
                Object[] inputNameArgs = new String[]{TableForm.this.prefix, "selection"};
                String id = RandomUtil.createRandomId(10) + this.index;
                String selection = StringUtils.join((Object[])inputNameArgs);
                xb.openElement("td");
                xb.openElement("div");
                xb.addAttribute("class", "selection-cell squared-light ");
                xb.writeInputCheckbox(id, selection, this.key, false, false, null, String.valueOf(this.index));
                xb.openElement("label");
                xb.addAttribute("for", id);
                xb.closeElement("label");
                xb.closeElement("div");
                xb.closeElement("td");
            }
            for (Field current : this) {
                xb.openElement("td");
                if (!current.getErrors().isEmpty()) {
                    xb.addAttribute("class", "has-error");
                }
                current.valueToXhtml(xb);
                current.errorsToXhtml(xb);
                xb.closeElement("td");
            }
            xb.closeElement("tr");
        }

        @Override
        public void readFromRequest(HttpServletRequest req) {
            for (Field current : this) {
                current.readFromRequest(req);
            }
        }

        @Override
        public boolean validate() {
            boolean result = true;
            for (Field current : this) {
                result = current.validate() && result;
            }
            return result;
        }

        @Override
        public void readFromObject(Object obj) {
            this.key = TableForm.this.keyTextFormat == null ? Integer.toString(this.index) : TableForm.this.keyTextFormat.format(obj);
            int index = 0;
            for (Field field : this) {
                Column column = TableForm.this.columns[index];
                TextFormat hrefTextFormat = column.getHrefTextFormat();
                TextFormat titleTextFormat = column.getTitleTextFormat();
                if (hrefTextFormat != null) {
                    field.setHref(hrefTextFormat.format(obj));
                    if (titleTextFormat != null) {
                        field.setTitle(titleTextFormat.format(obj));
                    }
                }
                field.readFromObject(obj);
                ++index;
            }
        }

        @Override
        public void writeToObject(Object obj) {
            for (Field current : this) {
                current.writeToObject(obj);
            }
        }

        public String getKey() {
            return this.key;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public class Column {
        public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
        protected final PropertyAccessor propertyAccessor;
        protected String label;
        protected String title;
        protected TextFormat headerTextFormat;
        protected TextFormat hrefTextFormat;
        protected TextFormat titleTextFormat;

        public Column(PropertyAccessor propertyAccessor) {
            this.propertyAccessor = propertyAccessor;
            this.label = FieldUtils.getLabel(propertyAccessor);
            if (propertyAccessor.isAnnotationPresent(Help.class)) {
                this.title = propertyAccessor.getAnnotation(Help.class).value();
            }
        }

        public PropertyAccessor getPropertyAccessor() {
            return this.propertyAccessor;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getActualLabel() {
            boolean capitalize = ElementsProperties.getConfiguration().getBoolean("fields.label.capitalize");
            if (capitalize) {
                return StringUtils.capitalize((String)this.label);
            }
            return this.label;
        }

        public TextFormat getHeaderTextFormat() {
            return this.headerTextFormat;
        }

        public void setHeaderTextFormat(TextFormat headerTextFormat) {
            this.headerTextFormat = headerTextFormat;
        }

        public TextFormat getHrefTextFormat() {
            return this.hrefTextFormat;
        }

        public void setHrefTextFormat(TextFormat hrefTextFormat) {
            this.hrefTextFormat = hrefTextFormat;
        }

        public TextFormat getTitleTextFormat() {
            return this.titleTextFormat;
        }

        public void setTitleTextFormat(TextFormat altTextFormat) {
            this.titleTextFormat = altTextFormat;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

