/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.forms;

import com.manydesigns.elements.KeyValueAccessor;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.composites.AbstractCompositeElement;
import com.manydesigns.elements.forms.FieldSet;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Form
extends AbstractCompositeElement<FieldSet> {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final Mode mode;

    public Form(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        for (FieldSet current : this) {
            current.toXhtml(xb);
        }
    }

    public boolean isRequiredFieldsPresent() {
        for (FieldSet current : this) {
            if (!current.isRequiredFieldsPresent()) continue;
            return true;
        }
        return false;
    }

    public boolean isMultipartRequest() {
        for (FieldSet current : this) {
            if (!current.isMultipartRequest()) continue;
            return true;
        }
        return false;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void readFrom(KeyValueAccessor accessor) {
        for (FieldSet current : this) {
            current.readFrom(accessor);
        }
    }

    public void writeTo(KeyValueAccessor accessor) {
        for (FieldSet current : this) {
            current.writeTo(accessor);
        }
    }

    public Map<String, Object> getValue() {
        HashMap<String, Object> value = new HashMap<String, Object>();
        for (FieldSet current : this) {
            value.put(current.getName(), current.getValue());
        }
        return value;
    }
}

