/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class FileBean {
    private String contentType;
    private String fileName;
    private File file;
    private String charset;
    private boolean saved;

    public FileBean(File file, String contentType, String originalName) {
        this.file = file;
        this.contentType = contentType;
        this.fileName = originalName;
    }

    public FileBean(File file, String contentType, String originalName, String charset) {
        this.file = file;
        this.contentType = contentType;
        this.fileName = originalName;
        this.charset = charset;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSize() {
        return this.file.length();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public Reader getReader() throws UnsupportedEncodingException, IOException {
        if (this.charset == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return this.getReader(this.charset);
    }

    public Reader getReader(String charset) throws UnsupportedEncodingException, IOException {
        return new InputStreamReader(this.getInputStream(), charset);
    }

    public void save(File toFile) throws IOException {
        if (!this.file.exists()) {
            throw new IOException("Some time between uploading and saving we lost the file " + this.file.getAbsolutePath() + " - where did it go?.");
        }
        if (!this.file.canWrite()) {
            throw new IOException("Some time between uploading and saving we lost the ability to write to the file " + this.file.getAbsolutePath() + " - writability is required to move the file.");
        }
        File parent = toFile.getAbsoluteFile().getParentFile();
        if (toFile.exists() && !toFile.canWrite()) {
            throw new IOException("Cannot overwrite existing file at " + toFile.getAbsolutePath());
        }
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Parent directory of specified file does not exist and cannot  be created. File location supplied: " + toFile.getAbsolutePath());
        }
        if (!toFile.exists() && !parent.canWrite()) {
            throw new IOException("Cannot create new file at location: " + toFile.getAbsolutePath());
        }
        this.saved = this.file.renameTo(toFile);
        if (!this.saved) {
            this.saveViaCopy(toFile);
        }
    }

    protected void saveViaCopy(File toFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(toFile);
             FileInputStream in = new FileInputStream(this.file);){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, count);
            }
            ((OutputStream)out).close();
            ((InputStream)in).close();
            this.file.delete();
            this.saved = true;
        }
    }

    public void delete() throws IOException {
        if (!this.saved) {
            if (!this.file.exists()) {
                throw new IOException("Some time between uploading and saving we lost the file " + this.file.getAbsolutePath() + " - where did it go?.");
            }
            if (!this.file.canWrite()) {
                throw new IOException("Some time between uploading and saving we lost the ability to write to the file " + this.file.getAbsolutePath() + " - writability is required to delete the file.");
            }
            this.file.delete();
        }
    }

    public String toString() {
        return "FileBean{contentType='" + this.contentType + "', fileName='" + this.fileName + "'}";
    }
}

