/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.search;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.annotations.Id;
import com.manydesigns.elements.annotations.InputName;
import com.manydesigns.elements.annotations.Required;
import com.manydesigns.elements.fields.FieldUtils;
import com.manydesigns.elements.fields.search.SearchField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchField
implements SearchField {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final PropertyAccessor accessor;
    protected String id;
    protected String inputName;
    protected String label;
    protected boolean required;
    public static final Logger logger = LoggerFactory.getLogger(AbstractSearchField.class);
    public static final String ATTR_NAME_HTML_CLASS = "control-label";
    public static final String FORM_CONTROL_CSS_CLASS = "form-control";

    public AbstractSearchField(PropertyAccessor accessor) {
        this(accessor, null);
    }

    public AbstractSearchField(PropertyAccessor accessor, String prefix) {
        this.accessor = accessor;
        String localId = accessor.isAnnotationPresent(Id.class) ? accessor.getAnnotation(Id.class).value() : accessor.getName();
        Object[] idArgs = new Object[]{prefix, localId};
        this.id = StringUtils.join((Object[])idArgs);
        String localInputName = accessor.isAnnotationPresent(InputName.class) ? accessor.getAnnotation(InputName.class).value() : accessor.getName();
        Object[] inputNameArgs = new Object[]{prefix, localInputName};
        this.inputName = StringUtils.join((Object[])inputNameArgs);
        this.label = FieldUtils.getLabel(accessor);
        Required requiredAnnotation = accessor.getAnnotation(Required.class);
        if (requiredAnnotation != null) {
            this.required = requiredAnnotation.value();
            logger.debug("Required annotation present with value: {}", (Object)this.required);
        }
    }

    public String getText(String key, Object ... args) {
        return ElementsThreadLocals.getTextProvider().getText(key, args);
    }

    @Override
    public void readFromObject(Object obj) {
    }

    @Override
    public void writeToObject(Object obj) {
    }

    @Override
    public PropertyAccessor getPropertyAccessor() {
        return this.accessor;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    protected void appendToSearchString(StringBuilder sb, String name, String value, String encoding) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        try {
            sb.append(URLEncoder.encode(name, encoding));
            sb.append("=");
            sb.append(URLEncoder.encode(value, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

