/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.util;

import com.manydesigns.elements.FormElement;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.fields.TextField;
import com.manydesigns.elements.forms.FieldSet;
import com.manydesigns.elements.forms.Form;
import com.manydesigns.elements.json.JsonKeyValueAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.joda.time.DateTime;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONWriter;

public class FormUtil {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String JSON_VALUE = "value";
    public static final String JSON_TYPE = "type";

    public static void fieldsToJson(JSONStringer js, Collection<Field> fields) throws JSONException {
        for (Field field : fields) {
            Object value = field.getValue();
            if (value instanceof Date) {
                value = ((Date)value).getTime();
            }
            if (value instanceof DateTime) {
                value = ((DateTime)value).getMillis();
            }
            String displayValue = field.getDisplayValue();
            String href = field.getHref();
            List<String> errors = field.getErrors();
            js.key(field.getPropertyAccessor().getName());
            JSONWriter json = js.object().key(JSON_VALUE);
            if (value instanceof Blob) {
                json.object();
                Blob blob = (Blob)value;
                json.key(JSON_TYPE).value((Object)Blob.class.getName());
                json.key("code").value((Object)blob.getCode());
                json.key("filename").value((Object)blob.getFilename());
                json.key("contentType").value((Object)blob.getContentType());
                json.key("size").value(blob.getSize());
                json.endObject();
            } else {
                json.value(value);
            }
            if (displayValue != null && !ObjectUtils.equals((Object)displayValue, value)) {
                json.key("displayValue").value((Object)displayValue);
            }
            if (href != null) {
                json.key("href").value((Object)href);
            }
            if (!errors.isEmpty()) {
                json.key("errors").array();
                for (String error : errors) {
                    json.value((Object)error);
                }
                json.endArray();
            }
            json.endObject();
        }
    }

    public static List<Field> collectVisibleFields(Form form, List<Field> fields) {
        for (FieldSet fieldSet : form) {
            FormUtil.collectVisibleFields(fieldSet, fields);
        }
        return fields;
    }

    public static List<Field> collectVisibleFields(FieldSet fieldSet, List<Field> fields) {
        for (FormElement element : fieldSet) {
            if (element instanceof Field) {
                Field field = (Field)element;
                if (!field.isEnabled()) continue;
                fields.add(field);
                continue;
            }
            if (!(element instanceof FieldSet)) continue;
            FormUtil.collectVisibleFields((FieldSet)((Object)element), fields);
        }
        return fields;
    }

    public static String writeToJson(Form form) {
        JSONStringer js = new JSONStringer();
        js.object();
        FormUtil.writeToJson(form, js);
        js.endObject();
        return js.toString();
    }

    public static void writeToJson(Form form, JSONStringer js) {
        ArrayList<Field> fields = new ArrayList<Field>();
        FormUtil.collectVisibleFields(form, fields);
        FormUtil.fieldsToJson(js, fields);
    }

    public static Form readFromJson(Form form, JSONObject jsonObject) {
        JsonKeyValueAccessor kv = new JsonKeyValueAccessor(jsonObject){

            @Override
            public Object get(String name) {
                Object o = super.get(name);
                if (o instanceof JSONObject) {
                    JSONObject subObj = (JSONObject)o;
                    if (subObj.has(FormUtil.JSON_TYPE)) {
                        return null;
                    }
                    return new JsonKeyValueAccessor(subObj).get(FormUtil.JSON_VALUE);
                }
                return o;
            }

            @Override
            public void set(String name, Object value) {
                Object o = super.get(name);
                if (o instanceof JSONObject) {
                    new JsonKeyValueAccessor((JSONObject)o).set(FormUtil.JSON_VALUE, value);
                } else {
                    super.set(name, value);
                }
            }
        };
        form.readFrom(kv);
        return form;
    }

    public static List<TextField> collectEditableRichTextFields(Form form) {
        ArrayList<TextField> richTextFields = new ArrayList<TextField>();
        for (FieldSet fieldSet : form) {
            for (FormElement field : fieldSet) {
                if (!(field instanceof TextField) || !((TextField)field).isEnabled() || form.getMode().isView(((TextField)field).isInsertable(), ((TextField)field).isUpdatable()) || !((TextField)field).isRichText()) continue;
                richTextFields.add((TextField)field);
            }
        }
        return richTextFields;
    }
}

