/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.crypto;

import com.manydesigns.elements.crypto.InvalidPassphraseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CryptoUtils {
    private static final Logger logger = LoggerFactory.getLogger(CryptoUtils.class);
    private static final int PASS_MIN_LEN = 8;

    CryptoUtils() {
    }

    protected static String getKey(String filename) throws IOException {
        String strKey = "";
        try (BufferedReader br = new BufferedReader(new FileReader(filename));){
            String line;
            while ((line = br.readLine()) != null) {
                strKey = strKey + line + "\n";
            }
        }
        catch (IOException e) {
            logger.error("getKey from " + filename + ": " + e.getMessage());
            throw e;
        }
        return strKey;
    }

    static void checkPassphrase(String pass) throws InvalidPassphraseException {
        if (pass == null) {
            throw new InvalidPassphraseException("Passphrase is null");
        }
        if (pass.equals("")) {
            throw new InvalidPassphraseException("Passphrase is empty");
        }
        if (pass.length() < 8) {
            throw new InvalidPassphraseException("Passphrase too short, it should be at least 8 chars");
        }
        if (!StringUtils.isAlphanumeric((String)pass)) {
            throw new InvalidPassphraseException("Passphrase not alphanumeric");
        }
    }

    static void secureDeleteFile(String path) throws FileNotFoundException {
        logger.info("DELETING " + path);
        try (PrintWriter pw = new PrintWriter(path);){
            pw.print("");
        }
        File f = new File(path);
        if (f.delete()) {
            logger.info("DELETED" + path);
        } else {
            logger.info("COULD NOT DELETE" + path);
        }
    }

    static String getStringChecksum(MessageDigest digest, String text) throws IOException {
        byte[] bytes = digest.digest(text.getBytes());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

