/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.configuration;

import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanLookup
implements Lookup {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final Object bean;
    protected final ClassAccessor accessor;
    public static final Logger logger = LoggerFactory.getLogger(BeanLookup.class);

    public BeanLookup(Object bean) {
        this.bean = bean;
        Class<?> clazz = bean.getClass();
        this.accessor = JavaClassAccessor.getClassAccessor(clazz);
    }

    public String lookup(String key) {
        try {
            PropertyAccessor property = this.accessor.getProperty(key);
            return ObjectUtils.toString((Object)property.get(this.bean));
        }
        catch (NoSuchFieldException e) {
            logger.warn("Cannot access property '{}' on class '{}'", (Object)key, (Object)this.accessor.getName());
            return null;
        }
    }
}

