/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.reflection.AbstractAnnotatedAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.lang.annotation.Annotation;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

public class OGNLPropertyAccessor
extends AbstractAnnotatedAccessor
implements PropertyAccessor {
    protected final String name;
    protected final Class type;
    protected final String expression;
    protected final Object parsedExpression;
    protected OgnlContext ognlContext;
    protected int modifiers;

    public OGNLPropertyAccessor(String name, Class type, String expression, OgnlContext ognlContext) throws OgnlException {
        this.name = name;
        this.type = type;
        this.expression = expression;
        this.parsedExpression = Ognl.parseExpression((String)expression);
        this.ognlContext = ognlContext;
    }

    public OGNLPropertyAccessor(String name, Class type, String expression) throws OgnlException {
        this(name, type, expression, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public OgnlContext getOgnlContext() {
        return this.ognlContext;
    }

    public void setOgnlContext(OgnlContext ognlContext) {
        this.ognlContext = ognlContext;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public Object get(Object obj) {
        try {
            return Ognl.getValue((Object)this.parsedExpression, (Map)this.getActualOgnlContext(), (Object)obj, (Class)this.type);
        }
        catch (OgnlException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(Object obj, Object value) {
        try {
            Object convertedValue = OgnlUtils.convertValue(value, this.type);
            Ognl.setValue((Object)this.parsedExpression, (Map)this.getActualOgnlContext(), (Object)obj, convertedValue);
        }
        catch (OgnlException e) {
            throw new RuntimeException(e);
        }
    }

    public OgnlContext getActualOgnlContext() {
        return this.ognlContext != null ? this.ognlContext : ElementsThreadLocals.getOgnlContext();
    }

    public OGNLPropertyAccessor configureAnnotation(Annotation annotation) {
        this.annotations.put(annotation.annotationType(), annotation);
        return this;
    }
}

