/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.messages;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.xml.XhtmlBuffer;
import com.manydesigns.elements.xml.XhtmlFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMessages {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final String INFO_MESSAGES_KEY = "info_messages_key";
    public static final String WARNING_MESSAGES_KEY = "warning_messages_key";
    public static final String ERROR_MESSAGES_KEY = "error_messages_key";
    public static final Logger logger = LoggerFactory.getLogger(RequestMessages.class);

    public static void addInfoMessage(String msg) {
        RequestMessages.getInfoQueue().add(StringEscapeUtils.escapeXml((String)msg));
    }

    public static void addInfoMessage(XhtmlFragment xml) {
        XhtmlBuffer buf = new XhtmlBuffer();
        xml.toXhtml(buf);
        RequestMessages.getInfoQueue().add(buf.toString());
    }

    public static void addWarningMessage(String msg) {
        RequestMessages.getWarningQueue().add(StringEscapeUtils.escapeXml((String)msg));
    }

    public static void addWarningMessage(XhtmlFragment xml) {
        XhtmlBuffer buf = new XhtmlBuffer();
        xml.toXhtml(buf);
        RequestMessages.getWarningQueue().add(buf.toString());
    }

    public static void addErrorMessage(String msg) {
        RequestMessages.getErrorQueue().add(StringEscapeUtils.escapeXml((String)msg));
    }

    public static void addErrorMessage(XhtmlFragment xml) {
        XhtmlBuffer buf = new XhtmlBuffer();
        xml.toXhtml(buf);
        RequestMessages.getErrorQueue().add(buf.toString());
    }

    public static List<String> consumeInfoMessages() {
        ArrayList<String> result = new ArrayList<String>();
        RequestMessages.getInfoQueue().drainTo(result);
        return result;
    }

    public static List<String> consumeWarningMessages() {
        ArrayList<String> result = new ArrayList<String>();
        RequestMessages.getWarningQueue().drainTo(result);
        return result;
    }

    public static List<String> consumeErrorMessages() {
        ArrayList<String> result = new ArrayList<String>();
        RequestMessages.getErrorQueue().drainTo(result);
        return result;
    }

    public static BlockingQueue<String> getInfoQueue() {
        return RequestMessages.getQueue(INFO_MESSAGES_KEY);
    }

    public static BlockingQueue<String> getWarningQueue() {
        return RequestMessages.getQueue(WARNING_MESSAGES_KEY);
    }

    public static BlockingQueue<String> getErrorQueue() {
        return RequestMessages.getQueue(ERROR_MESSAGES_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BlockingQueue<String> getQueue(String queueName) {
        LinkedBlockingQueue<String> infoQueue;
        HttpServletRequest req = ElementsThreadLocals.getHttpServletRequest();
        if (req == null) {
            logger.debug("No request available. Returning dummy queue.");
            return new LinkedBlockingQueue<String>();
        }
        HttpServletRequest httpServletRequest = req;
        synchronized (httpServletRequest) {
            infoQueue = (LinkedBlockingQueue<String>)req.getAttribute(queueName);
            if (infoQueue == null) {
                infoQueue = new LinkedBlockingQueue<String>();
                req.setAttribute(queueName, infoQueue);
            }
        }
        return infoQueue;
    }
}

