/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.crypto;

import java.io.BufferedReader;
import java.io.Console;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManager {
    public static final Logger logger = LoggerFactory.getLogger(KeyManager.class);
    private static final String PROPERTY_ALG = "com.manydesigns.crypto.algrorithm";
    private static final String PROPERTY_PRIVATE_KEY = "com.manydesigns.crypto.private.key";
    private static final String PROPERTY_PUBLIC_KEY = "com.manydesigns.crypto.public.key";
    private static final String PROPERTY_PRIVATE_KEY_DELETE = "com.manydesigns.crypto.delete.key";
    private static final String PROPERTY_PASSPHRASE = "com.manydesigns.crypto.passphrase";
    private static final String ASYMMETRIC_ALG = "ASIM";
    private static final String SYMMETRIC_ALG = "SIM";
    private static final int PASS_MIN_LEN = 8;
    private SecretKey simmK;
    private PublicKey pbK;
    private PrivateKey prK;
    private String algo;
    private static KeyManager single;

    private KeyManager(Configuration configuration) throws GeneralSecurityException, IOException {
        block31: {
            this.algo = configuration.getString(PROPERTY_ALG);
            if (this.algo == null) {
                return;
            }
            boolean autoDelete = configuration.getBoolean(PROPERTY_PRIVATE_KEY_DELETE, false);
            String publicKeyPath = configuration.getString(PROPERTY_PUBLIC_KEY);
            String privateKeyPath = configuration.getString(PROPERTY_PRIVATE_KEY);
            String passphrasePath = configuration.getString(PROPERTY_PASSPHRASE);
            if (this.algo.equals(ASYMMETRIC_ALG)) {
                this.prK = KeyManager.getPrivateKey(privateKeyPath);
                this.pbK = KeyManager.getPublicKey(publicKeyPath);
                this.simmK = null;
            } else {
                String strK = this.getPassPhrase(passphrasePath);
                byte[] key = strK.getBytes(StandardCharsets.UTF_8);
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                key = sha.digest(key);
                key = Arrays.copyOf(key, 16);
                this.simmK = new SecretKeySpec(key, "AES");
            }
            if (autoDelete && passphrasePath != null) {
                try {
                    Throwable throwable;
                    PrintWriter pw;
                    if (this.algo.equals(ASYMMETRIC_ALG)) {
                        logger.info("DELETING " + privateKeyPath);
                        pw = new PrintWriter(privateKeyPath);
                        throwable = null;
                        try {
                            pw.print("");
                            break block31;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (pw != null) {
                                if (throwable != null) {
                                    try {
                                        pw.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    pw.close();
                                }
                            }
                        }
                    }
                    logger.info("DELETING " + passphrasePath);
                    pw = new PrintWriter(passphrasePath);
                    throwable = null;
                    try {
                        pw.print("");
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (pw != null) {
                            if (throwable != null) {
                                try {
                                    pw.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                pw.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static KeyManager init(Configuration configuration) throws IOException, GeneralSecurityException {
        if (KeyManager.isActive()) {
            throw new GeneralSecurityException("Key manager already initialized");
        }
        single = new KeyManager(configuration);
        return KeyManager.getInstance();
    }

    public static KeyManager getInstance() throws IOException, GeneralSecurityException {
        if (single == null) {
            throw new GeneralSecurityException("Key manager not initialized");
        }
        return single;
    }

    public static boolean isActive() {
        return single != null;
    }

    public SecretKey getSimmK() {
        return this.simmK;
    }

    public PublicKey getPbKey() {
        return this.pbK;
    }

    public PrivateKey getPrKey() {
        return this.prK;
    }

    public String getAlgo() {
        return this.algo;
    }

    private static String getKey(String filename) throws IOException {
        String strKeyPEM = "";
        try (BufferedReader br = new BufferedReader(new FileReader(filename));){
            String line;
            while ((line = br.readLine()) != null) {
                strKeyPEM = strKeyPEM + line + "\n";
            }
        }
        return strKeyPEM;
    }

    private static PrivateKey getPrivateKey(String filename) throws IOException, GeneralSecurityException {
        String privateKeyPEM = KeyManager.getKey(filename);
        return KeyManager.getPrivateKeyFromString(privateKeyPEM);
    }

    private static PrivateKey getPrivateKeyFromString(String key) throws IOException, GeneralSecurityException {
        String privateKeyPEM = key;
        privateKeyPEM = privateKeyPEM.replace("-----BEGIN PRIVATE KEY-----\n", "");
        privateKeyPEM = privateKeyPEM.replace("-----END PRIVATE KEY-----", "");
        byte[] encoded = Base64.getDecoder().decode(privateKeyPEM.getBytes());
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        return kf.generatePrivate(keySpec);
    }

    private static PublicKey getPublicKey(String filename) throws IOException, GeneralSecurityException {
        String publicKeyPEM = KeyManager.getKey(filename);
        return KeyManager.getPublicKeyFromString(publicKeyPEM);
    }

    private static PublicKey getPublicKeyFromString(String key) throws IOException, GeneralSecurityException {
        String publicKeyPEM = key;
        publicKeyPEM = publicKeyPEM.replace("-----BEGIN PUBLIC KEY-----\n", "");
        publicKeyPEM = publicKeyPEM.replace("-----END PUBLIC KEY-----", "");
        byte[] encoded = Base64.getDecoder().decode(publicKeyPEM.getBytes());
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(new X509EncodedKeySpec(encoded));
    }

    private String getPassPhrase(String passphrasePath) {
        StringBuilder passPhrase;
        block16: {
            logger.info("Retrieving passphrase");
            passPhrase = new StringBuilder();
            if (passphrasePath != null) {
                try (BufferedReader br = new BufferedReader(new FileReader(passphrasePath));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        passPhrase.append(line);
                    }
                    break block16;
                }
                catch (IOException e) {
                    logger.error("getPassPhrase: " + e.getMessage(), (Throwable)e);
                    logger.debug("prompt passphrase");
                    return this.getInputPassphrase();
                }
            }
            logger.debug("passphrasePath null, prompt passphrase");
            return this.getInputPassphrase();
        }
        return passPhrase.toString();
    }

    private String getInputPassphrase() {
        String pass = null;
        Console console = System.console();
        if (console != null) {
            logger.debug("Reading from System.console");
            console.printf("_______________________________________________________\n\n ENTER PASSPHRASE: \n", new Object[0]);
            pass = new String(console.readPassword());
            console.printf("_______________________________________________________\n", new Object[0]);
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("_______________________________________________________\n\n ENTER PASSPHRASE: \n");
            try {
                logger.debug("Reading from System.in");
                pass = br.readLine();
                System.out.print("_______________________________________________________\n");
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (pass != null && pass.length() < 8) {
            logger.warn("Passphrase too short, it should be at least 8 chars");
            return this.getInputPassphrase();
        }
        return pass;
    }
}

