/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.crypto;

import com.manydesigns.elements.crypto.KeyManager;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class CryptoService {
    private String typeAlgo = "AES";
    private static CryptoService single;

    public String getTypeAlgo() {
        return this.typeAlgo;
    }

    public static CryptoService getInstance() {
        if (single == null) {
            single = new CryptoService();
        }
        return single;
    }

    private SecretKey getkey() throws GeneralSecurityException, IOException {
        return KeyManager.getInstance().getSimmK();
    }

    public String encrypt(String decrypted) throws GeneralSecurityException, IOException {
        return new String(Base64.getEncoder().encode(this.encrypt(decrypted.getBytes())));
    }

    public String decrypt(String encrypted) throws GeneralSecurityException, IOException {
        return new String(this.decrypt(Base64.getDecoder().decode(encrypted.getBytes())));
    }

    public byte[] encrypt(byte[] decrypted) throws GeneralSecurityException, IOException {
        return CryptoService.encrypt(decrypted, this.typeAlgo, this.getkey());
    }

    public byte[] decrypt(byte[] encrypted) throws GeneralSecurityException, IOException {
        return CryptoService.decrypt(encrypted, this.typeAlgo, this.getkey());
    }

    public InputStream encrypt(InputStream decrypted) throws GeneralSecurityException, IOException {
        return CryptoService.encrypt(decrypted, this.typeAlgo, this.getkey());
    }

    public InputStream decrypt(InputStream encrypted) throws GeneralSecurityException, IOException {
        return CryptoService.decrypt(encrypted, this.typeAlgo, this.getkey());
    }

    public static byte[] encrypt(byte[] decrypted, String algorithm, SecretKey key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, key);
        return cipher.doFinal(decrypted);
    }

    public static byte[] decrypt(byte[] encrypted, String algorithm, SecretKey key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, key);
        return cipher.doFinal(encrypted);
    }

    public static InputStream decrypt(InputStream encryptedInputStream, String algorithm, SecretKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, key);
        return new CipherInputStream(encryptedInputStream, cipher);
    }

    public static InputStream encrypt(InputStream decryptedInputStream, String algorithm, SecretKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, key);
        return new CipherInputStream(decryptedInputStream, cipher);
    }

    public long getFileSize(Long originalSize) {
        double value = Math.ceil(originalSize.doubleValue() / 16.0) * 16.0;
        return (long)value;
    }
}

