/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.configuration;

import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonsConfigurationUtils.class);

    public static void save(Configuration configuration) throws ConfigurationException {
        FileConfiguration fileConfiguration = CommonsConfigurationUtils.getWritableFileConfiguration(configuration);
        if (fileConfiguration == null) {
            throw new ConfigurationException("Cannot save configuration");
        }
        fileConfiguration.save();
        logger.info("Configuration saved to {}", (Object)fileConfiguration.getFile().getAbsolutePath());
    }

    public static FileConfiguration getWritableFileConfiguration(Configuration configuration) {
        if (configuration instanceof FileConfiguration) {
            return (FileConfiguration)configuration;
        }
        if (configuration instanceof CompositeConfiguration) {
            CompositeConfiguration compositeConfiguration = (CompositeConfiguration)configuration;
            Configuration inMemoryConfigutation = compositeConfiguration.getInMemoryConfiguration();
            return CommonsConfigurationUtils.getWritableFileConfiguration(inMemoryConfigutation);
        }
        return null;
    }
}

