/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.util;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.xml.XhtmlBuffer;
import com.manydesigns.elements.xml.XhtmlFragment;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrTokenizer;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    public static final String copyright = "Copyright (C) 2005-2017 ManyDesigns srl";
    protected static final String STRING_PATTERN = "\"(([^\"\\\\]|\\\\.)*)\"";
    protected static final Pattern stringPattern = Pattern.compile("\"(([^\"\\\\]|\\\\.)*)\"");
    protected static final Pattern stringArrayPattern = Pattern.compile("\\s*\\{\\s*(\"(([^\"\\\\]|\\\\.)*)\"\\s*(,\\s*\"(([^\"\\\\]|\\\\.)*)\"\\s*)*)?\\}\\s*");
    protected static final Pattern pattern = Pattern.compile("\\p{Alpha}*:");
    protected static final Pattern BAD_UNICODE_CHARS_PATTERN = Pattern.compile("[\u2013\u2014\u2018\u2019\u0092\u201c\u201d\u2022\u2026\u0093\u0094]", 2);
    public static final Logger logger = LoggerFactory.getLogger(Util.class);
    public static final Pattern linkPattern = Pattern.compile("(http://|https://|ftp://|www\\.)[^\\s,)]+", 2);
    public static final Pattern emailPattern = Pattern.compile("[a-z0-9\\-_]++(\\.[a-z0-9\\-_]++)*@[a-z0-9\\-_]++(\\.[a-z0-9\\-_]++)++", 2);

    public static String getAbsoluteUrl(HttpServletRequest req, String url, boolean full) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(url);
        if (matcher.lookingAt()) {
            return url;
        }
        if (!"/".equals(req.getContextPath())) {
            sb.append(req.getContextPath());
        }
        if (!url.startsWith("/")) {
            sb.append("/");
        }
        sb.append(url);
        if (full) {
            logger.debug("Building full url including scheme and port");
            StringBuilder tsb = new StringBuilder();
            String scheme = req.getScheme();
            int serverPort = req.getServerPort();
            tsb.append(scheme);
            tsb.append("://");
            tsb.append(req.getServerName());
            if ("http".equals(scheme) && serverPort == 80 || "https".equals(scheme) && serverPort == 443) {
                logger.debug("Skipping default port for scheme: {}", (Object)scheme);
            } else {
                logger.debug("Adding port number: {}", (Object)serverPort);
                tsb.append(":");
                tsb.append(serverPort);
            }
            sb.insert(0, tsb);
        }
        return sb.toString();
    }

    public static String getAbsoluteUrl(String url) {
        return Util.getAbsoluteUrl(url, false);
    }

    public static String getAbsoluteUrl(String url, boolean full) {
        HttpServletRequest req = ElementsThreadLocals.getHttpServletRequest();
        return Util.getAbsoluteUrl(req, url, full);
    }

    public static String camelCaseToWords(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (first) {
                first = false;
                sb.append(c);
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append(' ');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String guessToWords(String s) {
        if (s == null) {
            return null;
        }
        if (Util.isAllLowerCase(s) || Util.isAllUpperCase(s)) {
            return Util.letterOrDigitToWords(s);
        }
        return Util.camelCaseToWords(s);
    }

    public static String letterOrDigitToWords(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    static boolean isAllUpperCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    static boolean isAllLowerCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetter(c) || !Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static String urlencode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static void printMatcher(Matcher matcher) {
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            logger.debug("group {}: {}", (Object)i, (Object)matcher.group(i));
        }
    }

    public static String[] matchStringArray(String text) {
        StrTokenizer strTokenizer = StrTokenizer.getCSVInstance((String)text);
        return strTokenizer.getTokenArray();
    }

    public static boolean isNumericType(Class type) {
        return Number.class.isAssignableFrom(type) || type == Integer.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE;
    }

    public static String elementToString(XhtmlFragment element) {
        XhtmlBuffer xb = new XhtmlBuffer();
        element.toXhtml(xb);
        return xb.toString();
    }

    public static int compare(String one, String two) {
        if (one == null && two == null) {
            return 0;
        }
        if (two == null) {
            return -1;
        }
        if (one == null) {
            return 1;
        }
        int lenone = one.length();
        int lentwo = two.length();
        StringBuilder numberOne = new StringBuilder();
        StringBuilder numberTwo = new StringBuilder();
        int i = 0;
        for (int j = 0; i < lenone && j < lentwo; ++i, ++j) {
            if (Character.isDigit(one.charAt(i))) {
                if (Character.isDigit(two.charAt(j))) {
                    numberOne.setLength(0);
                    numberTwo.setLength(0);
                    while (i < lenone && Character.isDigit(one.charAt(i))) {
                        numberOne.append(one.charAt(i));
                        ++i;
                    }
                    while (j < lentwo && Character.isDigit(two.charAt(j))) {
                        numberTwo.append(two.charAt(j));
                        ++j;
                    }
                    long diff = Long.parseLong(numberOne.toString()) - Long.parseLong(numberTwo.toString());
                    if (diff > 0L) {
                        return 1;
                    }
                    if (diff >= 0L) continue;
                    return -1;
                }
                return -1;
            }
            if (Character.isDigit(two.charAt(j))) {
                return 1;
            }
            int diff = Character.toUpperCase(one.charAt(i)) - Character.toUpperCase(two.charAt(j));
            if (diff == 0) continue;
            return diff;
        }
        return lenone - lentwo;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return Util.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static StringBuilder replaceBadUnicodeCharacters(String source, StringBuilder dest) {
        Matcher m = BAD_UNICODE_CHARS_PATTERN.matcher(source);
        int index = 0;
        while (m.find()) {
            String g = m.group();
            dest.append(source.substring(index, m.end() - 1));
            index = m.end();
            if (g.equals("\u2013") || g.equals("\u2014")) {
                dest.append('-');
                continue;
            }
            if (g.equals("\u2018") || g.equals("\u2019") || g.equals("\u0092")) {
                dest.append('\'');
                continue;
            }
            if (g.equals("\u201c") || g.equals("\u201d")) {
                dest.append('\"');
                continue;
            }
            if (g.equals("\u2022")) {
                dest.append('*');
                continue;
            }
            if (g.equals("\u2026")) {
                dest.append("...");
                continue;
            }
            if (g.equals("\u0093")) {
                dest.append("<<");
                continue;
            }
            if (!g.equals("\u0094")) continue;
            dest.append(">>");
        }
        dest.append(source.substring(index, source.length()));
        return dest;
    }

    public static StringBuilder replaceBadUnicodeCharactersWithHtmlEntities(String source, StringBuilder dest) {
        Matcher m = BAD_UNICODE_CHARS_PATTERN.matcher(source);
        int index = 0;
        while (m.find()) {
            String g = m.group();
            dest.append(source.substring(index, m.end() - 1));
            index = m.end();
            if (g.equals("\u2013")) {
                dest.append("&ndash;");
                continue;
            }
            if (g.equals("\u2014")) {
                dest.append("&mdash;");
                continue;
            }
            if (g.equals("\u2018")) {
                dest.append("&lsquo;");
                continue;
            }
            if (g.equals("\u2019")) {
                dest.append("&rsquo;");
                continue;
            }
            if (g.equals("\u0092")) {
                dest.append("'");
                continue;
            }
            if (g.equals("\u201c")) {
                dest.append("&ldquo;");
                continue;
            }
            if (g.equals("\u201d")) {
                dest.append("&rdquo;");
                continue;
            }
            if (g.equals("\u2022")) {
                dest.append("&bull;");
                continue;
            }
            if (g.equals("\u2026")) {
                dest.append("&hellip;");
                continue;
            }
            if (g.equals("\u0093")) {
                dest.append("&lt;&lt;");
                continue;
            }
            if (!g.equals("\u0094")) continue;
            dest.append("&gt;&gt;");
        }
        dest.append(source.substring(index, source.length()));
        return dest;
    }

    public static String replaceBadUnicodeCharacters(String source) {
        return Util.replaceBadUnicodeCharacters(source, new StringBuilder()).toString();
    }

    public static String replaceBadUnicodeCharactersWithHtmlEntities(String source) {
        return Util.replaceBadUnicodeCharactersWithHtmlEntities(source, new StringBuilder()).toString();
    }

    public static String writeFormattedText(String str, boolean highlightLinks) {
        XhtmlBuffer xb = new XhtmlBuffer();
        Util.writeFormattedText(xb, str, highlightLinks);
        return xb.toString();
    }

    public static void writeFormattedText(XhtmlBuffer xb, String str, boolean highlightLinks) {
        if (str == null) {
            return;
        }
        String[] lines = StringUtils.split((String)str, (String)"\r\n");
        boolean first = true;
        for (String line : lines) {
            if (first) {
                first = false;
            } else {
                xb.writeBr();
            }
            if (highlightLinks) {
                xb.writeNoHtmlEscape(Util.highlightLinks(xb.escape(line)));
                continue;
            }
            xb.write(line);
        }
    }

    public static String highlightLinks(String str) {
        if (str == null) {
            return null;
        }
        Matcher linkMatcher = linkPattern.matcher(str);
        boolean linkFound = false;
        StringBuffer sb = new StringBuffer();
        while (linkMatcher.find()) {
            String text = Util.shortenEscaped(linkMatcher.group(0), 22);
            if (linkMatcher.group(1).equalsIgnoreCase("www.")) {
                linkMatcher.appendReplacement(sb, "<a href=\"http://" + linkMatcher.group(0) + "\">" + text + "</a>");
            } else {
                linkMatcher.appendReplacement(sb, "<a href=\"" + linkMatcher.group(0) + "\">" + text + "</a>");
            }
            linkFound = true;
        }
        if (linkFound) {
            linkMatcher.appendTail(sb);
            str = sb.toString();
            linkFound = false;
            sb = new StringBuffer();
        }
        Matcher emailMatcher = emailPattern.matcher(str);
        while (emailMatcher.find()) {
            emailMatcher.appendReplacement(sb, "<a href=\"mailto:" + emailMatcher.group(0) + "\">" + emailMatcher.group(0) + "</a>");
            linkFound = true;
        }
        if (linkFound) {
            emailMatcher.appendTail(sb);
            str = sb.toString();
        }
        return str;
    }

    public static String shortenEscaped(String text, int maxlen) {
        int pos;
        StringBuilder sb = new StringBuilder();
        int count = 0;
        boolean inEntity = false;
        for (pos = 0; pos < text.length(); ++pos) {
            char c = text.charAt(pos);
            if (c == '&') {
                inEntity = true;
            }
            if (c == ';') {
                inEntity = false;
            }
            sb.append(c);
            if (inEntity) continue;
            ++count;
            if (count < maxlen) continue;
            break;
        }
        if (pos < text.length()) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static DateTime parseDateTime(DateTimeFormatter dateTimeFormatter, String input, boolean withTime) {
        if (withTime) {
            return dateTimeFormatter.parseDateTime(input);
        }
        LocalDate localDate = dateTimeFormatter.parseLocalDate(input);
        return localDate.toDateTimeAtStartOfDay();
    }
}

