/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementsFileUtils {
    public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(ElementsFileUtils.class);

    public static String getRelativePath(File ancestor, File file) {
        return ElementsFileUtils.getRelativePath(ancestor, file, "/");
    }

    public static String getRelativePath(File ancestor, File file, String separator) {
        String path = file.getName();
        for (File parent = file.getParentFile(); parent != null && !parent.equals(ancestor); parent = parent.getParentFile()) {
            path = parent.getName() + separator + path;
        }
        return path;
    }

    public static boolean ensureDirectoryExistsAndWritable(File file) {
        logger.debug("Ensure directory exists and writable: {}", (Object)file);
        if (!ElementsFileUtils.ensureDirectoryExists(file)) {
            return false;
        }
        if (!file.canWrite()) {
            logger.warn("Directory not writable: {}", (Object)file);
            return false;
        }
        logger.debug("Success");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean ensureDirectoryExists(File file) {
        if (file.exists()) {
            logger.debug("File esists");
            if (file.isDirectory()) {
                logger.debug("File is a directory");
                return true;
            }
            logger.warn("Not a directory: {}", (Object)file);
            return false;
        }
        logger.debug("File does not exist");
        if (ElementsFileUtils.safeMkdirs(file)) {
            logger.info("Directory created successfully: {}", (Object)file);
            return true;
        }
        logger.warn("Cannot create directory: {}", (Object)file);
        return false;
    }

    public static boolean ensureDirectoryExistsAndWarnIfNotWritable(File file) {
        logger.debug("Ensure directory exists and writable: {}", (Object)file);
        if (!ElementsFileUtils.ensureDirectoryExists(file)) {
            return false;
        }
        try {
            if (!file.canWrite()) {
                logger.warn("Directory not writable: {}", (Object)file);
            } else {
                logger.debug("Success");
            }
        }
        catch (Exception e) {
            logger.warn("Directory not writable: " + file, (Throwable)e);
        }
        return true;
    }

    public static boolean setReadable(File file, boolean readable) {
        String perms = readable ? "u+rx" : "a-rx";
        return ElementsFileUtils.chmod(file, perms);
    }

    public static boolean setWritable(File file, boolean writable) {
        String perms = writable ? "u+w" : "a-w";
        return ElementsFileUtils.chmod(file, perms);
    }

    public static boolean chmod(File file, String perms) {
        logger.debug("chmod {} {}", (Object)perms, (Object)file.getAbsolutePath());
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(new String[]{"chmod", perms, file.getAbsolutePath()});
            int result = process.waitFor();
            return result == 0;
        }
        catch (Exception e) {
            logger.warn("Couldn't chmod " + file.getAbsolutePath() + " " + e.getMessage());
            return false;
        }
    }

    public static boolean safeMkdir(File detailDirectory) {
        try {
            return detailDirectory.mkdir();
        }
        catch (SecurityException e) {
            logger.error("mkdir failed, security exception", (Throwable)e);
            return false;
        }
    }

    public static boolean safeMkdirs(File detailDirectory) {
        try {
            return detailDirectory.mkdirs();
        }
        catch (SecurityException e) {
            logger.error("mkdir failed, security exception", (Throwable)e);
            return false;
        }
    }

    public static void moveFileSafely(File tempFile, String fileName) throws IOException {
        File destination = new File(fileName);
        if (!destination.exists()) {
            FileUtils.moveFile((File)tempFile, (File)destination);
        } else {
            File backup = File.createTempFile(destination.getName(), ".backup", destination.getParentFile());
            if (!backup.delete()) {
                logger.warn("Cannot delete: {}", (Object)backup);
            }
            FileUtils.moveFile((File)destination, (File)backup);
            FileUtils.moveFile((File)tempFile, (File)destination);
            if (!backup.delete()) {
                logger.warn("Cannot delete: {}", (Object)backup);
            }
        }
    }
}

