/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.Select;
import com.manydesigns.elements.fields.AbstractField;
import com.manydesigns.elements.json.JsonBuffer;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.options.DefaultSelectionProvider;
import com.manydesigns.elements.options.DisplayMode;
import com.manydesigns.elements.options.SelectionModel;
import com.manydesigns.elements.options.SelectionProvider;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class SelectField
extends AbstractField<Object> {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    public static final String AUTOCOMPLETE_SUFFIX = "_autocomplete";
    protected SelectionModel selectionModel;
    protected int selectionModelIndex;
    protected SelectField previousSelectField;
    protected SelectField nextSelectField;
    protected String comboLabel;
    protected DisplayMode displayMode;
    protected String autocompleteId;
    protected String autocompleteInputName;
    protected String autocompleteInputValue;
    protected String createNewValueHref;
    protected String createNewValueText;

    public SelectField(PropertyAccessor accessor, Mode mode, String prefix) {
        this(accessor, null, mode, prefix);
    }

    public SelectField(PropertyAccessor accessor, SelectionProvider selectionProvider, Mode mode, String prefix) {
        super(accessor, mode, prefix);
        boolean nullOption;
        Select annotation = accessor.getAnnotation(Select.class);
        boolean bl = nullOption = annotation == null || annotation.nullOption();
        if (selectionProvider == null) {
            String[] labels;
            Object[] values;
            if (annotation == null) {
                values = new Object[]{};
                labels = new String[]{};
            } else {
                values = annotation.values();
                labels = annotation.labels();
                this.displayMode = annotation.displayMode();
            }
            assert (values.length == labels.length);
            if (values.length > 0) {
                selectionProvider = this.createValuesSelectionProvider(accessor, values, labels);
            } else if (accessor.getType().isEnum()) {
                selectionProvider = this.createEnumSelectionProvider(accessor);
            }
        } else {
            this.displayMode = selectionProvider.getDisplayMode();
            if (this.displayMode == null && annotation != null) {
                this.displayMode = annotation.displayMode();
            }
        }
        if (this.displayMode == null) {
            this.displayMode = DisplayMode.DROPDOWN;
        }
        if (selectionProvider != null) {
            this.selectionModel = selectionProvider.createSelectionModel();
            this.selectionModelIndex = 0;
            this.createNewValueHref = selectionProvider.getCreateNewValueHref();
            this.createNewValueText = selectionProvider.getCreateNewValueText();
        }
        if (nullOption) {
            this.comboLabel = this.getText("elements.field.select.select", this.label);
        }
        this.autocompleteId = this.id + AUTOCOMPLETE_SUFFIX;
        this.autocompleteInputName = this.inputName + AUTOCOMPLETE_SUFFIX;
    }

    public SelectionProvider createEnumSelectionProvider(PropertyAccessor accessor) {
        try {
            Method valuesMethod = accessor.getType().getMethod("values", new Class[0]);
            Object[] values = (Enum[])valuesMethod.invoke(null, new Object[0]);
            String[] labels = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                labels[i] = values[i].name();
            }
            return this.createValuesSelectionProvider(accessor, values, labels);
        }
        catch (Exception e) {
            logger.error("Cannot create Selection provider from enumeration", (Throwable)e);
            throw new Error(e);
        }
    }

    public SelectionProvider createValuesSelectionProvider(PropertyAccessor accessor, Object[] values, String[] labels) {
        DefaultSelectionProvider selectionProvider = new DefaultSelectionProvider(accessor.getName(), 1);
        for (int i = 0; i < values.length; ++i) {
            Object convertedValue = OgnlUtils.convertValue(values[i], accessor.getType());
            selectionProvider.appendRow(convertedValue, this.getText(labels[i], new Object[0]), true);
        }
        return selectionProvider;
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        Object value;
        super.readFromRequest(req);
        if (this.mode.isView(this.insertable, this.updatable)) {
            return;
        }
        String stringValue = req.getParameter(this.inputName);
        if (DisplayMode.AUTOCOMPLETE == this.displayMode) {
            if (StringUtils.isEmpty((String)stringValue)) {
                value = null;
                this.autocompleteInputValue = req.getParameter(this.autocompleteInputName);
                Map<Object, SelectionModel.Option> options = this.selectionModel.getOptions(this.selectionModelIndex);
                boolean found = false;
                for (SelectionModel.Option option : options.values()) {
                    if (!ObjectUtils.equals((Object)this.autocompleteInputValue, (Object)option.label) || !option.active) continue;
                    found = true;
                    value = option.value;
                }
                if (!found) {
                    return;
                }
            } else {
                value = OgnlUtils.convertValue(stringValue, this.accessor.getType());
            }
        } else {
            if (stringValue == null) {
                return;
            }
            value = stringValue.length() == 0 ? null : (Object)OgnlUtils.convertValue(stringValue, this.accessor.getType());
        }
        this.selectionModel.setValue(this.selectionModelIndex, value);
    }

    @Override
    public boolean validate() {
        if (this.mode.isView(this.insertable, this.updatable) || this.mode.isBulk() && !this.bulkChecked) {
            return true;
        }
        Object value = this.selectionModel.getValue(this.selectionModelIndex);
        if (this.required && value == null) {
            this.errors.add(this.getText("elements.error.field.required", new Object[0]));
            return false;
        }
        if (value == null && !StringUtils.isBlank((String)this.autocompleteInputValue)) {
            this.errors.add(this.getText("elements.error.field.invalid", this.autocompleteInputValue));
            return false;
        }
        return true;
    }

    @Override
    public void readFromObject(Object obj) {
        super.readFromObject(obj);
        if (obj == null) {
            this.setValue((Object)null);
        } else {
            this.setValue(this.accessor.get(obj));
        }
    }

    @Override
    public void writeToObject(Object obj) {
        Object value = this.selectionModel.getValue(this.selectionModelIndex);
        this.writeToObject(obj, value);
    }

    @Override
    public void valueToXhtml(XhtmlBuffer xb) {
        if (this.mode.isView(this.insertable, this.updatable)) {
            this.valueToXhtmlView(xb);
        } else if (this.mode.isEdit()) {
            this.valueToXhtmlEdit(xb);
        } else if (this.mode.isPreview()) {
            this.valueToXhtmlPreview(xb);
        } else if (this.mode.isHidden()) {
            this.valueToXhtmlHidden(xb);
        } else {
            throw new IllegalStateException("Unknown mode: " + this.mode.name());
        }
    }

    public void valueToXhtmlEdit(XhtmlBuffer xb) {
        switch (this.displayMode) {
            case DROPDOWN: {
                this.valueToXhtmlEditDropDown(xb);
                this.addCreateNewLink(xb);
                if (!this.mode.isBulk()) break;
                xb.writeJavaScript("$(function() { configureBulkEditField('" + this.id + "', '" + this.bulkCheckboxName + "'); });");
                break;
            }
            case RADIO: {
                this.valueToXhtmlEditRadio(xb);
                break;
            }
            case AUTOCOMPLETE: {
                this.valueToXhtmlEditAutocomplete(xb);
                this.addCreateNewLink(xb);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown display mode: " + this.displayMode.name());
            }
        }
    }

    protected void addCreateNewLink(XhtmlBuffer xb) {
        if (this.createNewValueHref != null) {
            String href = this.createNewValueHref;
            href = href.contains("?") ? href + "&" : href + "?";
            href = href + "popupCloseCallback=popupCloseCallback_" + this.id;
            xb.write(" ");
            xb.openElement("a");
            xb.addAttribute("href", href);
            xb.addAttribute("class", "mde-select-field-create-new-link");
            xb.write(this.createNewValueText);
            xb.closeElement("a");
            String js = this.composeCreateNewJs();
            xb.writeJavaScript(js);
        }
    }

    public String composeCreateNewJs() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("function popupCloseCallback_{0}(val) '{'if(val) updateSelectOptions(''{1}'', {2}, ''jsonSelectFieldOptions''", StringEscapeUtils.escapeJavaScript((String)this.id), StringEscapeUtils.escapeJavaScript((String)this.selectionModel.getName()), this.selectionModelIndex));
        this.appendIds(sb);
        sb.append(");}");
        return sb.toString();
    }

    public void valueToXhtmlEditDropDown(XhtmlBuffer xb) {
        boolean checked;
        Object value = this.selectionModel.getValue(this.selectionModelIndex);
        Map<Object, SelectionModel.Option> options = this.selectionModel.getOptions(this.selectionModelIndex);
        xb.openElement("select");
        xb.addAttribute("id", this.id);
        xb.addAttribute("name", this.inputName);
        xb.addAttribute("class", "form-control");
        boolean bl = checked = value == null;
        if (this.comboLabel != null && !options.isEmpty()) {
            SelectionModel.Option option = options.remove(null);
            if (options.isEmpty()) {
                options.put(null, option);
            } else {
                xb.writeOption("", checked, this.comboLabel);
            }
        }
        for (Map.Entry entry : options.entrySet()) {
            if (!((SelectionModel.Option)entry.getValue()).active) continue;
            Object optionValue = entry.getKey();
            String optionStringValue = OgnlUtils.convertValue(optionValue, String.class);
            optionStringValue = StringUtils.defaultString((String)optionStringValue);
            String optionLabel = ((SelectionModel.Option)entry.getValue()).label;
            checked = Objects.equals(optionValue, value);
            xb.writeOption(optionStringValue, checked, optionLabel);
        }
        xb.closeElement("select");
        if (this.nextSelectField != null) {
            String js = this.composeDropDownJs();
            xb.writeJavaScript(js);
        }
    }

    public String composeDropDownJs() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("$(''#{0}'').change(function() '{'updateSelectOptions(''{1}'', {2}, ''jsonSelectFieldOptions''", StringEscapeUtils.escapeJavaScript((String)this.id), StringEscapeUtils.escapeJavaScript((String)this.selectionModel.getName()), this.selectionModelIndex + 1));
        this.appendIds(sb);
        sb.append(");});");
        return sb.toString();
    }

    public String composeAutocompleteJs() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("setupAutocomplete(''#{0}'', ''{1}'', {2}, ''jsonAutocompleteOptions''", StringEscapeUtils.escapeJavaScript((String)this.autocompleteId), StringEscapeUtils.escapeJavaScript((String)this.selectionModel.getName()), this.selectionModelIndex));
        this.appendIds(sb);
        sb.append(");");
        return sb.toString();
    }

    public void appendIds(StringBuilder sb) {
        SelectField rootField = this;
        while (rootField.previousSelectField != null) {
            rootField = rootField.previousSelectField;
        }
        SelectField currentField = rootField;
        while (currentField != null) {
            sb.append(MessageFormat.format(", ''#{0}''", StringEscapeUtils.escapeJavaScript((String)currentField.getId())));
            currentField = currentField.nextSelectField;
        }
    }

    public void valueToXhtmlEditRadio(XhtmlBuffer xb) {
        Object value = this.selectionModel.getValue(this.selectionModelIndex);
        Map<Object, SelectionModel.Option> options = this.selectionModel.getOptions(this.selectionModelIndex);
        int counter = 0;
        if (!this.required) {
            String radioId = this.id + "_" + counter;
            boolean checked = value == null;
            this.writeRadioWithLabel(xb, radioId, this.getText("elements.field.select.none", new Object[0]), "", checked);
            ++counter;
        }
        for (Map.Entry<Object, SelectionModel.Option> option : options.entrySet()) {
            if (!option.getValue().active) continue;
            Object optionValue = option.getKey();
            String optionStringValue = OgnlUtils.convertValue(optionValue, String.class);
            String optionLabel = option.getValue().label;
            String radioId = this.id + "_" + counter;
            boolean checked = optionValue.equals(value);
            this.writeRadioWithLabel(xb, radioId, optionLabel, optionStringValue, checked);
            ++counter;
        }
    }

    protected void writeRadioWithLabel(XhtmlBuffer xb, String radioId, String label, String stringValue, boolean checked) {
        xb.openElement("div");
        xb.addAttribute("class", "radio");
        xb.writeInputRadio(radioId, this.inputName, stringValue, checked);
        xb.openElement("label");
        xb.addAttribute("for", radioId);
        xb.write(label);
        xb.closeElement("label");
        xb.closeElement("div");
    }

    public void valueToXhtmlEditAutocomplete(XhtmlBuffer xb) {
        Object value = this.selectionModel.getValue(this.selectionModelIndex);
        String stringValue = OgnlUtils.convertValueToString(value);
        xb.writeInputHidden(this.id, this.inputName, stringValue);
        xb.openElement("input");
        xb.addAttribute("id", this.autocompleteId);
        xb.addAttribute("type", "text");
        xb.addAttribute("name", this.autocompleteInputName);
        xb.addAttribute("autocomplete", "off");
        xb.addAttribute("value", this.getStringValue());
        xb.addAttribute("class", "form-control");
        xb.closeElement("input");
        String js = this.composeAutocompleteJs();
        xb.writeJavaScript(js);
    }

    public void valueToXhtmlPreview(XhtmlBuffer xb) {
        this.valueToXhtmlView(xb);
        this.valueToXhtmlHidden(xb);
    }

    public void valueToXhtmlHidden(XhtmlBuffer xb) {
        Object value = this.selectionModel.getValue(this.selectionModelIndex);
        String stringValue = OgnlUtils.convertValueToString(value);
        xb.writeInputHidden(this.inputName, stringValue);
    }

    public void valueToXhtmlView(XhtmlBuffer xb) {
        xb.openElement("p");
        xb.addAttribute("class", "form-control-static");
        xb.addAttribute("id", this.id);
        if (this.href != null) {
            xb.openElement("a");
            xb.addAttribute("href", this.href);
        }
        xb.write(this.getStringValue());
        if (this.href != null) {
            xb.closeElement("a");
        }
        xb.closeElement("p");
    }

    @Override
    public String getStringValue() {
        Object value = this.selectionModel.getValue(this.selectionModelIndex);
        String result = this.selectionModel.getOption(this.selectionModelIndex, value, true);
        logger.trace("getStringValue() - name: {} - value: {} - result: {}", new Object[]{this.getPropertyAccessor().getName(), value, result});
        return result;
    }

    @Override
    public void setStringValue(String stringValue) {
        Object value = OgnlUtils.convertValue(stringValue, this.accessor.getType());
        this.selectionModel.setValue(this.selectionModelIndex, value);
    }

    public String jsonSelectFieldOptions(boolean includeSelectPrompt) {
        Map<Object, SelectionModel.Option> options = this.selectionModel.getOptions(this.selectionModelIndex);
        JsonBuffer jb = new JsonBuffer();
        jb.openArray();
        if (includeSelectPrompt && !options.isEmpty()) {
            jb.openObject();
            jb.writeKeyValue("v", "");
            jb.writeKeyValue("l", this.comboLabel);
            jb.writeKeyValue("s", true);
            jb.closeObject();
        }
        for (Map.Entry<Object, SelectionModel.Option> option : options.entrySet()) {
            if (!option.getValue().active) continue;
            jb.openObject();
            Object optionValue = option.getKey();
            String optionStringValue = OgnlUtils.convertValueToString(optionValue);
            String optionLabel = option.getValue().label;
            jb.writeKeyValue("v", optionStringValue);
            jb.writeKeyValue("l", optionLabel);
            jb.writeKeyValue("s", false);
            jb.closeObject();
        }
        jb.closeArray();
        return jb.toString();
    }

    @Override
    public Object getValue() {
        return this.selectionModel.getValue(this.selectionModelIndex);
    }

    @Override
    public void setValue(Object value) {
        value = OgnlUtils.convertValue(value, this.accessor.getType());
        this.selectionModel.setValue(this.selectionModelIndex, value);
    }

    public Map<Object, SelectionModel.Option> getOptions() {
        return this.selectionModel.getOptions(this.selectionModelIndex);
    }

    public String getLabelSearch() {
        return this.selectionModel.getLabelSearch(this.selectionModelIndex);
    }

    public String getComboLabel() {
        return this.comboLabel;
    }

    public void setComboLabel(String comboLabel) {
        this.comboLabel = comboLabel;
    }

    public String getAutocompleteId() {
        return this.autocompleteId;
    }

    public SelectField getNextSelectField() {
        return this.nextSelectField;
    }

    public void setNextSelectField(SelectField nextSelectField) {
        this.nextSelectField = nextSelectField;
    }

    public SelectField getPreviousSelectField() {
        return this.previousSelectField;
    }

    public void setPreviousSelectField(SelectField previousSelectField) {
        this.previousSelectField = previousSelectField;
    }

    public void setAutocompleteId(String autocompleteId) {
        this.autocompleteId = autocompleteId;
    }

    public String getAutocompleteInputName() {
        return this.autocompleteInputName;
    }

    public void setAutocompleteInputName(String autocompleteInputName) {
        this.autocompleteInputName = autocompleteInputName;
    }

    public void setLabelSearch(String labelSearch) {
        this.selectionModel.setLabelSearch(this.selectionModelIndex, labelSearch);
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public int getSelectionModelIndex() {
        return this.selectionModelIndex;
    }

    public void setSelectionModelIndex(int selectionModelIndex) {
        this.selectionModelIndex = selectionModelIndex;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public String getCreateNewValueHref() {
        return this.createNewValueHref;
    }

    public void setCreateNewValueHref(String createNewValueHref) {
        this.createNewValueHref = createNewValueHref;
    }

    public String getCreateNewValueText() {
        return this.createNewValueText;
    }

    public void setCreateNewValueText(String createNewValueText) {
        this.createNewValueText = createNewValueText;
    }
}

