/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.search;

import com.manydesigns.elements.fields.BooleanSearchValue;
import com.manydesigns.elements.fields.search.AbstractSearchField;
import com.manydesigns.elements.fields.search.Criteria;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BooleanSearchField
extends AbstractSearchField {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected BooleanSearchValue value = BooleanSearchValue.ANY;

    public BooleanSearchField(PropertyAccessor accessor) {
        this(accessor, null);
    }

    public BooleanSearchField(PropertyAccessor accessor, String prefix) {
        super(accessor, prefix);
    }

    @Override
    public void toSearchString(StringBuilder sb) {
        if (this.value != null && this.value != BooleanSearchValue.ANY) {
            this.appendToSearchString(sb, this.inputName, this.value.getStringValue());
        }
    }

    @Override
    public void configureCriteria(Criteria criteria) {
        if (this.value == null) {
            return;
        }
        switch (this.value) {
            case ANY: {
                break;
            }
            case NULL: {
                criteria.isNull(this.accessor);
                break;
            }
            case FALSE: {
                criteria.eq(this.accessor, Boolean.FALSE);
                break;
            }
            case TRUE: {
                criteria.eq(this.accessor, Boolean.TRUE);
                break;
            }
            default: {
                logger.error("Unknown BooleanSearchValue: {}", (Object)this.value.name());
            }
        }
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        String stringValue = req.getParameter(this.inputName);
        this.value = BooleanSearchValue.ANY;
        for (BooleanSearchValue current : BooleanSearchValue.values()) {
            if (!current.getStringValue().equals(stringValue)) continue;
            this.value = current;
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        xb.openElement("div");
        xb.addAttribute("class", "control-group ");
        xb.openElement("label");
        xb.addAttribute("class", "control-label");
        xb.write(StringUtils.capitalize((String)this.label));
        xb.closeElement("label");
        xb.openElement("div");
        xb.addAttribute("class", "controls");
        for (BooleanSearchValue current : BooleanSearchValue.values()) {
            if (this.required && current == BooleanSearchValue.NULL) continue;
            String idStr = this.id + "_" + current.name();
            String stringValue = current.getStringValue();
            boolean checked = this.value == current;
            xb.openElement("label");
            xb.addAttribute("class", "checkbox");
            xb.addAttribute("for", idStr);
            String label = this.getText(current.getLabelI18N(), new Object[0]);
            xb.write(label);
            xb.writeInputRadio(idStr, this.inputName, stringValue, checked);
            xb.closeElement("label");
        }
        xb.closeElement("div");
        xb.closeElement("div");
    }

    public BooleanSearchValue getValue() {
        return this.value;
    }

    public void setValue(BooleanSearchValue value) {
        this.value = value;
    }
}

