/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements;

import org.apache.commons.lang.builder.ToStringBuilder;

public enum Mode {
    CREATE(8, "CREATE"),
    EDIT(0, "EDIT"),
    BULK_EDIT(16, "BULK_EDIT"),
    CREATE_PREVIEW(9, "CREATE_PREVIEW"),
    PREVIEW(1, "PREVIEW"),
    VIEW(2, "VIEW"),
    CREATE_HIDDEN(11, "CREATE_HIDDEN"),
    HIDDEN(3, "HIDDEN");

    private static final int BASE_MODE_MASK = 3;
    private static final int CREATE_MASK = 8;
    private static final int BULK_MASK = 16;
    private final boolean create;
    private final boolean bulk;
    private final boolean edit;
    private final boolean preview;
    private final boolean view;
    private final boolean hidden;
    private final String name;

    private Mode(int value, String name) {
        int baseMode = value & 3;
        switch (baseMode) {
            case 0: {
                this.edit = true;
                this.preview = false;
                this.view = false;
                this.hidden = false;
                break;
            }
            case 1: {
                this.edit = false;
                this.preview = true;
                this.view = false;
                this.hidden = false;
                break;
            }
            case 2: {
                this.edit = false;
                this.preview = false;
                this.view = true;
                this.hidden = false;
                break;
            }
            case 3: {
                this.edit = false;
                this.preview = false;
                this.view = false;
                this.hidden = true;
                break;
            }
            default: {
                throw new InternalError("Unrecognized mode: " + value);
            }
        }
        this.create = (value & 8) != 0;
        this.bulk = (value & 0x10) != 0;
        this.name = name;
    }

    public boolean isCreate() {
        return this.create;
    }

    public boolean isBulk() {
        return this.bulk;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public boolean isView() {
        return this.view;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isView(boolean insertable, boolean updatable) {
        return this.view || !this.hidden && !this.create && !updatable || !this.hidden && this.create && !insertable;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("create", this.create).append("edit", this.edit).append("preview", this.preview).append("view", this.view).append("hidden", this.hidden).toString();
    }
}

