/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.forms;

import com.manydesigns.elements.FormElement;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.composites.AbstractCompositeElement;
import com.manydesigns.elements.fields.MultipartRequestField;
import com.manydesigns.elements.xml.XhtmlBuffer;
import org.jetbrains.annotations.NotNull;

public class FieldSet
extends AbstractCompositeElement<FormElement> {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected final int nColumns;
    protected final Mode mode;
    protected String name;
    protected int currentColumn;
    protected boolean rowOpened;

    public FieldSet(String name, int nColumns, Mode mode) {
        this.name = name;
        this.nColumns = nColumns;
        this.mode = mode;
        if (nColumns > 4 && nColumns != 6) {
            throw new IllegalArgumentException("nColumns = " + nColumns + " but only 1, 2, 3, 4, 6 columns are supported");
        }
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        if (this.mode.isHidden()) {
            for (FormElement current : this) {
                current.toXhtml(xb);
            }
        } else {
            xb.openElement("fieldset");
            if (this.name != null) {
                xb.writeLegend(this.name, null);
            }
            this.currentColumn = 0;
            this.rowOpened = false;
            for (FormElement current : this) {
                int colSpan = Math.min(current.getColSpan(), this.nColumns);
                if (current.isForceNewRow() || this.currentColumn + colSpan > this.nColumns) {
                    this.closeCurrentRow(xb);
                }
                if (this.currentColumn == 0) {
                    xb.openElement("div");
                    xb.addAttribute("class", "row-fluid");
                    this.rowOpened = true;
                }
                xb.openElement("div");
                xb.addAttribute("class", "span" + colSpan * (12 / this.nColumns));
                current.toXhtml(xb);
                xb.closeElement("div");
                this.currentColumn += colSpan;
                if (this.currentColumn < this.nColumns) continue;
                this.closeCurrentRow(xb);
            }
            this.closeCurrentRow(xb);
            xb.closeElement("fieldset");
        }
    }

    protected void closeCurrentRow(XhtmlBuffer xb) {
        if (!this.rowOpened) {
            return;
        }
        if (this.currentColumn < this.nColumns) {
            xb.openElement("div");
            xb.addAttribute("class", "span" + (this.nColumns - this.currentColumn) * (12 / this.nColumns));
            xb.closeElement("div");
        }
        xb.closeElement("div");
        this.currentColumn = 0;
        this.rowOpened = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isRequiredFieldsPresent() {
        for (FormElement current : this) {
            if (!current.hasRequiredFields()) continue;
            return true;
        }
        return false;
    }

    public boolean isMultipartRequest() {
        for (FormElement current : this) {
            MultipartRequestField field;
            if (!(current instanceof MultipartRequestField) || (field = (MultipartRequestField)current).getMode().isView(field.isInsertable(), field.isUpdatable())) continue;
            return true;
        }
        return false;
    }
}

