/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.util.RandomUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobManager {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(BlobManager.class);
    protected File blobsDir;
    protected String metaFileNamePattern;
    protected String dataFileNamePattern;

    public BlobManager() {
    }

    public BlobManager(File blobsDir, String metaFileNamePattern, String dataFileNamePattern) {
        this.blobsDir = blobsDir;
        this.metaFileNamePattern = metaFileNamePattern;
        this.dataFileNamePattern = dataFileNamePattern;
    }

    public static BlobManager createDefaultBlobManager() {
        Configuration elementsConfiguration = ElementsProperties.getConfiguration();
        String blobsDirPath = elementsConfiguration.getString("blobs.dir");
        File blobsDir = blobsDirPath == null ? null : new File(blobsDirPath);
        String metaFilenamePattern = elementsConfiguration.getString("blobs.meta.filename.pattern");
        String dataFilenamePattern = elementsConfiguration.getString("blobs.data.filename.pattern");
        return new BlobManager(blobsDir, metaFilenamePattern, dataFilenamePattern);
    }

    public Blob saveBlob(String code, File sourceFile, String fileName, String contentType, String characterEncoding) throws IOException {
        FileInputStream sourceStream = new FileInputStream(sourceFile);
        return this.saveBlob(code, sourceStream, fileName, contentType, characterEncoding);
    }

    public Blob saveBlob(String code, byte[] sourceBytes, String fileName, String contentType, String characterEncoding) throws IOException {
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(sourceBytes);
        return this.saveBlob(code, sourceStream, fileName, contentType, characterEncoding);
    }

    public Blob saveBlob(String code, InputStream sourceStream, String fileName, String contentType, @Nullable String characterEncoding) throws IOException {
        this.ensureValidCode(code);
        File metaFile = RandomUtil.getCodeFile(this.blobsDir, this.metaFileNamePattern, code);
        File dataFile = RandomUtil.getCodeFile(this.blobsDir, this.dataFileNamePattern, code);
        Blob blob = new Blob(metaFile, dataFile);
        long size = IOUtils.copyLarge((InputStream)sourceStream, (OutputStream)new FileOutputStream(dataFile));
        blob.setCode(code);
        blob.setFilename(fileName);
        blob.setContentType(contentType);
        blob.setSize(size);
        blob.saveMetaProperties();
        return blob;
    }

    public Blob updateBlob(String code, byte[] sourceBytes, String characterEncoding) throws IOException {
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(sourceBytes);
        return this.updateBlob(code, sourceStream, characterEncoding);
    }

    public Blob updateBlob(String code, InputStream sourceStream, String characterEncoding) throws IOException {
        this.ensureValidCode(code);
        Blob blob = this.loadBlob(code);
        File dataFile = blob.getDataFile();
        long size = IOUtils.copyLarge((InputStream)sourceStream, (OutputStream)new FileOutputStream(dataFile));
        blob.setSize(size);
        blob.setCharacterEncoding(characterEncoding);
        blob.saveMetaProperties();
        return blob;
    }

    public void ensureValidCode(String code) {
        if (!StringUtils.isAlphanumeric((String)code)) {
            throw new IllegalArgumentException("Code is not alphanumeric: " + code);
        }
    }

    public Blob loadBlob(String code) throws IOException {
        this.ensureValidCode(code);
        File metaFile = RandomUtil.getCodeFile(this.blobsDir, this.metaFileNamePattern, code);
        File dataFile = RandomUtil.getCodeFile(this.blobsDir, this.dataFileNamePattern, code);
        Blob blob = new Blob(metaFile, dataFile);
        blob.loadMetaProperties();
        return blob;
    }

    public boolean deleteBlob(String code) {
        this.ensureValidCode(code);
        File metaFile = RandomUtil.getCodeFile(this.blobsDir, this.metaFileNamePattern, code);
        File dataFile = RandomUtil.getCodeFile(this.blobsDir, this.dataFileNamePattern, code);
        boolean success = true;
        try {
            success = metaFile.delete() && success;
        }
        catch (Exception e) {
            logger.warn("Cound not delete meta file", (Throwable)e);
            success = false;
        }
        try {
            success = dataFile.delete() && success;
        }
        catch (Exception e) {
            logger.warn("Cound not delete data file", (Throwable)e);
            success = false;
        }
        return success;
    }

    public File getBlobsDir() {
        return this.blobsDir;
    }

    public void setBlobsDir(File blobsDir) {
        this.blobsDir = blobsDir;
    }

    public String getMetaFileNamePattern() {
        return this.metaFileNamePattern;
    }

    public void setMetaFileNamePattern(String metaFileNamePattern) {
        this.metaFileNamePattern = metaFileNamePattern;
    }

    public String getDataFileNamePattern() {
        return this.dataFileNamePattern;
    }

    public void setDataFileNamePattern(String dataFileNamePattern) {
        this.dataFileNamePattern = dataFileNamePattern;
    }
}

