/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.annotations.Label;
import com.manydesigns.elements.annotations.LabelI18N;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.Util;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldUtils {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(FieldUtils.class);

    public static String getLabel(PropertyAccessor accessor) {
        String label;
        if (accessor.isAnnotationPresent(LabelI18N.class)) {
            String i18NText;
            String text = accessor.getAnnotation(LabelI18N.class).value();
            logger.debug("LabelI18N annotation present with value: {}", (Object)text);
            Object args = null;
            String textCompare = MessageFormat.format(text, args);
            label = i18NText = ElementsThreadLocals.getTextProvider().getText(text, new Object[0]);
            if (textCompare.equals(i18NText) && accessor.isAnnotationPresent(Label.class)) {
                label = accessor.getAnnotation(Label.class).value();
            }
        } else if (accessor.isAnnotationPresent(Label.class)) {
            label = accessor.getAnnotation(Label.class).value();
            logger.debug("Label annotation present with value: {}", (Object)label);
        } else {
            label = Util.guessToWords(accessor.getName());
            logger.debug("Setting label from property name: {}", (Object)label);
        }
        return label;
    }
}

