/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.servlet;

import com.manydesigns.elements.messages.SessionMessages;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.io.Writer;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class SessionMessagesTag
extends TagSupport {
    public int doStartTag() {
        JspWriter out = this.pageContext.getOut();
        XhtmlBuffer xb = new XhtmlBuffer((Writer)out);
        List<String> errorMessages = SessionMessages.consumeErrorMessages();
        List<String> warningMessages = SessionMessages.consumeWarningMessages();
        List<String> infoMessages = SessionMessages.consumeInfoMessages();
        if (!errorMessages.isEmpty()) {
            xb.openElement("div");
            xb.addAttribute("class", "alert alert-danger alert-dismissable fade in");
            this.writeCloseButton(xb);
            this.writeList(xb, errorMessages, "errorMessages");
            xb.closeElement("div");
        }
        if (!warningMessages.isEmpty()) {
            xb.openElement("div");
            xb.addAttribute("class", "alert alert-warning alert-dismissable fade in");
            this.writeCloseButton(xb);
            this.writeList(xb, warningMessages, "warningMessages");
            xb.closeElement("div");
        }
        if (!infoMessages.isEmpty()) {
            xb.openElement("div");
            xb.addAttribute("class", "alert alert-success alert-dismissable fade in");
            this.writeCloseButton(xb);
            this.writeList(xb, infoMessages, "infoMessages");
            xb.closeElement("div");
        }
        return 0;
    }

    private void writeCloseButton(XhtmlBuffer xb) {
        xb.writeNoHtmlEscape("<button data-dismiss=\"alert\" class=\"close\" type=\"button\">&times;</button>");
    }

    private void writeList(XhtmlBuffer xb, List<String> errorMessages, String htmlClass) {
        if (errorMessages.size() == 0) {
            return;
        }
        xb.openElement("ul");
        xb.addAttribute("class", htmlClass);
        for (String current : errorMessages) {
            xb.openElement("li");
            xb.writeNoHtmlEscape(current);
            xb.closeElement("li");
        }
        xb.closeElement("ul");
    }
}

