/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.search;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.annotations.DateFormat;
import com.manydesigns.elements.fields.search.RangeSearchField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.Util;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateSearchField
extends RangeSearchField {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected String datePattern;
    protected DateTimeFormatter dateTimeFormatter;
    protected boolean containsTime;
    protected String jsDatePattern;

    public DateSearchField(PropertyAccessor accessor) {
        this(accessor, null);
    }

    public DateSearchField(PropertyAccessor accessor, String prefix) {
        super(accessor, prefix);
        DateFormat dateFormatAnnotation = accessor.getAnnotation(DateFormat.class);
        if (dateFormatAnnotation != null) {
            this.datePattern = dateFormatAnnotation.value();
        } else {
            Configuration elementsConfiguration = ElementsProperties.getConfiguration();
            this.datePattern = elementsConfiguration.getString("fields.date.format");
        }
        this.dateTimeFormatter = DateTimeFormat.forPattern((String)this.datePattern);
        this.setSize(this.dateTimeFormatter.getParser().estimateParsedLength());
        this.containsTime = this.datePattern.contains("HH") || this.datePattern.contains("mm") || this.datePattern.contains("ss");
        String tmpPattern = this.datePattern;
        if (tmpPattern.contains("MM")) {
            tmpPattern = tmpPattern.replaceAll("MM", "mm");
        }
        this.jsDatePattern = tmpPattern;
    }

    @Override
    public void rangeEndToXhtml(XhtmlBuffer xb, String id, String inputName, String stringValue, String label) {
        if (!this.containsTime) {
            String js = MessageFormat.format("$(function() '{' setupDatePicker(''#{0}'', ''{1}''); '}');", StringEscapeUtils.escapeJavaScript((String)id), StringEscapeUtils.escapeJavaScript((String)this.jsDatePattern));
            xb.writeJavaScript(js);
        }
        super.rangeEndToXhtml(xb, id, inputName, stringValue, label);
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        this.minStringValue = StringUtils.trimToNull((String)req.getParameter(this.minInputName));
        try {
            this.minValue = Util.parseDateTime(this.dateTimeFormatter, this.minStringValue, this.containsTime);
        }
        catch (Throwable e) {
            this.minValue = null;
        }
        this.maxStringValue = StringUtils.trimToNull((String)req.getParameter(this.maxInputName));
        try {
            this.maxValue = Util.parseDateTime(this.dateTimeFormatter, this.maxStringValue, this.containsTime);
        }
        catch (Throwable e) {
            this.maxValue = null;
        }
        this.searchNullValue = "-".equals(this.minStringValue) || "-".equals(this.maxStringValue);
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public boolean isContainsTime() {
        return this.containsTime;
    }

    public void setContainsTime(boolean containsTime) {
        this.containsTime = containsTime;
    }

    public String getJsDatePattern() {
        return this.jsDatePattern;
    }

    public void setJsDatePattern(String jsDatePattern) {
        this.jsDatePattern = jsDatePattern;
    }
}

