/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.FieldSize;
import com.manydesigns.elements.annotations.MaxLength;
import com.manydesigns.elements.fields.AbstractField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractTextField
extends AbstractField {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected String stringValue;
    protected boolean autoCapitalize = false;
    protected boolean replaceBadUnicodeCharacters = true;
    protected Integer maxLength = null;
    protected boolean labelPlaceholder;
    protected Integer size;

    public AbstractTextField(PropertyAccessor accessor, Mode mode) {
        this(accessor, mode, null);
    }

    public AbstractTextField(PropertyAccessor accessor, Mode mode, String prefix) {
        super(accessor, mode, prefix);
        if (accessor.isAnnotationPresent(MaxLength.class)) {
            this.maxLength = accessor.getAnnotation(MaxLength.class).value();
        }
        if (accessor.isAnnotationPresent(FieldSize.class)) {
            this.size = accessor.getAnnotation(FieldSize.class).value();
        }
    }

    @Override
    public boolean validate() {
        if (this.mode.isView(this.insertable, this.updatable) || this.mode.isBulk() && !this.bulkChecked) {
            return true;
        }
        boolean result = true;
        if (this.required && StringUtils.isBlank((String)this.stringValue)) {
            this.errors.add(this.getText("elements.error.field.required", new Object[0]));
            result = false;
        }
        if (this.maxLength != null && StringUtils.length((String)this.stringValue) > this.maxLength) {
            this.errors.add(this.getText("elements.error.field.length.exceeded", this.maxLength));
            result = false;
        }
        return result;
    }

    @Override
    public void labelToXhtml(XhtmlBuffer xb) {
        if (this.mode.isBulk() || !this.labelPlaceholder) {
            super.labelToXhtml(xb);
        }
    }

    @Override
    public void valueToXhtml(XhtmlBuffer xb) {
        if (this.mode.isView(this.insertable, this.updatable)) {
            this.valueToXhtmlView(xb);
        } else if (this.mode.isEdit()) {
            this.valueToXhtmlEdit(xb);
        } else if (this.mode.isPreview()) {
            this.valueToXhtmlPreview(xb);
        } else if (this.mode.isHidden()) {
            xb.writeInputHidden(this.id, this.inputName, this.stringValue);
        } else {
            throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.mode));
        }
    }

    protected void valueToXhtmlEdit(XhtmlBuffer xb) {
        xb.writeInputText(this.id, this.inputName, this.stringValue, this.labelPlaceholder ? this.label : null, "form-control", this.size, this.maxLength);
        if (this.mode.isBulk()) {
            xb.writeJavaScript("$(function() { configureBulkEditTextField('" + this.id + "', '" + this.bulkCheckboxName + "'); " + "});");
        }
    }

    protected void valueToXhtmlPreview(XhtmlBuffer xb) {
        this.valueToXhtmlView(xb);
        xb.writeInputHidden(this.inputName, this.stringValue);
    }

    protected void valueToXhtmlView(XhtmlBuffer xb) {
        xb.openElement("p");
        xb.addAttribute("class", "form-control-static");
        xb.addAttribute("id", this.id);
        if (this.href == null) {
            xb.write(this.stringValue);
        } else {
            xb.writeAnchor(this.href, this.stringValue, null, this.title);
        }
        xb.closeElement("p");
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public boolean isAutoCapitalize() {
        return this.autoCapitalize;
    }

    public void setAutoCapitalize(boolean autoCapitalize) {
        this.autoCapitalize = autoCapitalize;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean isReplaceBadUnicodeCharacters() {
        return this.replaceBadUnicodeCharacters;
    }

    public void setReplaceBadUnicodeCharacters(boolean replaceBadUnicodeCharacters) {
        this.replaceBadUnicodeCharacters = replaceBadUnicodeCharacters;
    }

    public boolean isLabelPlaceholder() {
        return this.labelPlaceholder;
    }

    public void setLabelPlaceholder(boolean labelPlaceholder) {
        this.labelPlaceholder = labelPlaceholder;
    }
}

