/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core.APIs;

import com.mangopay.MangoPayApi;
import com.mangopay.core.APIs.ApiBase;
import com.mangopay.entities.PayIn;
import com.mangopay.entities.Refund;
import com.mangopay.entities.TemporaryImmediatePayIn;

public class ApiPayIns
extends ApiBase {
    public ApiPayIns(MangoPayApi root) {
        super(root);
    }

    public PayIn create(PayIn payIn) throws Exception {
        return this.create(null, payIn);
    }

    public PayIn create(String idempotencyKey, PayIn payIn) throws Exception {
        String paymentKey = this.getPaymentKey(payIn);
        String executionKey = this.getExecutionKey(payIn);
        return this.createObject(PayIn.class, idempotencyKey, String.format("payins_%s-%s_create", paymentKey, executionKey), payIn);
    }

    public PayIn get(String payInId) throws Exception {
        return this.getObject(PayIn.class, "payins_get", payInId);
    }

    public Refund createRefund(String payInId, Refund refund) throws Exception {
        return this.createRefund(null, payInId, refund);
    }

    public Refund createRefund(String idempotencyKey, String payInId, Refund refund) throws Exception {
        return this.createObject(Refund.class, idempotencyKey, "payins_createrefunds", refund, payInId);
    }

    public Refund getRefund(String payInId) throws Exception {
        return this.getObject(Refund.class, "payins_getrefunds", payInId);
    }

    public TemporaryImmediatePayIn createTemporaryImmediatePayIn(TemporaryImmediatePayIn immediatePayIn) throws Exception {
        return this.createTemporaryImmediatePayIn(null, immediatePayIn);
    }

    public TemporaryImmediatePayIn createTemporaryImmediatePayIn(String idempotencyKey, TemporaryImmediatePayIn immediatePayIn) throws Exception {
        return this.createObject(TemporaryImmediatePayIn.class, idempotencyKey, "temp_immediatepayins_create", immediatePayIn);
    }

    private String getPaymentKey(PayIn payIn) throws Exception {
        if (payIn.PaymentDetails == null) {
            throw new Exception("Payment is not defined or it is not object type");
        }
        String className = payIn.PaymentDetails.getClass().getSimpleName().replace("PayInPaymentDetails", "");
        return className.toLowerCase();
    }

    private String getExecutionKey(PayIn payIn) throws Exception {
        if (payIn.ExecutionDetails == null) {
            throw new Exception("Execution is not defined or it is not object type");
        }
        String className = payIn.ExecutionDetails.getClass().getSimpleName().replace("PayInExecutionDetails", "");
        return className.toLowerCase();
    }
}

