/*
 * Decompiled with CFR 0.152.
 */
package com.mallotec.reb.languageplugin.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.util.DisplayMetrics;
import android.util.Log;
import com.mallotec.reb.languageplugin.BaseApplication;
import com.mallotec.reb.languageplugin.DefaultSPHelper;
import com.mallotec.reb.languageplugin.R;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\u0006H\u0007J\b\u0010\u000f\u001a\u00020\u0006H\u0002J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0004J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0003J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/mallotec/reb/languageplugin/utils/LocaleManageUtil;", "", "()V", "TAG", "", "currentSystemLocale", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "cacheSystemLocale", "", "getSelectLanguageString", "context", "Landroid/content/Context;", "getSetLocale", "getSystemLocale", "getSystemLocaleLegacy", "onConfigurationChanged", "printContextLocale", "tag", "saveSelectLanguage", "select", "setAppLocale", "config", "Landroid/content/res/Configuration;", "locale", "setAppLocaleLegacy", "updateApplicationContext", "updateContext", "updateResources", "plugin-language_release"})
public final class LocaleManageUtil {
    private static final String TAG = "LocaleManageUtil";
    private static Locale currentSystemLocale;
    public static final LocaleManageUtil INSTANCE;

    @NotNull
    public final Locale getSetLocale() {
        Locale locale;
        switch (DefaultSPHelper.INSTANCE.getLanguage()) {
            case "0": {
                Locale locale2 = currentSystemLocale;
                locale = locale2;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"currentSystemLocale");
                break;
            }
            case "1": {
                Locale locale3 = Locale.SIMPLIFIED_CHINESE;
                locale = locale3;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.SIMPLIFIED_CHINESE");
                break;
            }
            case "2": {
                Locale locale4 = Locale.ENGLISH;
                locale = locale4;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.ENGLISH");
                break;
            }
            default: {
                Locale locale5 = Locale.SIMPLIFIED_CHINESE;
                locale = locale5;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale5, (String)"Locale.SIMPLIFIED_CHINESE");
            }
        }
        return locale;
    }

    public final void saveSelectLanguage(@NotNull String select) {
        Intrinsics.checkParameterIsNotNull((Object)select, (String)"select");
        DefaultSPHelper.INSTANCE.setLanguage(select);
        this.updateApplicationContext((Context)BaseApplication.Companion.getInstance());
    }

    @NotNull
    public final String getSelectLanguageString(@NotNull Context context) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        switch (DefaultSPHelper.INSTANCE.getLanguage()) {
            case "0": {
                String string3 = context.getString(R.string.text_language_auto);
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.getString(R.string.text_language_auto)");
                break;
            }
            case "1": {
                String string4 = context.getString(R.string.text_language_zh);
                string2 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"context.getString(R.string.text_language_zh)");
                break;
            }
            case "2": {
                String string5 = context.getString(R.string.text_language_en);
                string2 = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"context.getString(R.string.text_language_en)");
                break;
            }
            default: {
                String string6 = context.getString(R.string.text_language_zh);
                string2 = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"context.getString(R.string.text_language_zh)");
            }
        }
        return string2;
    }

    @NotNull
    public final Context updateContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.updateResources(context, this.getSetLocale());
    }

    private final Context updateResources(Context context, Locale locale) {
        Resources res;
        Locale.setDefault(locale);
        Context cont = context;
        Resources resources = res = cont.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"res");
        DisplayMetrics dm = resources.getDisplayMetrics();
        Configuration config = res.getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            Configuration configuration = config;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
            this.setAppLocale(configuration, locale);
            Context context2 = cont.createConfigurationContext(config);
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"cont.createConfigurationContext(config)");
            cont = context2;
        } else {
            Configuration configuration = config;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
            this.setAppLocaleLegacy(configuration, locale);
        }
        res.updateConfiguration(config, dm);
        return cont;
    }

    private final void setAppLocaleLegacy(Configuration config, Locale locale) {
        config.locale = locale;
    }

    @TargetApi(value=24)
    private final void setAppLocale(Configuration config, Locale locale) {
        config.setLocale(locale);
        LocaleList localeList = new LocaleList(new Locale[]{locale});
        LocaleList.setDefault((LocaleList)localeList);
        config.setLocales(localeList);
    }

    @NotNull
    public final Context updateApplicationContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        return this.updateContext(context2);
    }

    private final Locale getSystemLocaleLegacy() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        return locale;
    }

    @TargetApi(value=24)
    @NotNull
    public final Locale getSystemLocale() {
        Locale locale = LocaleList.getDefault().get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"LocaleList.getDefault().get(0)");
        return locale;
    }

    public final void cacheSystemLocale() {
        Locale locale;
        currentSystemLocale = locale = Build.VERSION.SDK_INT >= 24 ? this.getSystemLocale() : this.getSystemLocaleLegacy();
    }

    public final void onConfigurationChanged(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.cacheSystemLocale();
        this.updateContext(context);
        this.updateApplicationContext(context);
    }

    @TargetApi(value=24)
    public final void printContextLocale(@NotNull Context context, @NotNull String tag) {
        Resources resources;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Resources resources2 = resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
        Configuration config = resources2.getConfiguration();
        String string2 = "Locale-" + tag;
        Locale locale = config.locale;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"config.locale");
        Log.d((String)string2, (String)locale.getLanguage());
        String string3 = "Locale-" + tag;
        Configuration configuration = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
        Log.d((String)string3, (String)configuration.getLocales().toLanguageTags());
    }

    private LocaleManageUtil() {
    }

    static {
        LocaleManageUtil localeManageUtil;
        INSTANCE = localeManageUtil = new LocaleManageUtil();
        TAG = TAG;
        currentSystemLocale = Locale.SIMPLIFIED_CHINESE;
    }
}

