/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.mailosaur.MailosaurClient;
import com.mailosaur.MailosaurException;
import com.mailosaur.models.Server;
import com.mailosaur.models.ServerCreateOptions;
import com.mailosaur.models.ServerListResult;
import java.io.IOException;
import java.util.Random;

public class Servers {
    private MailosaurClient client;
    private Random random = new Random();

    public Servers(MailosaurClient client) {
        this.client = client;
    }

    public ServerListResult list() throws IOException, MailosaurException {
        return (ServerListResult)this.client.request("GET", "api/servers").parseAs(ServerListResult.class);
    }

    public Server create(ServerCreateOptions serverCreateOptions) throws IOException, MailosaurException {
        return (Server)this.client.request("POST", "api/servers", serverCreateOptions).parseAs(Server.class);
    }

    public Server get(String id) throws IOException, MailosaurException {
        return (Server)this.client.request("GET", "api/servers/" + id).parseAs(Server.class);
    }

    public Server update(String id, Server server) throws IOException, MailosaurException {
        return (Server)this.client.request("PUT", "api/servers/" + id, server).parseAs(Server.class);
    }

    public void delete(String id) throws MailosaurException {
        this.client.request("DELETE", "api/servers/" + id);
    }

    public String generateEmailAddress(String server) {
        String host = System.getenv("MAILOSAUR_SMTP_HOST");
        host = host != null ? host : "mailosaur.io";
        String randomString = String.valueOf(this.random.nextInt(10000000));
        return String.format("%s.%s@%s", randomString, server, host);
    }
}

