/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import com.mailosaur.exception.MailosaurException;
import com.mailosaur.model.DeleteResult;
import com.mailosaur.model.Email;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MailboxApi {
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    static final JsonFactory JSON_FACTORY = new GsonFactory();
    static final HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

        public void initialize(HttpRequest request) {
            request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
        }
    });
    final String BASE_URI = "https://api.mailosaur.com/v2";
    final String MAILBOX;
    final String API_KEY;

    public MailboxApi(String mailbox, String apiKey) {
        this.MAILBOX = mailbox;
        this.API_KEY = apiKey;
    }

    void writeByteArrayToFile(byte[] fileBytes, String filePath) throws MailosaurException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new MailosaurException("Unable to write to file: File not found " + filePath, e);
        }
        finally {
            try {
                stream.write(fileBytes);
                stream.close();
            }
            catch (IOException e) {
                throw new MailosaurException("Unable to write to file", e);
            }
        }
    }

    String buildQueryString(Map<String, String> map) throws UnsupportedEncodingException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("key", this.API_KEY);
        if (map != null) {
            queryParams.putAll(map);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : queryParams.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(URLEncoder.encode((String)entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
        }
        return sb.toString();
    }

    GenericUrl buildUrl(String path, Map<String, String> queryParams) throws UnsupportedEncodingException {
        return new GenericUrl("https://api.mailosaur.com/v2" + path + "?" + this.buildQueryString(queryParams));
    }

    HttpRequest buildRequest(String method, String path) throws MailosaurException {
        return this.buildRequest(method, path, null);
    }

    HttpRequest buildRequest(String method, String path, Map<String, String> queryParams) throws MailosaurException {
        try {
            GenericUrl url = this.buildUrl(path, queryParams);
            return method == "POST" ? requestFactory.buildPostRequest(url, null) : requestFactory.buildGetRequest(url);
        }
        catch (UnsupportedEncodingException e) {
            throw new MailosaurException("Unable to encode URL", e);
        }
        catch (IOException e) {
            throw new MailosaurException("Unable to build web request", e);
        }
    }

    ByteArrayOutputStream downloadFileAsStream(String method, String urlStr) throws MailosaurException {
        try {
            String decoded = URLDecoder.decode(urlStr, "UTF-8");
            HttpRequest request = this.buildRequest(method, decoded);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            request.execute().download((OutputStream)stream);
            return stream;
        }
        catch (IOException e) {
            throw new MailosaurException("Unable to download file", e);
        }
    }

    String buildUrlPath(String ... args) throws MailosaurException {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            try {
                sb.append("/" + URLEncoder.encode(arg, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new MailosaurException("Unable to encode URL", e);
            }
        }
        return sb.toString();
    }

    Email[] getEmails(Map<String, String> searchCriteria) throws MailosaurException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("mailbox", this.MAILBOX);
            queryParams.putAll(searchCriteria);
            HttpRequest request = this.buildRequest("GET", "/emails", queryParams);
            return (Email[])request.execute().parseAs(Email[].class);
        }
        catch (IOException e) {
            throw new MailosaurException("Unable to parse API response", e);
        }
    }

    OutputStream getAttachmentAsStream(String attachmentId) throws MailosaurException {
        return this.downloadFileAsStream("GET", this.buildUrlPath("attachment", attachmentId));
    }

    void saveAttachmentToFile(String attachmentId, String filePath) throws MailosaurException {
        byte[] fileBytes = this.getAttachment(attachmentId);
        this.writeByteArrayToFile(fileBytes, filePath);
    }

    OutputStream getRawEmailAsStream(String rawId) throws MailosaurException {
        return this.downloadFileAsStream("GET", this.buildUrlPath("raw", rawId));
    }

    void saveRawEmailToFile(String rawId, String filePath) throws MailosaurException, UnsupportedEncodingException {
        byte[] fileBytes = this.getRawEmail(rawId);
        this.writeByteArrayToFile(fileBytes, filePath);
    }

    public Email[] getEmails() throws MailosaurException {
        return this.getEmails(new HashMap<String, String>());
    }

    public Email[] getEmails(String searchPattern) throws MailosaurException {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("search", searchPattern);
        return this.getEmails(searchCriteria);
    }

    public Email[] getEmailsByRecipient(String recipientEmail) throws MailosaurException {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("recipient", recipientEmail);
        return this.getEmails(searchCriteria);
    }

    public Email getEmail(String emailId) throws MailosaurException {
        try {
            HttpRequest request = this.buildRequest("GET", this.buildUrlPath("email", emailId));
            return (Email)request.execute().parseAs(Email.class);
        }
        catch (IOException e) {
            throw new MailosaurException("Unable to parse API response", e);
        }
    }

    public Boolean deleteAllEmail() throws MailosaurException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("mailbox", this.MAILBOX);
            HttpRequest request = this.buildRequest("POST", "/emails/deleteall", queryParams);
            DeleteResult result = (DeleteResult)request.execute().parseAs(DeleteResult.class);
            return result.ok;
        }
        catch (IOException e) {
            throw new MailosaurException("Unable to parse API response", e);
        }
    }

    public Boolean deleteEmail(String emailId) throws MailosaurException {
        try {
            HttpRequest request = this.buildRequest("POST", this.buildUrlPath("email", emailId, "delete"));
            DeleteResult result = (DeleteResult)request.execute().parseAs(DeleteResult.class);
            return result.ok;
        }
        catch (IOException e) {
            throw new MailosaurException("Unable to parse API response", e);
        }
    }

    public byte[] getAttachment(String attachmentId) throws MailosaurException {
        return this.downloadFileAsStream("GET", this.buildUrlPath("attachment", attachmentId)).toByteArray();
    }

    public byte[] getRawEmail(String rawId) throws MailosaurException {
        return this.downloadFileAsStream("GET", this.buildUrlPath("raw", rawId)).toByteArray();
    }

    public String generateEmailAddress() {
        String uuid = UUID.randomUUID().toString();
        return String.format("%s.%s@mailosaur.in", uuid, this.MAILBOX);
    }
}

