/*
 * Decompiled with CFR 0.152.
 */
package com.m14n.android.ex.anim;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AroundAnimation
extends Animation {
    private float centerX;
    private float centerY;
    private boolean onBackWay;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Camera camera = new Camera();
    private boolean vertical;

    public AroundAnimation() {
        super.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                for (Animation.AnimationListener listener : AroundAnimation.this.listeners) {
                    listener.onAnimationStart(animation);
                }
            }

            public void onAnimationRepeat(Animation animation) {
                AroundAnimation.this.onBackWay = false;
                for (Animation.AnimationListener listener : AroundAnimation.this.listeners) {
                    listener.onAnimationRepeat(animation);
                }
            }

            public void onAnimationEnd(Animation animation) {
                for (Animation.AnimationListener listener : AroundAnimation.this.listeners) {
                    listener.onAnimationEnd(animation);
                }
            }
        });
    }

    public void setAnimationListener(Animation.AnimationListener listener) {
        throw new UnsupportedOperationException("This method is not supported. Use addListener(Listener) instead.");
    }

    public void setOrientation(boolean vertical) {
        this.vertical = vertical;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyHalf() {
        for (Listener listener : this.listeners) {
            listener.onAnimationHalf(this);
        }
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.onBackWay = false;
        this.centerX = (float)width / 2.0f;
        this.centerY = (float)height / 2.0f;
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        this.camera.save();
        float angle = (this.onBackWay ? interpolatedTime - 1.0f : interpolatedTime) * 180.0f;
        if (!this.onBackWay && angle >= 90.0f) {
            this.notifyHalf();
            this.onBackWay = true;
        }
        if (!this.vertical) {
            this.camera.rotateY(angle);
        } else {
            this.camera.rotateX(angle);
        }
        Matrix m = t.getMatrix();
        this.camera.getMatrix(m);
        this.camera.restore();
        m.preTranslate(-this.centerX, -this.centerY);
        m.postTranslate(this.centerX, this.centerY);
    }

    public static interface Listener
    extends Animation.AnimationListener {
        public void onAnimationHalf(Animation var1);
    }
}

