/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.kronos.internal.ntp;

import com.lyft.kronos.Clock;
import com.lyft.kronos.internal.ntp.DatagramFactory;
import com.lyft.kronos.internal.ntp.DnsResolver;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;

public class SntpClient {
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_PORT = 123;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_MODE_SERVER = 4;
    private static final int NTP_MODE_BROADCAST = 5;
    private static final int NTP_VERSION = 3;
    private static final int NTP_LEAP_NOSYNC = 3;
    private static final int NTP_STRATUM_DEATH = 0;
    private static final int NTP_STRATUM_MAX = 15;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    private static final long MAX_BOOT_MISMATCH_MS = 1000L;
    private final Clock deviceClock;
    private final DnsResolver dnsResolver;
    private final DatagramFactory datagramFactory;

    public SntpClient(Clock deviceClock, DnsResolver dnsResolver, DatagramFactory datagramFactory) {
        this.deviceClock = deviceClock;
        this.dnsResolver = dnsResolver;
        this.datagramFactory = datagramFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response requestTime(String host, Long timeout) throws IOException {
        try (DatagramSocket socket = null;){
            InetAddress address = this.dnsResolver.resolve(host);
            socket = this.datagramFactory.createSocket();
            socket.setSoTimeout(timeout.intValue());
            byte[] requestBuffer = new byte[48];
            DatagramPacket request = this.datagramFactory.createPacket(requestBuffer, address, 123);
            requestBuffer[0] = 27;
            long requestTime = this.deviceClock.getCurrentTimeMs();
            long requestTicks = this.deviceClock.getElapsedTimeMs();
            SntpClient.writeTimeStamp(requestBuffer, 40, requestTime);
            socket.send(request);
            byte[] responseBuffer = Arrays.copyOf(requestBuffer, requestBuffer.length);
            DatagramPacket response = this.datagramFactory.createPacket(responseBuffer);
            socket.receive(response);
            long responseTicks = this.deviceClock.getElapsedTimeMs();
            long responseTime = requestTime + (responseTicks - requestTicks);
            byte leap = (byte)(responseBuffer[0] >> 6 & 3);
            byte mode = (byte)(responseBuffer[0] & 7);
            int stratum = responseBuffer[1] & 0xFF;
            long originateTime = SntpClient.readTimeStamp(responseBuffer, 24);
            long receiveTime = SntpClient.readTimeStamp(responseBuffer, 32);
            long transmitTime = SntpClient.readTimeStamp(responseBuffer, 40);
            SntpClient.checkValidServerReply(leap, mode, stratum, transmitTime);
            long clockOffset = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
            Response response2 = new Response(responseTime, responseTicks, clockOffset, this.deviceClock);
            return response2;
        }
    }

    private static void checkValidServerReply(byte leap, byte mode, int stratum, long transmitTime) throws InvalidServerReplyException {
        if (leap == 3) {
            throw new InvalidServerReplyException("unsynchronized server");
        }
        if (mode != 4 && mode != 5) {
            throw new InvalidServerReplyException("untrusted mode: " + mode);
        }
        if (stratum == 0 || stratum > 15) {
            throw new InvalidServerReplyException("untrusted stratum: " + stratum);
        }
        if (transmitTime == 0L) {
            throw new InvalidServerReplyException("zero transmitTime");
        }
    }

    private static long read32(byte[] buffer, int offset) {
        int b0 = buffer[offset];
        int b1 = buffer[offset + 1];
        int b2 = buffer[offset + 2];
        int b3 = buffer[offset + 3];
        int i0 = (b0 & 0x80) == 128 ? (b0 & 0x7F) + 128 : b0;
        int i1 = (b1 & 0x80) == 128 ? (b1 & 0x7F) + 128 : b1;
        int i2 = (b2 & 0x80) == 128 ? (b2 & 0x7F) + 128 : b2;
        int i3 = (b3 & 0x80) == 128 ? (b3 & 0x7F) + 128 : b3;
        return ((long)i0 << 24) + ((long)i1 << 16) + ((long)i2 << 8) + (long)i3;
    }

    static long readTimeStamp(byte[] buffer, int offset) {
        long seconds = SntpClient.read32(buffer, offset);
        long fraction = SntpClient.read32(buffer, offset + 4);
        return (seconds - 2208988800L) * 1000L + fraction * 1000L / 0x100000000L;
    }

    private static void writeTimeStamp(byte[] buffer, int offset, long time) {
        long seconds = time / 1000L;
        long milliseconds = time - seconds * 1000L;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)(seconds >> 0);
        long fraction = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction >> 24);
        buffer[offset++] = (byte)(fraction >> 16);
        buffer[offset++] = (byte)(fraction >> 8);
        buffer[offset++] = (byte)(Math.random() * 255.0);
    }

    public static final class Response {
        private final long deviceCurrentTimestampMs;
        private final long deviceElapsedTimestampMs;
        private final long offsetMs;
        private final Clock deviceClock;

        Response(long deviceCurrentTimestampMs, long deviceElapsedTimestampMs, long offsetMs, Clock deviceClock) {
            this.deviceCurrentTimestampMs = deviceCurrentTimestampMs;
            this.deviceElapsedTimestampMs = deviceElapsedTimestampMs;
            this.offsetMs = offsetMs;
            this.deviceClock = deviceClock;
        }

        long getDeviceCurrentTimestampMs() {
            return this.deviceCurrentTimestampMs;
        }

        long getDeviceElapsedTimestampMs() {
            return this.deviceElapsedTimestampMs;
        }

        public long getCurrentTimeMs() {
            return this.deviceCurrentTimestampMs + this.offsetMs + this.getResponseAge();
        }

        public long getOffsetMs() {
            return this.offsetMs;
        }

        public long getResponseAge() {
            return this.deviceClock.getElapsedTimeMs() - this.deviceElapsedTimestampMs;
        }

        boolean isFromSameBoot() {
            long systemElapsedTimeMs;
            long bootTime = this.deviceCurrentTimestampMs - this.deviceElapsedTimestampMs;
            long systemCurrentTimeMs = this.deviceClock.getCurrentTimeMs();
            long systemBootTime = systemCurrentTimeMs - (systemElapsedTimeMs = this.deviceClock.getElapsedTimeMs());
            return Math.abs(bootTime - systemBootTime) < 1000L;
        }
    }

    private static class InvalidServerReplyException
    extends IOException {
        public InvalidServerReplyException(String message) {
            super(message);
        }
    }
}

