/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.kronos.internal;

import com.lyft.kronos.Clock;
import com.lyft.kronos.KronosClock;
import com.lyft.kronos.KronosTime;
import com.lyft.kronos.internal.ntp.SntpService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/lyft/kronos/internal/KronosClockImpl;", "Lcom/lyft/kronos/KronosClock;", "ntpService", "Lcom/lyft/kronos/internal/ntp/SntpService;", "fallbackClock", "Lcom/lyft/kronos/Clock;", "(Lcom/lyft/kronos/internal/ntp/SntpService;Lcom/lyft/kronos/Clock;)V", "getCurrentNtpTimeMs", "", "()Ljava/lang/Long;", "getCurrentTime", "Lcom/lyft/kronos/KronosTime;", "getElapsedTimeMs", "shutdown", "", "sync", "", "syncInBackground", "kronos-java"})
public final class KronosClockImpl
implements KronosClock {
    private final SntpService ntpService;
    private final Clock fallbackClock;

    @Override
    public boolean sync() {
        return this.ntpService.sync();
    }

    @Override
    public void syncInBackground() {
        this.ntpService.syncInBackground();
    }

    @Override
    public void shutdown() {
        this.ntpService.shutdown();
    }

    @Override
    public long getElapsedTimeMs() {
        return this.fallbackClock.getElapsedTimeMs();
    }

    @Override
    @NotNull
    public KronosTime getCurrentTime() {
        KronosTime currentTime = this.ntpService.currentTime();
        KronosTime kronosTime = currentTime;
        if (kronosTime == null) {
            kronosTime = new KronosTime(this.fallbackClock.getCurrentTimeMs(), null);
        }
        return kronosTime;
    }

    @Override
    @Nullable
    public Long getCurrentNtpTimeMs() {
        KronosTime kronosTime = this.ntpService.currentTime();
        return kronosTime != null ? Long.valueOf(kronosTime.getPosixTimeMs()) : null;
    }

    public KronosClockImpl(@NotNull SntpService ntpService, @NotNull Clock fallbackClock) {
        Intrinsics.checkNotNullParameter((Object)ntpService, (String)"ntpService");
        Intrinsics.checkNotNullParameter((Object)fallbackClock, (String)"fallbackClock");
        this.ntpService = ntpService;
        this.fallbackClock = fallbackClock;
    }

    @Override
    public long getCurrentTimeMs() {
        return KronosClock.DefaultImpls.getCurrentTimeMs(this);
    }
}

