/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.kronos;

import android.content.Context;
import android.content.SharedPreferences;
import com.lyft.kronos.Clock;
import com.lyft.kronos.ClockFactory;
import com.lyft.kronos.DefaultParam;
import com.lyft.kronos.KronosClock;
import com.lyft.kronos.SyncListener;
import com.lyft.kronos.SyncResponseCache;
import com.lyft.kronos.internal.AndroidSystemClock;
import com.lyft.kronos.internal.SharedPreferenceSyncResponseCache;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007JT\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u000fH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/lyft/kronos/AndroidClockFactory;", "", "()V", "createDeviceClock", "Lcom/lyft/kronos/Clock;", "createKronosClock", "Lcom/lyft/kronos/KronosClock;", "context", "Landroid/content/Context;", "syncListener", "Lcom/lyft/kronos/SyncListener;", "ntpHosts", "", "", "requestTimeoutMs", "", "minWaitTimeBetweenSyncMs", "cacheExpirationMs", "maxNtpResponseTimeMs", "kronos-android_release"})
public final class AndroidClockFactory {
    public static final AndroidClockFactory INSTANCE;

    @JvmStatic
    @NotNull
    public static final Clock createDeviceClock() {
        return new AndroidSystemClock();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Context context, @Nullable SyncListener syncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs, long minWaitTimeBetweenSyncMs, long cacheExpirationMs, long maxNtpResponseTimeMs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(ntpHosts, (String)"ntpHosts");
        Clock deviceClock = AndroidClockFactory.createDeviceClock();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.lyft.kronos.shared_preferences", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ME, Context.MODE_PRIVATE)");
        SharedPreferenceSyncResponseCache cache = new SharedPreferenceSyncResponseCache(sharedPreferences);
        return ClockFactory.createKronosClock((Clock)deviceClock, (SyncResponseCache)cache, (SyncListener)syncListener, ntpHosts, (long)requestTimeoutMs, (long)minWaitTimeBetweenSyncMs, (long)cacheExpirationMs, (long)maxNtpResponseTimeMs);
    }

    public static /* synthetic */ KronosClock createKronosClock$default(Context context, SyncListener syncListener, List list, long l, long l2, long l3, long l4, int n, Object object) {
        if ((n & 2) != 0) {
            syncListener = null;
        }
        if ((n & 4) != 0) {
            list = DefaultParam.INSTANCE.getNTP_HOSTS();
        }
        if ((n & 8) != 0) {
            l = DefaultParam.INSTANCE.getTIMEOUT_MS();
        }
        if ((n & 0x10) != 0) {
            l2 = DefaultParam.INSTANCE.getMIN_WAIT_TIME_BETWEEN_SYNC_MS();
        }
        if ((n & 0x20) != 0) {
            l3 = DefaultParam.INSTANCE.getCACHE_EXPIRATION_MS();
        }
        if ((n & 0x40) != 0) {
            l4 = DefaultParam.INSTANCE.getMAX_NTP_RESPONSE_TIME_MS();
        }
        return AndroidClockFactory.createKronosClock(context, syncListener, list, l, l2, l3, l4);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Context context, @Nullable SyncListener syncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs, long minWaitTimeBetweenSyncMs, long cacheExpirationMs) {
        return AndroidClockFactory.createKronosClock$default(context, syncListener, ntpHosts, requestTimeoutMs, minWaitTimeBetweenSyncMs, cacheExpirationMs, 0L, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Context context, @Nullable SyncListener syncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs, long minWaitTimeBetweenSyncMs) {
        return AndroidClockFactory.createKronosClock$default(context, syncListener, ntpHosts, requestTimeoutMs, minWaitTimeBetweenSyncMs, 0L, 0L, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Context context, @Nullable SyncListener syncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs) {
        return AndroidClockFactory.createKronosClock$default(context, syncListener, ntpHosts, requestTimeoutMs, 0L, 0L, 0L, 112, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Context context, @Nullable SyncListener syncListener, @NotNull List<String> ntpHosts) {
        return AndroidClockFactory.createKronosClock$default(context, syncListener, ntpHosts, 0L, 0L, 0L, 0L, 120, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Context context, @Nullable SyncListener syncListener) {
        return AndroidClockFactory.createKronosClock$default(context, syncListener, null, 0L, 0L, 0L, 0L, 124, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KronosClock createKronosClock(@NotNull Context context) {
        return AndroidClockFactory.createKronosClock$default(context, null, null, 0L, 0L, 0L, 0L, 126, null);
    }

    private AndroidClockFactory() {
    }

    static {
        AndroidClockFactory androidClockFactory;
        INSTANCE = androidClockFactory = new AndroidClockFactory();
    }
}

