/*
 * Decompiled with CFR 0.152.
 */
package com.luojilab.component.componentlib.service;

import android.util.Log;
import android.util.LruCache;
import com.luojilab.component.componentlib.router.ISyringe;
import com.luojilab.component.componentlib.service.AutowiredService;
import java.util.ArrayList;
import java.util.List;

public class AutowiredServiceImpl
implements AutowiredService {
    private LruCache<String, ISyringe> classCache = new LruCache(50);
    private List<String> blackList = new ArrayList<String>();
    private static final String SUFFIX_AUTOWIRED = "$$Router$$Autowired";

    @Override
    public void autowire(Object instance) {
        String className = instance.getClass().getName();
        try {
            if (!this.blackList.contains(className)) {
                ISyringe autowiredHelper = (ISyringe)this.classCache.get((Object)className);
                if (null == autowiredHelper) {
                    autowiredHelper = (ISyringe)Class.forName(instance.getClass().getName() + SUFFIX_AUTOWIRED).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                autowiredHelper.inject(instance);
                this.classCache.put((Object)className, (Object)autowiredHelper);
            } else {
                Log.d((String)"[DDComponent]", (String)("[autowire] " + className + "is in blacklist, ignore data inject"));
            }
        }
        catch (Exception ex) {
            if (ex instanceof NullPointerException) {
                throw new NullPointerException(ex.getMessage());
            }
            ex.printStackTrace();
            this.blackList.add(className);
        }
    }
}

