/*
 * Decompiled with CFR 0.152.
 */
package com.lukegb.mojo.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;

public class GitDescribeMojo
extends AbstractMojo {
    private MavenProject project;
    private File scmDirectory;
    @Deprecated
    private String outputPostfix;
    private String outputSuffix;
    private String outputPrefix;
    private String failOutput;
    private String descriptionProperty;
    private String commitCountProperty;
    private String[] extraArguments;
    private boolean setReactorProjectsProperties;
    private List reactorProjects;

    public void execute() throws MojoExecutionException {
        try {
            String previousDescribe = this.getDescribeProperty();
            if (previousDescribe == null) {
                String describe = this.getDescriber();
                this.getLog().info((CharSequence)("Setting Git Describe: " + describe));
                this.setDescribeProperty(describe);
                this.setCommitCountProperty(this.getCommitCount(describe));
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException("SCM Exception", (Exception)((Object)e));
        }
    }

    protected String getDescriber() throws ScmException, MojoExecutionException {
        String[] commandtwo;
        this.outputPrefix = GitDescribeMojo.firstNonNull(this.outputPrefix, "");
        this.outputSuffix = GitDescribeMojo.firstNonNull(this.outputSuffix, this.outputPostfix, "");
        String line = this.commandExecutor(this.buildDescribeCommand());
        if (line == null && (line = this.commandExecutor(commandtwo = new String[]{"git", "log", "--pretty=format:\"%h\""})) == null) {
            line = this.failOutput;
        }
        return this.outputPrefix + line + this.outputSuffix;
    }

    private String[] buildDescribeCommand() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("git");
        args.add("describe");
        args.addAll(Arrays.asList(this.extraArguments));
        this.getLog().info((CharSequence)((Object)args).toString());
        return args.toArray(new String[args.size()]);
    }

    private String commandExecutor(String[] command) {
        try {
            Process p = new ProcessBuilder(command).directory(this.scmDirectory).start();
            InputStream is = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            return line;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getCommitCount(String describer) {
        Pattern pattern = Pattern.compile("-(\\d+)-g[0-9a-f]{7}$");
        Matcher matcher = pattern.matcher(describer);
        if (!matcher.find()) {
            return this.failOutput;
        }
        String count = matcher.group(1);
        return count;
    }

    protected String getDescribeProperty() {
        return this.getProperty(this.descriptionProperty);
    }

    protected String getProperty(String property) {
        return this.project.getProperties().getProperty(property);
    }

    private void setDescribeProperty(String describer) {
        this.setProperty(this.descriptionProperty, describer);
    }

    private void setCommitCountProperty(String count) {
        this.setProperty(this.commitCountProperty, count);
    }

    private void setProperty(String property, String value) {
        if (value != null) {
            this.project.getProperties().put(property, value);
            if (this.setReactorProjectsProperties && this.reactorProjects != null) {
                for (Object reactorProject : this.reactorProjects) {
                    MavenProject nextProj = (MavenProject)reactorProject;
                    nextProj.getProperties().put(property, value);
                }
            }
        }
    }

    private static String firstNonNull(String ... strings) {
        for (String string : strings) {
            if (string == null) continue;
            return string;
        }
        return null;
    }
}

