/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.JsonStreamerEntity;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.SimpleMultipartEntity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class RequestParams {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    protected static final String LOG_TAG = "RequestParams";
    protected boolean isRepeatable;
    protected boolean useJsonStreamer;
    protected boolean autoCloseInputStreams;
    protected final ConcurrentHashMap<String, String> urlParams = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, StreamWrapper> streamParams = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, FileWrapper> fileParams = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Object> urlParamsWithObjects = new ConcurrentHashMap();
    protected String contentEncoding = "UTF-8";

    public void setContentEncoding(String encoding) {
        if (encoding != null) {
            this.contentEncoding = encoding;
        } else {
            Log.d((String)LOG_TAG, (String)"setContentEncoding called with null attribute");
        }
    }

    public RequestParams() {
        this(null);
    }

    public RequestParams(Map<String, String> source) {
        if (source != null) {
            for (Map.Entry<String, String> entry : source.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public RequestParams(final String key, final String value) {
        this((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(key, value);
            }
        });
    }

    public RequestParams(Object ... keysAndValues) {
        int len = keysAndValues.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Supplied arguments must be even");
        }
        for (int i = 0; i < len; i += 2) {
            String key = String.valueOf(keysAndValues[i]);
            String val = String.valueOf(keysAndValues[i + 1]);
            this.put(key, val);
        }
    }

    public void put(String key, String value) {
        if (key != null && value != null) {
            this.urlParams.put(key, value);
        }
    }

    public void put(String key, File file) throws FileNotFoundException {
        this.put(key, file, null);
    }

    public void put(String key, File file, String contentType) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        if (key != null) {
            this.fileParams.put(key, new FileWrapper(file, contentType));
        }
    }

    public void put(String key, InputStream stream) {
        this.put(key, stream, null);
    }

    public void put(String key, InputStream stream, String name) {
        this.put(key, stream, name, null);
    }

    public void put(String key, InputStream stream, String name, String contentType) {
        this.put(key, stream, name, contentType, this.autoCloseInputStreams);
    }

    public void put(String key, InputStream stream, String name, String contentType, boolean autoClose) {
        if (key != null && stream != null) {
            this.streamParams.put(key, StreamWrapper.newInstance(stream, name, contentType, autoClose));
        }
    }

    public void put(String key, Object value) {
        if (key != null && value != null) {
            this.urlParamsWithObjects.put(key, value);
        }
    }

    public void put(String key, int value) {
        if (key != null) {
            this.urlParams.put(key, String.valueOf(value));
        }
    }

    public void put(String key, long value) {
        if (key != null) {
            this.urlParams.put(key, String.valueOf(value));
        }
    }

    public void add(String key, String value) {
        if (key != null && value != null) {
            HashSet params = this.urlParamsWithObjects.get(key);
            if (params == null) {
                params = new HashSet();
                this.put(key, params);
            }
            if (params instanceof List) {
                ((List)((Object)params)).add(value);
            } else if (params instanceof Set) {
                ((Set)params).add(value);
            }
        }
    }

    public void remove(String key) {
        this.urlParams.remove(key);
        this.streamParams.remove(key);
        this.fileParams.remove(key);
        this.urlParamsWithObjects.remove(key);
    }

    public boolean has(String key) {
        return this.urlParams.get(key) != null || this.streamParams.get(key) != null || this.fileParams.get(key) != null || this.urlParamsWithObjects.get(key) != null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append("STREAM");
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append("FILE");
        }
        List<BasicNameValuePair> params = this.getParamsList(null, this.urlParamsWithObjects);
        for (BasicNameValuePair kv : params) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(kv.getName());
            result.append("=");
            result.append(kv.getValue());
        }
        return result.toString();
    }

    public void setHttpEntityIsRepeatable(boolean isRepeatable) {
        this.isRepeatable = isRepeatable;
    }

    public void setUseJsonStreamer(boolean useJsonStreamer) {
        this.useJsonStreamer = useJsonStreamer;
    }

    public void setAutoCloseInputStreams(boolean flag) {
        this.autoCloseInputStreams = flag;
    }

    public HttpEntity getEntity(ResponseHandlerInterface progressHandler) throws IOException {
        if (this.useJsonStreamer) {
            return this.createJsonStreamerEntity(progressHandler);
        }
        if (this.streamParams.isEmpty() && this.fileParams.isEmpty()) {
            return this.createFormEntity();
        }
        return this.createMultipartEntity(progressHandler);
    }

    private HttpEntity createJsonStreamerEntity(ResponseHandlerInterface progressHandler) throws IOException {
        JsonStreamerEntity entity = new JsonStreamerEntity(progressHandler, !this.fileParams.isEmpty() || !this.streamParams.isEmpty());
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            entity.addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.urlParamsWithObjects.entrySet()) {
            entity.addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            entity.addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            StreamWrapper stream = (StreamWrapper)entry.getValue();
            if (stream.inputStream == null) continue;
            entity.addPart(entry.getKey(), StreamWrapper.newInstance(stream.inputStream, stream.name, stream.contentType, stream.autoClose));
        }
        return entity;
    }

    private HttpEntity createFormEntity() {
        try {
            return new UrlEncodedFormEntity(this.getParamsList(), this.contentEncoding);
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)LOG_TAG, (String)"createFormEntity failed", (Throwable)e);
            return null;
        }
    }

    private HttpEntity createMultipartEntity(ResponseHandlerInterface progressHandler) throws IOException {
        SimpleMultipartEntity entity = new SimpleMultipartEntity(progressHandler);
        entity.setIsRepeatable(this.isRepeatable);
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            entity.addPartWithCharset(entry.getKey(), entry.getValue(), this.contentEncoding);
        }
        List<BasicNameValuePair> params = this.getParamsList(null, this.urlParamsWithObjects);
        for (BasicNameValuePair basicNameValuePair : params) {
            entity.addPartWithCharset(basicNameValuePair.getName(), basicNameValuePair.getValue(), this.contentEncoding);
        }
        for (Map.Entry entry : this.streamParams.entrySet()) {
            StreamWrapper stream = (StreamWrapper)entry.getValue();
            if (stream.inputStream == null) continue;
            entity.addPart((String)entry.getKey(), stream.name, stream.inputStream, stream.contentType);
        }
        for (Map.Entry entry : this.fileParams.entrySet()) {
            FileWrapper fileWrapper = (FileWrapper)entry.getValue();
            entity.addPart((String)entry.getKey(), fileWrapper.file, fileWrapper.contentType);
        }
        return entity;
    }

    protected List<BasicNameValuePair> getParamsList() {
        LinkedList<BasicNameValuePair> lparams = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            lparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        lparams.addAll(this.getParamsList(null, this.urlParamsWithObjects));
        return lparams;
    }

    private List<BasicNameValuePair> getParamsList(String key, Object value) {
        LinkedList<BasicNameValuePair> params = new LinkedList<BasicNameValuePair>();
        if (value instanceof Map) {
            Map map = (Map)value;
            ArrayList list = new ArrayList(map.keySet());
            if (list.size() > 0 && list.get(0) instanceof Comparable) {
                Collections.sort(list);
            }
            for (Object nestedKey : list) {
                Object nestedValue;
                if (!(nestedKey instanceof String) || (nestedValue = map.get(nestedKey)) == null) continue;
                params.addAll(this.getParamsList(key == null ? (String)nestedKey : String.format("%s[%s]", key, nestedKey), nestedValue));
            }
        } else if (value instanceof List) {
            List list = (List)value;
            int listSize = list.size();
            for (int nestedValueIndex = 0; nestedValueIndex < listSize; ++nestedValueIndex) {
                params.addAll(this.getParamsList(String.format("%s[%d]", key, nestedValueIndex), list.get(nestedValueIndex)));
            }
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int arrayLength = array.length;
            for (int nestedValueIndex = 0; nestedValueIndex < arrayLength; ++nestedValueIndex) {
                params.addAll(this.getParamsList(String.format("%s[%d]", key, nestedValueIndex), array[nestedValueIndex]));
            }
        } else if (value instanceof Set) {
            Set set = (Set)value;
            for (Object nestedValue : set) {
                params.addAll(this.getParamsList(key, nestedValue));
            }
        } else {
            params.add(new BasicNameValuePair(key, value.toString()));
        }
        return params;
    }

    protected String getParamString() {
        return URLEncodedUtils.format(this.getParamsList(), (String)this.contentEncoding);
    }

    public static class StreamWrapper {
        public final InputStream inputStream;
        public final String name;
        public final String contentType;
        public final boolean autoClose;

        public StreamWrapper(InputStream inputStream, String name, String contentType, boolean autoClose) {
            this.inputStream = inputStream;
            this.name = name;
            this.contentType = contentType;
            this.autoClose = autoClose;
        }

        static StreamWrapper newInstance(InputStream inputStream, String name, String contentType, boolean autoClose) {
            return new StreamWrapper(inputStream, name, contentType == null ? RequestParams.APPLICATION_OCTET_STREAM : contentType, autoClose);
        }
    }

    public static class FileWrapper {
        public final File file;
        public final String contentType;

        public FileWrapper(File file, String contentType) {
            this.file = file;
            this.contentType = contentType;
        }
    }
}

