/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.TextHttpResponseHandler;
import org.apache.http.Header;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonHttpResponseHandler
extends TextHttpResponseHandler {
    private static final String LOG_TAG = "JsonHttpResponseHandler";

    public JsonHttpResponseHandler() {
        super("UTF-8");
    }

    public JsonHttpResponseHandler(String encoding) {
        super(encoding);
    }

    public void onSuccess(JSONObject response) {
    }

    public void onSuccess(JSONArray response) {
    }

    public void onSuccess(int statusCode, Header[] headers, JSONObject response) {
        this.onSuccess(statusCode, response);
    }

    public void onSuccess(int statusCode, JSONObject response) {
        this.onSuccess(response);
    }

    public void onSuccess(int statusCode, Header[] headers, JSONArray response) {
        this.onSuccess(statusCode, response);
    }

    public void onSuccess(int statusCode, JSONArray response) {
        this.onSuccess(response);
    }

    public void onFailure(Throwable e, JSONObject errorResponse) {
        this.onFailure(e);
    }

    public void onFailure(int statusCode, Throwable e, JSONObject errorResponse) {
        this.onFailure(e, errorResponse);
    }

    public void onFailure(int statusCode, Header[] headers, Throwable e, JSONObject errorResponse) {
        this.onFailure(statusCode, e, errorResponse);
    }

    public void onFailure(Throwable e, JSONArray errorResponse) {
        this.onFailure(e);
    }

    public void onFailure(int statusCode, Throwable e, JSONArray errorResponse) {
        this.onFailure(e, errorResponse);
    }

    public void onFailure(int statusCode, Header[] headers, Throwable e, JSONArray errorResponse) {
        this.onFailure(statusCode, e, errorResponse);
    }

    @Override
    public void onSuccess(final int statusCode, final Header[] headers, final String responseBody) {
        if (statusCode != 204) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        final Object jsonResponse = JsonHttpResponseHandler.this.parseResponse(responseBody);
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                if (jsonResponse instanceof JSONObject) {
                                    JsonHttpResponseHandler.this.onSuccess(statusCode, headers, (JSONObject)jsonResponse);
                                } else if (jsonResponse instanceof JSONArray) {
                                    JsonHttpResponseHandler.this.onSuccess(statusCode, headers, (JSONArray)jsonResponse);
                                } else if (jsonResponse instanceof String) {
                                    JsonHttpResponseHandler.this.onSuccess(statusCode, headers, (String)jsonResponse);
                                } else {
                                    JsonHttpResponseHandler.this.onFailure((Throwable)new JSONException("Unexpected type " + jsonResponse.getClass().getName()), (JSONObject)null);
                                }
                            }
                        });
                    }
                    catch (JSONException ex) {
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                JsonHttpResponseHandler.this.onFailure((Throwable)ex, (JSONObject)null);
                            }
                        });
                    }
                }
            }).start();
        } else {
            this.onSuccess(statusCode, headers, new JSONObject());
        }
    }

    @Override
    public void onFailure(final int statusCode, final Header[] headers, final String responseBody, final Throwable e) {
        if (responseBody != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        final Object jsonResponse = JsonHttpResponseHandler.this.parseResponse(responseBody);
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                if (jsonResponse instanceof JSONObject) {
                                    JsonHttpResponseHandler.this.onFailure(statusCode, headers, e, (JSONObject)jsonResponse);
                                } else if (jsonResponse instanceof JSONArray) {
                                    JsonHttpResponseHandler.this.onFailure(statusCode, headers, e, (JSONArray)jsonResponse);
                                } else if (jsonResponse instanceof String) {
                                    JsonHttpResponseHandler.this.onFailure(statusCode, headers, e, (String)jsonResponse);
                                } else {
                                    JsonHttpResponseHandler.this.onFailure((Throwable)new JSONException("Unexpected type " + jsonResponse.getClass().getName()), (JSONObject)null);
                                }
                            }
                        });
                    }
                    catch (JSONException ex) {
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                JsonHttpResponseHandler.this.onFailure(statusCode, headers, (Throwable)ex, (JSONObject)null);
                            }
                        });
                    }
                }
            }).start();
        } else {
            Log.v((String)LOG_TAG, (String)"response body is null, calling onFailure(Throwable, JSONObject)");
            this.onFailure(statusCode, headers, e, (JSONObject)null);
        }
    }

    protected Object parseResponse(String responseBody) throws JSONException {
        if (null == responseBody) {
            return null;
        }
        Object result = null;
        String jsonString = responseBody.trim();
        if (jsonString.startsWith("{") || jsonString.startsWith("[")) {
            result = new JSONTokener(jsonString).nextValue();
        }
        if (result == null) {
            result = jsonString;
        }
        return result;
    }
}

