/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.ui;

import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.text.InputFilter;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import com.loginradius.androidsdk.R;
import com.loginradius.androidsdk.ui.CountriesDialog;
import com.loginradius.androidsdk.ui.CountryCodes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class RequiredFieldsViewGenerator
implements View.OnFocusChangeListener {
    private Context context;
    private int fields_color;

    public RequiredFieldsViewGenerator(Context context, int fields_color) {
        this.context = context;
        this.fields_color = fields_color == 0 ? ContextCompat.getColor((Context)context, (int)R.color.wv_fields_color) : fields_color;
    }

    public ScrollView generateParentView() {
        ScrollView svParent = new ScrollView(this.context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        svParent.setLayoutParams((ViewGroup.LayoutParams)params);
        svParent.setBackgroundColor(Color.parseColor((String)"#fafafa"));
        return svParent;
    }

    public LinearLayout generateParentContainerView() {
        LinearLayout linearContainer = new LinearLayout(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        linearContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        int tenPx = this.getPx(10);
        linearContainer.setPadding(tenPx, 0, tenPx, tenPx);
        linearContainer.setOrientation(1);
        return linearContainer;
    }

    public TextView generateLabelTextView(String value) {
        TextView tvLabel = new TextView(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        tvLabel.setText((CharSequence)value);
        tvLabel.setTextColor(this.fields_color);
        params.setMargins(0, this.getPx(10), 0, 0);
        tvLabel.setLayoutParams((ViewGroup.LayoutParams)params);
        return tvLabel;
    }

    public EditText generateEmailEditText(String tag) {
        EditText editText = new EditText(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, this.getPx(5), 0, 0);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setTag((Object)tag);
        editText.setBackgroundColor(-1);
        editText.setInputType(32);
        editText.setPadding(this.getPx(10), this.getPx(10), this.getPx(10), this.getPx(10));
        editText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        editText.setBackgroundResource(R.drawable.gray_border);
        return editText;
    }

    public EditText generatePasswordEditText(String tag, int maxLength) {
        EditText editText = new EditText(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, this.getPx(5), 0, 0);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setBackgroundColor(-1);
        editText.setPadding(this.getPx(10), this.getPx(10), this.getPx(10), this.getPx(10));
        editText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        editText.setBackgroundResource(R.drawable.gray_border);
        editText.setInputType(129);
        InputFilter[] arrFilter = new InputFilter[]{new InputFilter.LengthFilter(maxLength)};
        editText.setFilters(arrFilter);
        editText.setTag((Object)tag);
        return editText;
    }

    public LinearLayout generatePhoneNumberView(String tag) {
        final LinearLayout linearLayout = new LinearLayout(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, this.getPx(5), 0, 0);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        linearLayout.setPadding(this.getPx(1), this.getPx(1), this.getPx(1), this.getPx(1));
        linearLayout.setOrientation(0);
        linearLayout.setBackgroundResource(R.drawable.gray_border);
        params = new LinearLayout.LayoutParams(this.getPx(15), -1);
        params.setMargins(this.getPx(5), 0, 0, 0);
        ImageView imageView = new ImageView(this.context);
        imageView.setLayoutParams((ViewGroup.LayoutParams)params);
        imageView.setImageResource(R.drawable.down_arrow);
        params = new LinearLayout.LayoutParams(this.getPx(1), -1);
        params.setMargins(this.getPx(10), 0, 0, 0);
        final LinearLayout separator = new LinearLayout(this.context);
        separator.setBackgroundColor(Color.parseColor((String)"#8c8c8c"));
        separator.setLayoutParams((ViewGroup.LayoutParams)params);
        params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(this.getPx(5), this.getPx(1), 0, this.getPx(1));
        final EditText etCountryCode = new EditText(this.context);
        etCountryCode.setText((CharSequence)"+1");
        etCountryCode.setTextColor(-16777216);
        etCountryCode.setTextAppearance(this.context, 16973900);
        etCountryCode.setBackgroundColor(Color.parseColor((String)"#fafafa"));
        etCountryCode.setLayoutParams((ViewGroup.LayoutParams)params);
        etCountryCode.setTag((Object)(tag + "country_code"));
        params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(this.getPx(5), 0, this.getPx(5), 0);
        EditText editText = new EditText(this.context);
        editText.setInputType(2);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setPadding(0, 0, this.getPx(5), 0);
        editText.setTag((Object)tag);
        editText.setGravity(16);
        editText.setBackgroundColor(Color.parseColor((String)"#fafafa"));
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ArrayList<String> countries = new ArrayList<String>();
                Map<String, String> map = new CountryCodes().map;
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    countries.add(entry.getKey());
                }
                Collections.sort(countries, new CountryCodes.StringComparator());
                CountriesDialog dialog = new CountriesDialog(RequiredFieldsViewGenerator.this.context, countries);
                dialog.setOnCountrySelectedListener(new CountriesDialog.OnCountrySelectedListener(){

                    @Override
                    public void onCountrySelected(String country) {
                        String callingCode = new CountryCodes().getCallingCode(country);
                        if (callingCode.length() == 0) {
                            callingCode = "+1";
                        }
                        if (!callingCode.startsWith("+")) {
                            callingCode = "+" + callingCode;
                        }
                        etCountryCode.setText((CharSequence)callingCode);
                    }
                });
                dialog.show();
            }
        });
        etCountryCode.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    separator.setBackgroundColor(Color.parseColor((String)"#2299DD"));
                    linearLayout.setBackgroundResource(R.drawable.focus_border);
                } else {
                    separator.setBackgroundColor(Color.parseColor((String)"#8c8c8c"));
                    linearLayout.setBackgroundResource(R.drawable.gray_border);
                }
            }
        });
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    separator.setBackgroundColor(Color.parseColor((String)"#2299DD"));
                    linearLayout.setBackgroundResource(R.drawable.focus_border);
                } else {
                    separator.setBackgroundColor(Color.parseColor((String)"#8c8c8c"));
                    linearLayout.setBackgroundResource(R.drawable.gray_border);
                }
            }
        });
        linearLayout.setTag((Object)("view_" + tag));
        linearLayout.addView((View)imageView);
        linearLayout.addView((View)etCountryCode);
        linearLayout.addView((View)separator);
        linearLayout.addView((View)editText);
        return linearLayout;
    }

    public EditText generateEditText(String tag, boolean isNumeric) {
        EditText editText = new EditText(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, this.getPx(5), 0, 0);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setTag((Object)tag);
        editText.setBackgroundColor(-1);
        editText.setPadding(this.getPx(10), this.getPx(10), this.getPx(10), this.getPx(10));
        editText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        editText.setBackgroundResource(R.drawable.gray_border);
        if (isNumeric) {
            editText.setInputType(2);
        } else {
            editText.setInputType(1);
        }
        return editText;
    }

    public TextView generateTextView(String tag, String text) {
        TextView textView = new TextView(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, this.getPx(5), 0, 0);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setTag((Object)tag);
        textView.setText((CharSequence)text);
        textView.setTextColor(-16777216);
        textView.setBackgroundColor(-1);
        textView.setTextAppearance(this.context, 16973900);
        textView.setPadding(this.getPx(10), this.getPx(10), this.getPx(10), this.getPx(10));
        textView.setBackgroundResource(R.drawable.gray_border);
        textView.setClickable(true);
        return textView;
    }

    public TextView generateOptionsTextView(String tag, final String title, final String[] options, final DialogInterface.OnClickListener listener) {
        final TextView textView = new TextView(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        textView.setText((CharSequence)"Select");
        textView.setTag((Object)tag);
        textView.setTextColor(-16777216);
        textView.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        textView.setBackgroundResource(R.drawable.gray_border);
        textView.setTextAppearance(this.context, 16973900);
        textView.setPadding(this.getPx(10), this.getPx(10), this.getPx(10), this.getPx(10));
        textView.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.down_arrow, 0);
        params.setMargins(0, this.getPx(10), 0, 0);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RequiredFieldsViewGenerator.this.showOptionsDialog(title, textView, options, listener);
            }
        });
        return textView;
    }

    private void showOptionsDialog(String title, final TextView tvLabel, final String[] options, final DialogInterface.OnClickListener listener) {
        AlertDialog.Builder alert = new AlertDialog.Builder(this.context);
        alert.setTitle((CharSequence)title);
        alert.setItems((CharSequence[])options, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                tvLabel.setText((CharSequence)options[which]);
                if (listener != null) {
                    listener.onClick(dialog, which);
                }
            }
        });
        alert.show();
    }

    public TextView generateDateTextView(String tag) {
        final TextView tvDate = new TextView(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        tvDate.setText((CharSequence)"Select");
        tvDate.setTag((Object)tag);
        tvDate.setTextColor(-16777216);
        tvDate.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        tvDate.setBackgroundResource(R.drawable.gray_border);
        tvDate.setTextAppearance(this.context, 16973900);
        params.setMargins(0, this.getPx(10), 0, 0);
        tvDate.setLayoutParams((ViewGroup.LayoutParams)params);
        tvDate.setPadding(this.getPx(10), this.getPx(11), this.getPx(10), this.getPx(11));
        tvDate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RequiredFieldsViewGenerator.this.showDateDialog(tvDate);
            }
        });
        return tvDate;
    }

    private void showDateDialog(final TextView tvDate) {
        Calendar c = Calendar.getInstance();
        DatePickerDialog dialog = new DatePickerDialog(this.context, new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
                String dob = String.format("%02d", month + 1) + "-" + String.format("%02d", dayOfMonth) + "-" + year;
                SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy", Locale.getDefault());
                try {
                    Date date = dateFormat.parse(dob);
                    dateFormat.applyPattern("dd MMM yy");
                    String strDob = dateFormat.format(date);
                    tvDate.setText((CharSequence)strDob);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }, c.get(1), c.get(2), c.get(5));
        dialog.getDatePicker().setMaxDate(new Date().getTime() - 1000L);
        dialog.show();
    }

    public CheckBox generateCheckBox(String tag, String value, boolean isChecked) {
        CheckBox checkBox = new CheckBox(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(0, this.getPx(10), 0, 0);
        checkBox.setText((CharSequence)value);
        checkBox.setTag((Object)tag);
        checkBox.setChecked(isChecked);
        checkBox.setTextColor(this.fields_color);
        checkBox.setLayoutParams((ViewGroup.LayoutParams)params);
        return checkBox;
    }

    public View generateSeparator() {
        View view = new View(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.getPx(1));
        params.setMargins(0, this.getPx(5), 0, 0);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        view.setBackgroundColor(Color.parseColor((String)"#2299DD"));
        return view;
    }

    public RelativeLayout generateProgressBar() {
        RelativeLayout layout2 = new RelativeLayout(this.context);
        ProgressBar progressBar = new ProgressBar(this.context);
        progressBar.setId(R.id.progressBar);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)params);
        layout2.addView((View)progressBar);
        TextView tvLabel = new TextView(this.context);
        tvLabel.setText((CharSequence)"Please wait...");
        tvLabel.setTextColor(-16777216);
        tvLabel.setPadding(0, this.getPx(10), 0, 0);
        params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(3, progressBar.getId());
        params.addRule(14);
        tvLabel.setLayoutParams((ViewGroup.LayoutParams)params);
        layout2.addView((View)tvLabel);
        return layout2;
    }

    public Button generateSubmitButton(String text) {
        Button button = new Button(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, this.getPx(20), 0, 0);
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        button.setBackgroundColor(this.fields_color);
        button.setTextColor(-1);
        button.setTag((Object)"submit");
        button.setText((CharSequence)text);
        button.setAllCaps(false);
        return button;
    }

    public Button generateResendOTPButton() {
        Button button = new Button(this.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, this.getPx(20), 0, 0);
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        button.setBackgroundColor(this.fields_color);
        button.setTextColor(-1);
        button.setTag((Object)"resend_otp");
        button.setText((CharSequence)"Resend OTP");
        button.setAllCaps(false);
        return button;
    }

    public RelativeLayout generateOTPLayout() {
        RelativeLayout layout2 = new RelativeLayout(this.context);
        LinearLayout container = new LinearLayout(this.context);
        container.setOrientation(1);
        layout2.setBackgroundColor(-1);
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(-1, -2);
        relParams.addRule(13);
        container.setLayoutParams((ViewGroup.LayoutParams)relParams);
        container.addView((View)this.generateLabelTextView("Enter OTP"));
        container.addView((View)this.generateEditText("otp", false));
        container.addView((View)this.generateSubmitButton("Submit"));
        container.addView((View)this.generateResendOTPButton());
        layout2.setPadding(this.getPx(10), 0, this.getPx(10), this.getPx(10));
        layout2.addView((View)container);
        return layout2;
    }

    public HashMap<String, String> getValuesMap(LinearLayout parentContainer) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < parentContainer.getChildCount(); ++i) {
            View view = parentContainer.getChildAt(i);
            if (view instanceof EditText) {
                EditText editText = (EditText)view;
                map.put((String)editText.getTag(), editText.getText().toString().trim());
                continue;
            }
            if (view instanceof CheckBox) {
                CheckBox checkBox = (CheckBox)view;
                map.put((String)checkBox.getTag(), String.valueOf(checkBox.isChecked()));
                continue;
            }
            if (view instanceof TextView) {
                TextView textView = (TextView)view;
                map.put((String)textView.getTag(), textView.getText().toString());
                continue;
            }
            if (!(view instanceof LinearLayout)) continue;
            LinearLayout layout2 = (LinearLayout)view;
            EditText editText = (EditText)layout2.getChildAt(3);
            EditText etCountryCode = (EditText)layout2.getChildAt(1);
            map.put((String)etCountryCode.getTag(), etCountryCode.getText().toString().trim());
            map.put((String)editText.getTag(), editText.getText().toString().trim());
        }
        return map;
    }

    public View getViewByTag(LinearLayout parentContainer, String tag) {
        for (int i = 0; i < parentContainer.getChildCount(); ++i) {
            View view = parentContainer.getChildAt(i);
            String viewTag = (String)view.getTag();
            if (viewTag == null || !viewTag.equals(tag)) continue;
            return view;
        }
        return null;
    }

    public int getPx(int dp) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        return Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (hasFocus) {
            view.setBackgroundResource(R.drawable.focus_border);
        } else {
            view.setBackgroundResource(R.drawable.gray_border);
        }
    }
}

