/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.ui;

import android.content.DialogInterface;
import android.util.Log;
import android.util.Patterns;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import com.loginradius.androidsdk.R;
import com.loginradius.androidsdk.response.traditionalinterface.UserRegistration;
import com.loginradius.androidsdk.response.userprofile.LoginRadiusUltimateUserProfile;
import com.loginradius.androidsdk.ui.CountriesDialog;
import com.loginradius.androidsdk.ui.CountryCodes;
import com.loginradius.androidsdk.ui.RequiredFieldsViewGenerator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FieldViewUtil {
    private String country = "";
    private String countryCode = "";
    private String[] gender;
    private String genderCode;
    private String email;
    private String phone;
    private HashMap<String, Boolean> fieldMap = new HashMap();

    public boolean addFieldView(RequiredFieldsViewGenerator gtr, LoginRadiusUltimateUserProfile userProfile, UserRegistration userField, LinearLayout linearContainer, LinkedTreeMap customFields, boolean promptPassword) {
        switch (userField.getName()) {
            case "firstname": {
                if (userProfile.FirstName != null && userProfile.FirstName.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "lastname": {
                if (userProfile.LastName != null && userProfile.LastName.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "prefix": {
                if (userProfile.Prefix != null && userProfile.Prefix.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "suffix": {
                if (userProfile.Suffix != null && userProfile.Suffix.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "username": {
                if (userProfile.getUserName() != null && userProfile.getUserName().toString().length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "phonenumber": {
                if (userProfile.PhoneNumbers != null && userProfile.PhoneNumbers.size() != 0 && userProfile.PhoneNumbers.get(0) != null && userProfile.PhoneNumbers.get((int)0).phoneNumber != null && userProfile.PhoneNumbers.get((int)0).phoneNumber.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generatePhoneNumberView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "state": {
                if (userProfile.State != null && userProfile.State.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "city": {
                if (userProfile.City != null && userProfile.City.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "PostalCode": {
                if (userProfile.Addresses != null && userProfile.Addresses.size() != 0 && userProfile.Addresses.get(0) != null && userProfile.Addresses.get((int)0).PostalCode != null && userProfile.Addresses.get((int)0).PostalCode.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), true));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "address1": {
                if (userProfile.Addresses != null && userProfile.Addresses.size() != 0 && userProfile.Addresses.get(0) != null && userProfile.Addresses.get((int)0).Address1 != null && userProfile.Addresses.get((int)0).Address1.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "address2": {
                if (userProfile.Addresses != null && userProfile.Addresses.size() != 0 && userProfile.Addresses.get(0) != null && userProfile.Addresses.get((int)0).Address2 != null && userProfile.Addresses.get((int)0).Address2.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "phoneid": {
                if (userProfile.PhoneId != null && userProfile.PhoneId.length() != 0 && (userProfile.PhoneId.length() <= 0 || userProfile.PhoneIdVerified.booleanValue())) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generatePhoneNumberView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "nickname": {
                if (userProfile.NickName != null && userProfile.NickName.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "emailid": {
                if (userProfile.Email != null && userProfile.Email.size() != 0 && userProfile.Email.get(0) != null && userProfile.Email.get((int)0).Value != null && userProfile.Email.get((int)0).Value.length() != 0 && (userProfile.Email.get((int)0).Value.length() <= 0 || userProfile.getEmailVerified().booleanValue())) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEmailEditText(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "password": {
                if (userProfile.getPassword() != null || !promptPassword) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generatePasswordEditText(userField.getName(), 10));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "confirmpassword": {
                if (userProfile.getPassword() != null || !promptPassword) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generatePasswordEditText("confirmpassword", 10));
                this.addFieldMap("confirmpassword", userField.getRules().contains("required"));
                return true;
            }
            case "country": {
                if (userProfile.Country != null && userProfile.Country.Name != null && userProfile.Country.Name.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                final ArrayList<String> countries = new ArrayList<String>();
                Map<String, String> map = new CountryCodes().map;
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    countries.add(entry.getKey());
                }
                Collections.sort(countries, new CountryCodes.StringComparator());
                final TextView textView = gtr.generateTextView("country", "Select");
                textView.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.down_arrow, 0);
                textView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CountriesDialog dialog = new CountriesDialog(textView.getContext(), countries);
                        dialog.setOnCountrySelectedListener(new CountriesDialog.OnCountrySelectedListener(){

                            @Override
                            public void onCountrySelected(String country) {
                                FieldViewUtil.this.country = country;
                                textView.setText((CharSequence)country);
                            }
                        });
                        dialog.show();
                    }
                });
                linearContainer.addView((View)textView);
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "gender": {
                Log.i((String)"Gender", (String)userField.getOptions().toString());
                if (userProfile.Gender != null && userProfile.Gender.length() != 0) break;
                final ArrayList options = (ArrayList)userField.getOptions();
                this.gender = new String[options.size()];
                for (int j = 0; j < options.size(); ++j) {
                    this.gender[j] = (String)((LinkedTreeMap)options.get(j)).get((Object)"text");
                }
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateOptionsTextView("gender", "Select Gender", this.gender, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        FieldViewUtil.this.genderCode = (String)((LinkedTreeMap)options.get(which)).get((Object)"value");
                    }
                }));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "birthdate": {
                if (userProfile.BirthDate != null && userProfile.BirthDate.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "school_startDate": {
                if (userProfile.BirthDate != null && userProfile.BirthDate.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "school_endDate": {
                if (userProfile.BirthDate != null && userProfile.BirthDate.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "position_startDate": {
                if (userProfile.BirthDate != null && userProfile.BirthDate.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "position_endDate": {
                if (userProfile.BirthDate != null && userProfile.BirthDate.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "company": {
                if (userProfile.Positions != null && userProfile.Positions.size() != 0 && userProfile.Positions.get(0) != null && userProfile.Positions.get((int)0).Company != null && userProfile.Positions.get((int)0).Company.Name != null && userProfile.Positions.get((int)0).Company.Name.length() != 0) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "emailsubscription": {
                if (userProfile.getIsEmailSubscribed().booleanValue()) break;
                linearContainer.addView((View)gtr.generateCheckBox("IsEmailSubscribed", userField.getDisplay(), false));
                this.addFieldMap("IsEmailSubscribed", userField.getRules().contains("required"));
                return true;
            }
            default: {
                String value = "";
                if (userField.getName().startsWith("cf_")) {
                    String name = userField.getName().replace("cf_", "");
                    if (customFields != null && customFields.get((Object)name) != null) {
                        value = customFields.get((Object)name).toString();
                    }
                }
                if (value != null && value.length() != 0) break;
                if (userField.getType().equals("string") || userField.getType().equals("text")) {
                    linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                    if (userField.getRules().contains("numeric")) {
                        linearContainer.addView((View)gtr.generateEditText(userField.getName(), true));
                    } else {
                        linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                    }
                    this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                    return true;
                }
                if (userField.getType().equals("option")) {
                    if (userField.getOptions() == null) break;
                    ArrayList optionsList = (ArrayList)userField.getOptions();
                    String[] arrOptions = new String[optionsList.size()];
                    for (int j = 0; j < optionsList.size(); ++j) {
                        arrOptions[j] = (String)((LinkedTreeMap)optionsList.get(j)).get((Object)"text");
                    }
                    linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                    linearContainer.addView((View)gtr.generateOptionsTextView(userField.getName(), "Select " + userField.getDisplay(), arrOptions, null));
                    this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                    return true;
                }
                if (userField.getType().equals("multi")) {
                    linearContainer.addView((View)gtr.generateCheckBox(userField.getName(), userField.getDisplay(), false));
                    this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                    return true;
                }
                if (userField.getType().equals("password")) {
                    linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                    linearContainer.addView((View)gtr.generatePasswordEditText(userField.getName(), 10));
                    this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                    return true;
                }
                if (!userField.getType().equals("email")) break;
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEmailEditText(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
        }
        return false;
    }

    public boolean addFieldView(RequiredFieldsViewGenerator gtr, String fieldName, UserRegistration userField, LinearLayout linearContainer) {
        switch (fieldName) {
            case "firstname": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "lastname": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "prefix": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "suffix": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "username": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "phonenumber": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generatePhoneNumberView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "state": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "city": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "PostalCode": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), true));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "address1": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "address2": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "phoneid": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generatePhoneNumberView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "nickname": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "emailid": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEmailEditText(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "password": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generatePasswordEditText(userField.getName(), 10));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "confirmpassword": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generatePasswordEditText("confirmpassword", 10));
                this.addFieldMap("confirmpassword", userField.getRules().contains("required"));
                return true;
            }
            case "country": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                final ArrayList<String> countries = new ArrayList<String>();
                Map<String, String> map = new CountryCodes().map;
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    countries.add(entry.getKey());
                }
                Collections.sort(countries, new CountryCodes.StringComparator());
                final TextView textView = gtr.generateTextView("country", "Select");
                textView.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.down_arrow, 0);
                textView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CountriesDialog dialog = new CountriesDialog(textView.getContext(), countries);
                        dialog.setOnCountrySelectedListener(new CountriesDialog.OnCountrySelectedListener(){

                            @Override
                            public void onCountrySelected(String country) {
                                FieldViewUtil.this.country = country;
                                textView.setText((CharSequence)country);
                            }
                        });
                        dialog.show();
                    }
                });
                linearContainer.addView((View)textView);
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "gender": {
                Log.i((String)"Gender", (String)userField.getOptions().toString());
                final ArrayList options = (ArrayList)userField.getOptions();
                this.gender = new String[options.size()];
                for (int j = 0; j < options.size(); ++j) {
                    this.gender[j] = (String)((LinkedTreeMap)options.get(j)).get((Object)"text");
                }
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateOptionsTextView("gender", "Select Gender", this.gender, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        FieldViewUtil.this.genderCode = (String)((LinkedTreeMap)options.get(which)).get((Object)"value");
                    }
                }));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "birthdate": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "school_startDate": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "school_endDate": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "position_startDate": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "position_endDate": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateDateTextView(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "company": {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            case "emailsubscription": {
                linearContainer.addView((View)gtr.generateCheckBox("IsEmailSubscribed", userField.getDisplay(), false));
                this.addFieldMap("IsEmailSubscribed", userField.getRules().contains("required"));
                return true;
            }
        }
        if (userField.getType().equals("string") || userField.getType().equals("text")) {
            linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
            if (userField.getRules().contains("numeric")) {
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), true));
            } else {
                linearContainer.addView((View)gtr.generateEditText(userField.getName(), false));
            }
            this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
            return true;
        }
        if (userField.getType().equals("option")) {
            if (userField.getOptions() != null) {
                ArrayList optionsList = (ArrayList)userField.getOptions();
                String[] arrOptions = new String[optionsList.size()];
                for (int j = 0; j < optionsList.size(); ++j) {
                    arrOptions[j] = (String)((LinkedTreeMap)optionsList.get(j)).get((Object)"text");
                }
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateOptionsTextView(userField.getName(), "Select " + userField.getDisplay(), arrOptions, null));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
        } else {
            if (userField.getType().equals("multi")) {
                linearContainer.addView((View)gtr.generateCheckBox(userField.getName(), userField.getDisplay(), false));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            if (userField.getType().equals("password")) {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generatePasswordEditText(userField.getName(), 10));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
            if (userField.getType().equals("email")) {
                linearContainer.addView((View)gtr.generateLabelTextView(userField.getDisplay()));
                linearContainer.addView((View)gtr.generateEmailEditText(userField.getName()));
                this.addFieldMap(userField.getName(), userField.getRules().contains("required"));
                return true;
            }
        }
        return false;
    }

    public boolean validateFields(RequiredFieldsViewGenerator gtr, LinearLayout linearContainer) {
        boolean validated = true;
        HashMap<String, String> map = gtr.getValuesMap(linearContainer);
        for (Map.Entry<String, Boolean> entry : this.fieldMap.entrySet()) {
            CheckBox cbEmail;
            String key = entry.getKey();
            String value = map.get(key);
            boolean isRequired = this.fieldMap.get(key);
            TextView view = (TextView)gtr.getViewByTag(linearContainer, key);
            if (key.equals("birthdate") || key.equals("gender") || key.equals("country")) {
                if (value.equals("Select") && isRequired) {
                    view.setError((CharSequence)"Required");
                    view.setBackgroundResource(R.drawable.red_border);
                    validated = false;
                }
            } else if (key.equals("phonenumber") || key.equals("phoneid")) {
                if (value.length() == 0 && isRequired) {
                    LinearLayout linearLayout = (LinearLayout)linearContainer.findViewWithTag((Object)("view_" + key));
                    EditText editText = (EditText)linearLayout.getChildAt(3);
                    editText.setError((CharSequence)"Required");
                    linearLayout.setBackgroundResource(R.drawable.red_border);
                    validated = false;
                }
            } else if (value != null && value.length() == 0 && isRequired) {
                view.setError((CharSequence)"Required");
                view.setBackgroundResource(R.drawable.red_border);
                validated = false;
            } else if ((key.equals("password") || key.equals("confirmpassword")) && isRequired) {
                String confirmPwd;
                EditText etPassword = (EditText)gtr.getViewByTag(linearContainer, "password");
                EditText etConfirmPassword = (EditText)gtr.getViewByTag(linearContainer, "confirmpassword");
                String pwd = etPassword.getText().toString();
                if (etConfirmPassword != null && !pwd.equals(confirmPwd = etConfirmPassword.getText().toString())) {
                    etConfirmPassword.setError((CharSequence)"Password Mismatch");
                    etConfirmPassword.setBackgroundResource(R.drawable.red_border);
                    validated = false;
                }
                if (pwd.length() < 6) {
                    etPassword.setError((CharSequence)"Password must be at least 6 characters");
                    etPassword.setBackgroundResource(R.drawable.red_border);
                    validated = false;
                }
            } else if (key.equals("emailid") && isRequired) {
                EditText etEmail = (EditText)gtr.getViewByTag(linearContainer, "emailid");
                String email = etEmail.getText().toString();
                if (!email.matches(Patterns.EMAIL_ADDRESS.pattern())) {
                    etEmail.setError((CharSequence)"Invalid");
                    etEmail.setBackgroundResource(R.drawable.red_border);
                    validated = false;
                }
            } else if (key.equals("IsEmailSubscribed") && isRequired && !(cbEmail = (CheckBox)gtr.getViewByTag(linearContainer, "IsEmailSubscribed")).isChecked()) {
                cbEmail.setError((CharSequence)"Required");
                validated = false;
            }
            if (view == null) continue;
            view.setBackgroundResource(R.drawable.gray_border);
        }
        return validated;
    }

    public JsonObject getData(RequiredFieldsViewGenerator gtr, LinearLayout linearContainer) {
        HashMap<String, String> map = gtr.getValuesMap(linearContainer);
        JsonObject jsonData = new JsonObject();
        JsonObject jsonCustom = new JsonObject();
        JsonArray arrAddress = new JsonArray();
        JsonObject address = new JsonObject();
        JsonObject jsonPosition = new JsonObject();
        JsonArray arrPositions = new JsonArray();
        JsonObject jsonEducation = new JsonObject();
        JsonArray arrEducation = new JsonArray();
        JsonObject jsonIMAccount = new JsonObject();
        JsonArray arrIMAccount = new JsonArray();
        JsonObject jsonInterest = new JsonObject();
        JsonArray arrInterest = new JsonArray();
        JsonObject jsonSport = new JsonObject();
        JsonArray arrSport = new JsonArray();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String countryCode;
            String value;
            String key = entry.getKey();
            if (key == null || key.equals("submit")) continue;
            if ((key.equals("birthdate") || key.equals("gender") || key.equals("country")) && (value = map.get(key)).equals("Select")) {
                map.put(key, "");
            }
            if (key.equals("gender")) {
                jsonData.addProperty("gender", this.genderCode);
                continue;
            }
            if (key.equals("company")) {
                JsonObject jsonCompany = new JsonObject();
                jsonCompany.addProperty("Type", "Primary");
                jsonCompany.addProperty("Industry", "");
                jsonCompany.addProperty("Name", map.get(key));
                jsonPosition.add("Company", (JsonElement)jsonCompany);
                continue;
            }
            if (key.equals("position")) {
                jsonPosition.addProperty("Positions", map.get(key));
                continue;
            }
            if (key.equals("position_summary")) {
                jsonPosition.addProperty("Summary", map.get(key));
                continue;
            }
            if (key.equals("position_startDate")) {
                jsonPosition.addProperty("StartDate", this.getApiDate(map.get(key)));
                continue;
            }
            if (key.equals("position_endDate")) {
                jsonPosition.addProperty("EndDate", this.getApiDate(map.get(key)));
                continue;
            }
            if (key.equals("school")) {
                jsonEducation.addProperty("School", map.get(key));
                continue;
            }
            if (key.equals("school_year")) {
                jsonEducation.addProperty("year", map.get(key));
                continue;
            }
            if (key.equals("school_type")) {
                jsonEducation.addProperty("type", map.get(key));
                continue;
            }
            if (key.equals("school_notes")) {
                jsonEducation.addProperty("notes", map.get(key));
                continue;
            }
            if (key.equals("school_activities")) {
                jsonEducation.addProperty("activities", map.get(key));
                continue;
            }
            if (key.equals("school_degree")) {
                jsonEducation.addProperty("degree", map.get(key));
                continue;
            }
            if (key.equals("school_fieldofstudy")) {
                jsonEducation.addProperty("fieldofstudy", map.get(key));
                continue;
            }
            if (key.equals("school_startDate")) {
                jsonEducation.addProperty("StartDate", this.getApiDate(map.get(key)));
                continue;
            }
            if (key.equals("school_endDate")) {
                jsonEducation.addProperty("EndDate", this.getApiDate(map.get(key)));
                continue;
            }
            if (key.equals("accountType")) {
                jsonIMAccount.addProperty("AccountType", map.get(key));
                continue;
            }
            if (key.equals("accountName")) {
                jsonIMAccount.addProperty("AccountName", map.get(key));
                continue;
            }
            if (key.equals("interestedType")) {
                jsonInterest.addProperty("InterestedType", map.get(key));
                continue;
            }
            if (key.equals("interestedName")) {
                jsonInterest.addProperty("InterestedName", map.get(key));
                continue;
            }
            if (key.equals("sport_id")) {
                jsonSport.addProperty("Id", map.get(key));
                continue;
            }
            if (key.equals("sport_name")) {
                jsonSport.addProperty("Name", map.get(key));
                continue;
            }
            if (key.equals("address1")) {
                address.addProperty("Address1", map.get(key));
                continue;
            }
            if (key.equals("address2")) {
                address.addProperty("Address2", map.get(key));
                continue;
            }
            if (key.equals("PostalCode")) {
                address.addProperty("PostalCode", map.get(key));
                continue;
            }
            if (key.equals("country")) {
                JsonObject jsonCountry = new JsonObject();
                jsonCountry.addProperty("Name", this.country);
                this.countryCode = new CountryCodes().getCode(this.country);
                jsonCountry.addProperty("Code", this.countryCode);
                jsonData.add("Country", (JsonElement)jsonCountry);
                continue;
            }
            if (key.equals("emailid")) {
                this.email = map.get(key);
                JsonArray arrEmail = new JsonArray();
                JsonObject jsonEmail = new JsonObject();
                jsonEmail.addProperty("Type", "Primary");
                jsonEmail.addProperty("Value", this.email);
                arrEmail.add((JsonElement)jsonEmail);
                jsonData.add("Email", (JsonElement)arrEmail);
                continue;
            }
            if (key.equals("phonenumber")) {
                countryCode = map.get(key + "country_code");
                countryCode = countryCode.replace("-", "").replace("+", "");
                if (map.get(key).length() <= 0) continue;
                JsonArray arrPhone = new JsonArray();
                JsonObject jsonPhone = new JsonObject();
                jsonPhone.addProperty("PhoneType", "Primary");
                jsonPhone.addProperty("PhoneNumber", countryCode + map.get(key));
                arrPhone.add((JsonElement)jsonPhone);
                jsonData.add("PhoneNumbers", (JsonElement)arrPhone);
                continue;
            }
            if (key.equals("phoneid")) {
                countryCode = map.get(key + "country_code");
                countryCode = countryCode.replace("-", "").replace("+", "");
                if (map.get(key).length() <= 0) continue;
                this.phone = countryCode + map.get(key);
                jsonData.addProperty("phoneid", this.phone);
                continue;
            }
            if (key.equals("birthdate")) {
                jsonData.addProperty("birthdate", this.getApiDate(map.get(key)));
                continue;
            }
            if (key.startsWith("cf_")) {
                jsonCustom.addProperty(key.replace("cf_", ""), map.get(key));
                jsonData.add("CustomFields", (JsonElement)jsonCustom);
                continue;
            }
            if (key.contains("country_code")) continue;
            jsonData.addProperty(key, map.get(key));
        }
        if (address.size() > 0) {
            address.addProperty("Type", "Primary");
            arrAddress.add((JsonElement)address);
            jsonData.add("Addresses", (JsonElement)arrAddress);
        }
        if (jsonPosition.size() > 0) {
            arrPositions.add((JsonElement)jsonPosition);
            jsonData.add("Positions", (JsonElement)arrPositions);
        }
        if (jsonEducation.size() > 0) {
            arrEducation.add((JsonElement)jsonEducation);
            jsonData.add("Educations", (JsonElement)arrEducation);
        }
        if (jsonIMAccount.size() > 0) {
            arrIMAccount.add((JsonElement)jsonIMAccount);
            jsonData.add("IMAccounts", (JsonElement)arrIMAccount);
        }
        if (jsonInterest.size() > 0) {
            arrInterest.add((JsonElement)jsonInterest);
            jsonData.add("Interests", (JsonElement)arrInterest);
        }
        if (jsonSport.size() > 0) {
            arrSport.add((JsonElement)jsonSport);
            jsonData.add("Sports", (JsonElement)arrSport);
        }
        return jsonData;
    }

    private String getApiDate(String strDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yy", Locale.getDefault());
        try {
            Date date = dateFormat.parse(strDate);
            dateFormat.applyPattern("MM-dd-yyyy");
            String strDob = dateFormat.format(date);
            return strDob;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void addFieldMap(String name, boolean isRequired) {
        this.fieldMap.put(name, isRequired);
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }
}

