/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.helper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.loginradius.androidsdk.handler.ApiInterface;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.ExceptionResponse;
import com.loginradius.androidsdk.handler.RestRequest;
import com.loginradius.androidsdk.helper.GoogleSSO;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.helper.ProviderPermissions;
import com.loginradius.androidsdk.response.AccessTokenResponse;
import com.loginradius.androidsdk.response.socialinterface.Provider;
import com.vk.sdk.VKSdk;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoginRadiusAuthManager {
    private static final String MOBILE_EXT = "&ismobile=1";
    public static Boolean nativeLogin = false;
    public static AsyncHandler<AccessTokenResponse> asyncHandler;
    protected static String AKey;
    public static String ImageUrl;
    public static String ImgVersion;
    protected static CallbackManager lrCallbackManager;

    public static void setCallbackManager(String key, CallbackManager callback) {
        AKey = key;
        lrCallbackManager = callback;
    }

    public static void performLogin(Activity activity, Provider provider, AsyncHandler<AccessTokenResponse> asyncHandler) {
        LoginRadiusAuthManager.asyncHandler = asyncHandler;
        if (provider.getName().equalsIgnoreCase("facebook") && nativeLogin.booleanValue()) {
            LoginRadiusAuthManager.OpenFacebookSession(activity);
        } else if (provider.getName().equalsIgnoreCase("google") && nativeLogin.booleanValue()) {
            activity.startActivity(new Intent((Context)activity, GoogleSSO.class));
        } else if (provider.getName().equalsIgnoreCase("vkontakte") && nativeLogin.booleanValue()) {
            LoginRadiusAuthManager.OpenVkontakteSession(activity);
        } else {
            LoginRadiusAuthManager.performWebLogin(activity, provider);
        }
    }

    public static void getNativeAppConfiguration(String key, CallbackManager callback) {
        AKey = key;
        lrCallbackManager = callback;
    }

    public static void performWebLogin(Activity activity, Provider provider) {
    }

    private static void HandleFacebookToken() {
        try {
            String fbToken = AccessToken.getCurrentAccessToken().getToken().toString();
            LoginRadiusAuthManager.getResponseFb(fbToken, new AsyncHandler<AccessTokenResponse>(){

                @Override
                public void onSuccess(AccessTokenResponse data) {
                    data.provider = "facebook";
                    asyncHandler.onSuccess(data);
                }

                @Override
                public void onFailure(Throwable error, String code) {
                    asyncHandler.onFailure(error, code);
                }
            });
        }
        catch (FacebookOperationCanceledException f) {
            Log.i((String)"Cancel", (String)"facebook");
            asyncHandler.onFailure(new Throwable("Facebook Operation cancelled"), "lr_LOGIN_CANCELLED");
        }
    }

    public static void SetMissingPermission() {
        Set permissions = AccessToken.getCurrentAccessToken().getPermissions();
        List<String> CurrentPubPerms = ProviderPermissions.getFBPublishPermissionsArr();
        List<String> CurrentReadPerms = ProviderPermissions.getFBReadPermissionsArr();
        ArrayList<String> CurrentPerms = new ArrayList<String>();
        CurrentPerms.addAll(CurrentReadPerms);
        CurrentPerms.addAll(CurrentPubPerms);
        ProviderPermissions.resetPermissions();
        for (String sPerm : CurrentPerms) {
            ProviderPermissions.FacebookPermission[] temp;
            if (permissions.contains(sPerm)) continue;
            for (ProviderPermissions.FacebookPermission findid : temp = ProviderPermissions.FacebookPermission.values()) {
                if (findid.id != sPerm) continue;
                ProviderPermissions.addFbPermission(findid);
            }
        }
    }

    private static void OpenVkontakteSession(Activity activity) {
        if (VKSdk.isLoggedIn()) {
            VKSdk.logout();
        }
        VKSdk.login((Activity)activity, (String[])new String[]{"direct", "email", "friends", "wall", "status", "photos", "video"});
    }

    private static void OpenFacebookSession(Activity activity) {
        LoginManager.getInstance().registerCallback(lrCallbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

            public void onSuccess(LoginResult loginResult) {
                LoginRadiusAuthManager.HandleFacebookToken();
            }

            public void onCancel() {
                Log.i((String)"Cancel", (String)"facebook");
                asyncHandler.onFailure(new Throwable("Facebook Operation cancelled"), "lr_LOGIN_CANCELLED");
            }

            public void onError(FacebookException error) {
                asyncHandler.onFailure((Throwable)error, error.toString());
            }
        });
        LoginManager.getInstance().logInWithReadPermissions(activity, LoginRadiusSDK.getFaceBookPermissions());
    }

    public static boolean isOnline(Context c) {
        if (c == null) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)c.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.isAvailable() && ni.isConnected();
    }

    public static void onNativeFailure() {
        asyncHandler.onFailure(new Throwable("Facebook Operation cancelled"), "lr_LOGIN_CANCELLED");
    }

    public static void getResponseFb(String fbToken, AsyncHandler<AccessTokenResponse> handler) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", AKey);
        params.put("fb_access_token", fbToken);
        LoginRadiusAuthManager.providerHandler("api/v2/access_token/facebook", params, handler);
    }

    public static void getResponseGoogle(String googleToken, boolean offline, AsyncHandler<AccessTokenResponse> handler) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (offline) {
            params.put("apikey", AKey);
            params.put("google_authcode", googleToken);
        } else {
            params.put("key", AKey);
            params.put("google_access_token", googleToken);
        }
        LoginRadiusAuthManager.providerHandler("api/v2/access_token/google", params, handler);
    }

    public static void getResponseTwitter(String tw_access_token, String tw_token_secret, AsyncHandler<AccessTokenResponse> handler) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", LoginRadiusSDK.getApiKey());
        params.put("tw_access_token", tw_access_token);
        params.put("tw_token_secret", tw_token_secret);
        LoginRadiusAuthManager.providerHandler("/api/v2/access_token/twitter", params, handler);
    }

    public static void getResponseVkontakte(String vkontakteToken, AsyncHandler<AccessTokenResponse> handler) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", AKey);
        params.put("vk_access_token", vkontakteToken);
        LoginRadiusAuthManager.providerHandler("/api/v2/access_token/vkontakte", params, handler);
    }

    public static void getResponseWeChat(String code, AsyncHandler<AccessTokenResponse> handler) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", LoginRadiusSDK.getApiKey());
        params.put("code", code);
        LoginRadiusAuthManager.providerHandler("/api/v2/access_token/wechat", params, handler);
    }

    public static void providerHandler(String uri, Map<String, String> params, final AsyncHandler<AccessTokenResponse> handler) {
        if (LoginRadiusSDK.getSocialAppName() != "" && LoginRadiusSDK.getSocialAppName() != null) {
            params.put("SocialAppName", LoginRadiusSDK.getSocialAppName());
        }
        ApiInterface apiService = (ApiInterface)RestRequest.getClient().create(ApiInterface.class);
        apiService.getNativeLogin(uri, params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<AccessTokenResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(AccessTokenResponse response) {
                handler.onSuccess(response);
            }
        });
    }
}

