/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.api;

import com.google.gson.JsonObject;
import com.loginradius.androidsdk.handler.ApiInterface;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.ExceptionResponse;
import com.loginradius.androidsdk.handler.RestRequest;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.model.ChangePINModel;
import com.loginradius.androidsdk.model.PINRequiredModel;
import com.loginradius.androidsdk.model.ResetPINByEmailModel;
import com.loginradius.androidsdk.model.ResetPINByPhoneModel;
import com.loginradius.androidsdk.model.ResetPINByResetToken;
import com.loginradius.androidsdk.model.ResetPINByUserNameModel;
import com.loginradius.androidsdk.resource.QueryMapHelper;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.PostResponse;
import com.loginradius.androidsdk.response.login.LoginData;
import com.loginradius.androidsdk.response.phone.PhoneResponse;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;

public class PinAuthenticationAPI {
    private ApiInterface apiService = (ApiInterface)RestRequest.getClient().create(ApiInterface.class);

    public PinAuthenticationAPI() {
        if (!LoginRadiusSDK.validate()) {
            throw new LoginRadiusSDK.InitializeException();
        }
    }

    public void loginByPIN(QueryParams queryParams, PINRequiredModel data, final AsyncHandler<LoginData> handler) {
        this.apiService.getLoginByPin("identity/v2/auth/login/pin", QueryMapHelper.getMapLoginByPin(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onNext(LoginData value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void setPINByPinAuthToken(String pinAuthToken, PINRequiredModel data, final AsyncHandler<LoginData> handler) {
        this.apiService.getPINByPinAuthToken("identity/v2/auth/pin/set/pinauthtoken", QueryMapHelper.getMapSetPINByPinAuthToken(pinAuthToken), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onNext(LoginData value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void forgotPINByEmail(QueryParams queryParams, String email, final AsyncHandler<PostResponse> handler) {
        JsonObject data = new JsonObject();
        data.addProperty("email", email);
        this.apiService.getForgotPINByEmail("identity/v2/auth/pin/forgot/email", QueryMapHelper.getMapForgotPINByEmail(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void forgotPINByUserName(QueryParams queryParams, String userName, final AsyncHandler<PostResponse> handler) {
        JsonObject data = new JsonObject();
        data.addProperty("username", userName);
        this.apiService.getForgotPINByUserName("identity/v2/auth/pin/forgot/username", QueryMapHelper.getMapForgotPINByEmail(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void forgotPINByPhone(String phone, String smsTemplate, final AsyncHandler<PhoneResponse> handler) {
        JsonObject data = new JsonObject();
        data.addProperty("phone", phone);
        this.apiService.getForgotPINByPhone("identity/v2/auth/pin/forgot/otp", QueryMapHelper.getMapForgotPINByPhone(smsTemplate), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PhoneResponse>(){

            public void onNext(PhoneResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void invalidatePINSessionToken(String sessionToken, final AsyncHandler<PostResponse> handler) {
        this.apiService.getInvalidatePINSessionToken("identity/v2/auth/session_token/InValidate", QueryMapHelper.getinvalidatePINSessionTokenMap(sessionToken)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void resetPINByEmailAndOTP(ResetPINByEmailModel data, final AsyncHandler<PostResponse> handler) {
        this.apiService.getResetPINByEmail("identity/v2/auth/pin/reset/otp/email", QueryMapHelper.getMapPINReset(), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void resetPINByPhoneAndOTP(ResetPINByPhoneModel data, final AsyncHandler<PostResponse> handler) {
        this.apiService.getResetPINByPhone("identity/v2/auth/pin/reset/otp/phone", QueryMapHelper.getMapPINReset(), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void resetPINByUserNameAndOTP(ResetPINByUserNameModel data, final AsyncHandler<PostResponse> handler) {
        this.apiService.getResetPINByUserName("identity/v2/auth/pin/reset/otp/username", QueryMapHelper.getMapPINReset(), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void resetPINByResetToken(ResetPINByResetToken data, final AsyncHandler<PostResponse> handler) {
        this.apiService.getResetPINByResetToken("identity/v2/auth/pin/reset/token", QueryMapHelper.getMapPINReset(), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void resetPINByEmailAndSecurityQuestion(ResetPINByEmailModel data, final AsyncHandler<PostResponse> handler) {
        this.apiService.getResetPINByEmail("identity/v2/auth/pin/reset/securityAnswer/email", QueryMapHelper.getMapPINReset(), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void resetPINByPhoneAndSecurityQuestion(ResetPINByPhoneModel data, final AsyncHandler<PostResponse> handler) {
        this.apiService.getResetPINByPhone("identity/v2/auth/pin/reset/securityAnswer/phone", QueryMapHelper.getMapPINReset(), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void resetPINByUserNameAndSecurityQuestion(ResetPINByUserNameModel data, final AsyncHandler<PostResponse> handler) {
        this.apiService.getResetPINByUserName("identity/v2/auth/pin/reset/securityAnswer/username", QueryMapHelper.getMapPINReset(), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void changePINByAccessToken(String accessToken, ChangePINModel data, final AsyncHandler<PostResponse> handler) {
        this.apiService.getChangePINByAccessToken("identity/v2/auth/pin/change", QueryMapHelper.getMapChangePINByAccessToken(accessToken), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostResponse>(){

            public void onNext(PostResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }
}

