/*
 * Decompiled with CFR 0.152.
 */
package com.liyu.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.liyu.widget.ProgressWheelView;
import com.liyu.widget.R;

public class SuperProgressWheel
extends RelativeLayout {
    private ProgressWheelView pwv;
    private ImageView imageView;
    private RotateAnimation animation;
    private int displayDrawableResId;
    private int displayStyle;
    private float drawablePadding;
    private int rotateDuration;

    public SuperProgressWheel(Context context) {
        this(context, null);
    }

    public SuperProgressWheel(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuperProgressWheel(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.SuperProgressWheel);
        this.displayDrawableResId = mTypedArray.getResourceId(R.styleable.SuperProgressWheel_displayDrawable, R.drawable.ic_fan);
        this.displayStyle = mTypedArray.getInt(R.styleable.SuperProgressWheel_displayStyle, 0);
        this.drawablePadding = mTypedArray.getDimension(R.styleable.SuperProgressWheel_drawablePadding, 0.0f);
        this.rotateDuration = mTypedArray.getInt(R.styleable.SuperProgressWheel_rotateDuration, 1600);
        mTypedArray.recycle();
        this.pwv = new ProgressWheelView(context, attrs, defStyleAttr);
        this.addView(this.pwv, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (this.displayStyle != 2) {
            return;
        }
        this.imageView = new ImageView(context);
        this.imageView.setImageResource(this.displayDrawableResId);
        this.animation = new RotateAnimation(0.0f, 359.0f, 1, 0.5f, 1, 0.5f);
        this.animation.setDuration((long)this.rotateDuration);
        this.animation.setRepeatCount(-1);
        this.animation.setInterpolator((Interpolator)new LinearInterpolator());
        this.imageView.setAnimation((Animation)this.animation);
        this.imageView.setPadding((int)this.drawablePadding, (int)this.drawablePadding, (int)this.drawablePadding, (int)this.drawablePadding);
        this.addView((View)this.imageView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.animation.startNow();
    }

    public void startAnimation() {
        if (this.animation != null) {
            this.animation.startNow();
        }
    }

    public void stopAnimation() {
        if (this.animation != null) {
            this.animation.cancel();
        }
    }

    public int getProgress() {
        return this.pwv.getProgress();
    }

    public void setProgress(int progress) {
        this.pwv.setProgress(progress);
    }

    public int getRoundColor() {
        return this.pwv.getRoundColor();
    }

    public void setRoundColor(int roundColor) {
        this.pwv.setRoundColor(roundColor);
    }

    public int getRoundProgressColor() {
        return this.pwv.getRoundProgressColor();
    }

    public void setRoundProgressColor(int roundProgressColor) {
        this.pwv.setRoundProgressColor(roundProgressColor);
    }

    public int getTextColor() {
        return this.pwv.getTextColor();
    }

    public void setTextColor(int textColor) {
        this.pwv.setTextColor(textColor);
    }

    public float getTextSize() {
        return this.pwv.getTextSize();
    }

    public void setTextSize(float textSize) {
        this.pwv.setTextSize(textSize);
    }

    public float getRoundWidth() {
        return this.pwv.getRoundWidth();
    }

    public void setRoundWidth(float roundWidth) {
        this.pwv.setRoundWidth(roundWidth);
    }

    public int getMaxProgress() {
        return this.pwv.getMaxProgress();
    }

    public void setMaxProgress(int maxProgress) {
        this.pwv.setMaxProgress(maxProgress);
    }

    public int getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(int displayStyle) {
        this.displayStyle = displayStyle;
    }

    public int getRotateDuration() {
        return this.rotateDuration;
    }

    public void setRotateDuration(int rotateDuration) {
        this.rotateDuration = rotateDuration;
    }

    public float getDrawablePadding() {
        return this.drawablePadding;
    }

    public void setDrawablePadding(float drawablePadding) {
        this.drawablePadding = drawablePadding;
    }

    public void setOnProgressListener(ProgressWheelView.onProgressListener mProgressListener) {
        this.pwv.setOnProgressListener(mProgressListener);
    }
}

