/*
 * Decompiled with CFR 0.152.
 */
package com.liyu.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import com.liyu.widget.R;

public class ProgressWheelView
extends View {
    private Paint paint = new Paint();
    private int roundColor;
    private int roundProgressColor;
    private int textColor;
    private float textSize;
    private float roundWidth;
    private int maxProgress;
    private int progress = 0;
    private int displayStyle;
    private static onProgressListener mProgressListener;

    public ProgressWheelView(Context context) {
        this(context, null);
    }

    public ProgressWheelView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressWheelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.SuperProgressWheel);
        this.roundColor = mTypedArray.getColor(R.styleable.SuperProgressWheel_roundColor, -16776961);
        this.roundProgressColor = mTypedArray.getColor(R.styleable.SuperProgressWheel_roundProgressColor, -7829368);
        this.textColor = mTypedArray.getColor(R.styleable.SuperProgressWheel_textColor, -16777216);
        this.textSize = mTypedArray.getDimension(R.styleable.SuperProgressWheel_textSize, 45.0f);
        this.roundWidth = mTypedArray.getDimension(R.styleable.SuperProgressWheel_roundWidth, 35.0f);
        this.maxProgress = mTypedArray.getInteger(R.styleable.SuperProgressWheel_maxProgress, 100);
        this.displayStyle = mTypedArray.getInt(R.styleable.SuperProgressWheel_displayStyle, 0);
        mTypedArray.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int centre = this.getWidth() / 2;
        int radius = (int)((float)centre - this.roundWidth / 2.0f);
        this.paint.setColor(this.roundColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.roundWidth);
        this.paint.setAntiAlias(true);
        RectF oval = new RectF((float)(centre - radius), (float)(centre - radius), (float)(centre + radius), (float)(centre + radius));
        float startAngle = -90.0f;
        float sweepAngle = 360.0f / (float)(2 * this.maxProgress);
        for (int i = 0; i < 100; ++i) {
            canvas.drawArc(oval, startAngle, sweepAngle, false, this.paint);
            startAngle = sweepAngle * 2.0f * (float)(i + 1) - 90.0f;
        }
        this.paint.setColor(this.roundProgressColor);
        float ProgressStartAngle = -90.0f;
        for (int i = 0; i < this.progress; ++i) {
            canvas.drawArc(oval, ProgressStartAngle, sweepAngle, false, this.paint);
            ProgressStartAngle = sweepAngle * 2.0f * (float)(i + 1) - 90.0f;
        }
        switch (this.displayStyle) {
            case 0: {
                break;
            }
            case 1: {
                this.paint.setStrokeWidth(0.0f);
                this.paint.setColor(this.textColor);
                this.paint.setTextSize(this.textSize);
                this.paint.setTypeface(Typeface.DEFAULT_BOLD);
                int percent = (int)((float)this.progress / (float)this.maxProgress * 100.0f);
                float textWidth = this.paint.measureText(percent + "%");
                canvas.drawText(percent + "%", (float)centre - textWidth / 2.0f, (float)centre + this.textSize / 2.0f, this.paint);
            }
        }
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(int progress) {
        if (progress < this.maxProgress) {
            this.progress = progress;
            this.postInvalidate();
        } else {
            this.progress = this.maxProgress;
            this.postInvalidate();
            if (mProgressListener != null) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        mProgressListener.onCompleted(ProgressWheelView.this);
                    }
                });
            }
        }
    }

    public int getRoundColor() {
        return this.roundColor;
    }

    public void setRoundColor(int roundColor) {
        this.roundColor = roundColor;
    }

    public int getRoundProgressColor() {
        return this.roundProgressColor;
    }

    public void setRoundProgressColor(int roundProgressColor) {
        this.roundProgressColor = roundProgressColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public float getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(float roundWidth) {
        this.roundWidth = roundWidth;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public int getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(int displayStyle) {
        this.displayStyle = displayStyle;
    }

    public void setOnProgressListener(onProgressListener mProgressListener) {
        ProgressWheelView.mProgressListener = mProgressListener;
    }

    public static interface onProgressListener {
        public void onCompleted(View var1);
    }
}

