/*
 * Decompiled with CFR 0.152.
 */
package com.liyu.sqlitetoexcel;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.liyu.sqlitetoexcel.SecurityUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SQLiteToExcel {
    private static Handler handler = new Handler(Looper.getMainLooper());
    private String protectKey;
    private String encryptKey;
    private String fileName;
    private String filePath;
    private List<String> tables;
    private String sql;
    private String sheetName;
    private SQLiteDatabase database;
    private Workbook workbook;

    public String start() {
        try {
            if (this.tables == null || this.tables.size() == 0) {
                this.tables = this.getTablesName(this.database);
            }
            return this.exportTables(this.getTablesName(this.database), this.fileName);
        }
        catch (Exception e) {
            if (this.database != null && this.database.isOpen()) {
                this.database.close();
            }
            return null;
        }
    }

    public void start(final ExportListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (SQLiteToExcel.this.tables == null || SQLiteToExcel.this.tables.size() == 0) {
                            SQLiteToExcel.this.tables = SQLiteToExcel.this.getTablesName(SQLiteToExcel.this.database);
                        }
                        final String filePath = SQLiteToExcel.this.exportTables(SQLiteToExcel.this.getTablesName(SQLiteToExcel.this.database), SQLiteToExcel.this.fileName);
                        if (listener != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(filePath);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (SQLiteToExcel.this.database != null && SQLiteToExcel.this.database.isOpen()) {
                            SQLiteToExcel.this.database.close();
                        }
                        if (listener == null) break block5;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onError(e);
                            }
                        });
                    }
                }
            }
        }).start();
    }

    private SQLiteToExcel(List<String> tables, String protectKey, String encryptKey, String fileName, String dataBaseName, String filePath, String sql, String sheetName) {
        this.protectKey = protectKey;
        this.encryptKey = encryptKey;
        this.fileName = fileName;
        this.filePath = filePath;
        this.sql = sql;
        this.sheetName = sheetName;
        try {
            this.database = SQLiteDatabase.openOrCreateDatabase((String)dataBaseName, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String exportTables(List<String> tables, String fileName) throws Exception {
        if (!fileName.toLowerCase().endsWith(".xls")) {
            throw new IllegalArgumentException("File name is null or unsupported file format!");
        }
        this.workbook = new HSSFWorkbook();
        if (TextUtils.isEmpty((CharSequence)this.sql)) {
            for (int i = 0; i < tables.size(); ++i) {
                Sheet sheet = this.workbook.createSheet(tables.get(i));
                String sqlAll = "select * from " + tables.get(i);
                this.fillSheet(sqlAll, sheet);
                if (TextUtils.isEmpty((CharSequence)this.protectKey)) continue;
                sheet.protectSheet(this.protectKey);
            }
        } else {
            Sheet sheet = this.workbook.createSheet(this.sheetName);
            this.fillSheet(this.sql, sheet);
            if (!TextUtils.isEmpty((CharSequence)this.protectKey)) {
                sheet.protectSheet(this.protectKey);
            }
        }
        File file = new File(this.filePath, fileName);
        FileOutputStream fos1 = new FileOutputStream(file);
        this.workbook.write((OutputStream)fos1);
        if (fos1 != null) {
            fos1.flush();
            fos1.close();
        }
        this.workbook.close();
        this.database.close();
        if (!TextUtils.isEmpty((CharSequence)this.encryptKey)) {
            SecurityUtil.EncryptFile(file, this.encryptKey);
        }
        return file.getPath();
    }

    private void fillSheet(String sql, Sheet sheet) {
        Drawing patriarch = sheet.createDrawingPatriarch();
        Cursor cursor = this.database.rawQuery(sql, null);
        cursor.moveToFirst();
        int columnsCount = cursor.getColumnCount();
        Row headerRow = sheet.createRow(0);
        for (int i = 0; i < columnsCount; ++i) {
            Cell cellA = headerRow.createCell(i);
            cellA.setCellValue((RichTextString)new HSSFRichTextString("" + cursor.getColumnNames()[i]));
        }
        int n = 1;
        while (!cursor.isAfterLast()) {
            Row rowA = sheet.createRow(n);
            for (int j = 0; j < columnsCount; ++j) {
                Cell cellA = rowA.createCell(j);
                if (cursor.getType(j) == 4) {
                    HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)j, n, (short)(j + 1), n + 1);
                    anchor.setAnchorType(3);
                    patriarch.createPicture((ClientAnchor)anchor, this.workbook.addPicture(cursor.getBlob(j), 5));
                    continue;
                }
                String value = cursor.getString(j);
                if (!TextUtils.isEmpty((CharSequence)value) && value.length() >= Short.MAX_VALUE) {
                    value = value.substring(0, 32766);
                }
                cellA.setCellValue((RichTextString)new HSSFRichTextString(value));
            }
            ++n;
            cursor.moveToNext();
        }
        cursor.close();
    }

    private List<String> getTablesName(SQLiteDatabase database) {
        ArrayList<String> tables = new ArrayList<String>();
        Cursor cursor = database.rawQuery("select name from sqlite_master where type='table' order by name", null);
        while (cursor.moveToNext()) {
            tables.add(cursor.getString(0));
        }
        cursor.close();
        return tables;
    }

    public static interface ExportListener {
        public void onStart();

        public void onCompleted(String var1);

        public void onError(Exception var1);
    }

    public static class Builder {
        private String dataBaseName;
        private String filePath;
        private String fileName;
        private String protectKey;
        private String encryptKey;
        private List<String> tables;
        private String sql;
        private String sheetName;

        public Builder(Context context) {
            this.filePath = context.getExternalFilesDir(null).getPath();
        }

        public SQLiteToExcel build() {
            if (TextUtils.isEmpty((CharSequence)this.dataBaseName)) {
                throw new IllegalArgumentException("Database name must not be null.");
            }
            if (TextUtils.isEmpty((CharSequence)this.fileName)) {
                throw new IllegalArgumentException("Output file name must not be null.");
            }
            return new SQLiteToExcel(this.tables, this.protectKey, this.encryptKey, this.fileName, this.dataBaseName, this.filePath, this.sql, this.sheetName);
        }

        public Builder setDataBase(String dataBaseName) {
            this.dataBaseName = dataBaseName;
            this.fileName = new File(dataBaseName).getName() + ".xls";
            return this;
        }

        @Deprecated
        public Builder setFileName(String fileName) {
            return this.setOutputFileName(fileName);
        }

        public Builder setOutputFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setProtectKey(String protectPassword) {
            this.protectKey = protectPassword;
            return this;
        }

        public Builder setEncryptKey(String encryptKey) {
            this.encryptKey = encryptKey;
            return this;
        }

        public Builder setTables(String ... tables) {
            this.tables = Arrays.asList(tables);
            return this;
        }

        @Deprecated
        public Builder setPath(String path) {
            return this.setOutputPath(path);
        }

        public Builder setOutputPath(String path) {
            this.filePath = path;
            return this;
        }

        public Builder setSQL(@NonNull String sheetName, @NonNull String sql) {
            this.sql = sql;
            this.sheetName = sheetName;
            return this;
        }

        public Builder setSQL(@NonNull String sql) {
            return this.setSQL("Sheet1", sql);
        }

        public String start() {
            SQLiteToExcel sqliteToExcel = this.build();
            return sqliteToExcel.start();
        }

        public void start(ExportListener listener) {
            SQLiteToExcel sqliteToExcel = this.build();
            sqliteToExcel.start(listener);
        }
    }
}

