/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri;

import java.util.Iterator;
import org.apache.poi.javax.xml.namespace.NamespaceContext;
import org.apache.poi.javax.xml.namespace.QName;
import org.apache.poi.javax.xml.stream.XMLEventReader;
import org.apache.poi.javax.xml.stream.XMLEventWriter;
import org.apache.poi.javax.xml.stream.XMLStreamConstants;
import org.apache.poi.javax.xml.stream.XMLStreamException;
import org.apache.poi.javax.xml.stream.events.Attribute;
import org.apache.poi.javax.xml.stream.events.Characters;
import org.apache.poi.javax.xml.stream.events.Comment;
import org.apache.poi.javax.xml.stream.events.DTD;
import org.apache.poi.javax.xml.stream.events.EntityReference;
import org.apache.poi.javax.xml.stream.events.Namespace;
import org.apache.poi.javax.xml.stream.events.ProcessingInstruction;
import org.apache.poi.javax.xml.stream.events.StartDocument;
import org.apache.poi.javax.xml.stream.events.StartElement;
import org.apache.poi.javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.evt.XMLEvent2;

public class Stax2EventWriterImpl
implements XMLEventWriter,
XMLStreamConstants {
    protected final XMLStreamWriter2 _writer;

    public Stax2EventWriterImpl(XMLStreamWriter2 xMLStreamWriter2) {
        this._writer = xMLStreamWriter2;
    }

    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getEventType()) {
            case 10: {
                Attribute attribute = (Attribute)xMLEvent;
                QName qName = attribute.getName();
                this._writer.writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), attribute.getValue());
                break;
            }
            case 8: {
                this._writer.writeEndDocument();
                break;
            }
            case 2: {
                this._writer.writeEndElement();
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)xMLEvent;
                this._writer.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)xMLEvent;
                if (!startDocument.encodingSet()) {
                    this._writer.writeStartDocument(startDocument.getVersion());
                    break;
                }
                this._writer.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                break;
            }
            case 1: {
                Attribute attribute;
                StartElement startElement = xMLEvent.asStartElement();
                QName qName = startElement.getName();
                this._writer.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
                Iterator iterator = startElement.getNamespaces();
                while (iterator.hasNext()) {
                    attribute = (Namespace)iterator.next();
                    this.add(attribute);
                }
                iterator = startElement.getAttributes();
                while (iterator.hasNext()) {
                    attribute = (Attribute)iterator.next();
                    this.add(attribute);
                }
                break;
            }
            case 4: {
                Characters characters = xMLEvent.asCharacters();
                String string = characters.getData();
                if (characters.isCData()) {
                    this._writer.writeCData(string);
                    break;
                }
                this._writer.writeCharacters(string);
                break;
            }
            case 12: {
                this._writer.writeCData(xMLEvent.asCharacters().getData());
                break;
            }
            case 5: {
                this._writer.writeComment(((Comment)xMLEvent).getText());
                break;
            }
            case 11: {
                this._writer.writeDTD(((DTD)xMLEvent).getDocumentTypeDeclaration());
                break;
            }
            case 9: {
                this._writer.writeEntityRef(((EntityReference)xMLEvent).getName());
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)xMLEvent;
                this._writer.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            default: {
                if (xMLEvent instanceof XMLEvent2) {
                    ((XMLEvent2)xMLEvent).writeUsing(this._writer);
                    break;
                }
                throw new XMLStreamException("Don't know how to output event " + xMLEvent);
            }
        }
    }

    public void add(XMLEventReader xMLEventReader) throws XMLStreamException {
        while (xMLEventReader.hasNext()) {
            this.add(xMLEventReader.nextEvent());
        }
    }

    public void close() throws XMLStreamException {
        this._writer.close();
    }

    public void flush() throws XMLStreamException {
        this._writer.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this._writer.getNamespaceContext();
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this._writer.getPrefix(string);
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this._writer.setDefaultNamespace(string);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this._writer.setNamespaceContext(namespaceContext);
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        this._writer.setPrefix(string, string2);
    }
}

