/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.out.XmlWriter;
import com.fasterxml.aalto.util.XmlCharTypes;
import com.fasterxml.aalto.util.XmlChars;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;

public abstract class ByteXmlWriter
extends XmlWriter {
    static final int DEFAULT_FULL_BUFFER_SIZE = 4000;
    static final int DEFAULT_COPY_BUFFER_SIZE = 1000;
    static final int SMALL_WRITE = 250;
    static final byte BYTE_SPACE = 32;
    static final byte BYTE_COLON = 58;
    static final byte BYTE_SEMICOLON = 59;
    static final byte BYTE_LBRACKET = 91;
    static final byte BYTE_RBRACKET = 93;
    static final byte BYTE_QMARK = 63;
    static final byte BYTE_EQ = 61;
    static final byte BYTE_SLASH = 47;
    static final byte BYTE_HASH = 35;
    static final byte BYTE_HYPHEN = 45;
    static final byte BYTE_LT = 60;
    static final byte BYTE_GT = 62;
    static final byte BYTE_AMP = 38;
    static final byte BYTE_QUOT = 34;
    static final byte BYTE_APOS = 39;
    static final byte BYTE_A = 97;
    static final byte BYTE_G = 103;
    static final byte BYTE_L = 108;
    static final byte BYTE_M = 109;
    static final byte BYTE_O = 111;
    static final byte BYTE_P = 112;
    static final byte BYTE_Q = 113;
    static final byte BYTE_S = 115;
    static final byte BYTE_T = 116;
    static final byte BYTE_U = 117;
    static final byte BYTE_X = 120;
    static final byte[] BYTES_CDATA_START = ByteXmlWriter.getAscii("<![CDATA[");
    static final byte[] BYTES_CDATA_END = ByteXmlWriter.getAscii("]]>");
    static final byte[] BYTES_COMMENT_START = ByteXmlWriter.getAscii("<!--");
    static final byte[] BYTES_COMMENT_END = ByteXmlWriter.getAscii("-->");
    static final byte[] BYTES_XMLDECL_START = ByteXmlWriter.getAscii("<?xml version='");
    static final byte[] BYTES_XMLDECL_ENCODING = ByteXmlWriter.getAscii(" encoding='");
    static final byte[] BYTES_XMLDECL_STANDALONE = ByteXmlWriter.getAscii(" standalone='");
    protected OutputStream _out;
    protected byte[] _outputBuffer;
    protected int _outputPtr;
    protected final int _outputBufferLen;
    protected int _surrogate = 0;
    protected final XmlCharTypes _charTypes;

    protected ByteXmlWriter(WriterConfig cfg, OutputStream out, XmlCharTypes charTypes) {
        super(cfg);
        this._out = out;
        this._outputBuffer = cfg.allocFullBBuffer(4000);
        this._outputBufferLen = this._outputBuffer.length;
        this._outputPtr = 0;
        this._charTypes = charTypes;
    }

    @Override
    protected final int getOutputPtr() {
        return this._outputPtr;
    }

    @Override
    public final WName constructName(String localName) throws XMLStreamException {
        this.verifyNameComponent(localName);
        return this.doConstructName(localName);
    }

    @Override
    public WName constructName(String prefix, String localName) throws XMLStreamException {
        this.verifyNameComponent(prefix);
        this.verifyNameComponent(localName);
        return this.doConstructName(prefix, localName);
    }

    protected abstract WName doConstructName(String var1) throws XMLStreamException;

    protected abstract WName doConstructName(String var1, String var2) throws XMLStreamException;

    protected void verifyNameComponent(String part) throws XMLStreamException {
        int lastValid;
        int i;
        if (part == null || part.length() == 0) {
            this.reportNwfName(ErrorConsts.WERR_NAME_EMPTY);
        }
        int ch = part.charAt(0);
        int len = part.length();
        if (ch >= 55296 && ch <= 57343) {
            if (ch >= 56320) {
                this.reportNwfName("Illegal surrogate pairing in name: first character (" + XmlChars.getCharDesc(ch) + ") not valid surrogate first character");
            }
            if (len < 2) {
                this.reportNwfName("Illegal surrogate pairing in name: incomplete surrogate (missing second half)");
            }
            ch = this.calcSurrogate(ch, part.charAt(1), " in name");
            i = 2;
        } else {
            i = 1;
        }
        if (!XmlChars.is10NameStartChar(ch)) {
            this.reportNwfName("Invalid name start character " + XmlChars.getCharDesc(ch) + " (name \"" + part + "\")");
        }
        if (ch > (lastValid = this.getHighestEncodable())) {
            this.reportNwfName("Illegal name start character " + XmlChars.getCharDesc(ch) + " (name \"" + part + "\"): can not be expressed using effective encoding (" + this._config.getActualEncoding() + ")");
        }
        while (i < len) {
            ch = part.charAt(i);
            if (ch >= 55296 && ch <= 57343) {
                if (ch >= 56320) {
                    this.reportNwfName("Illegal surrogate pairing in name: character at #" + i + " (" + XmlChars.getCharDesc(ch) + ") not valid surrogate first character");
                }
                if (++i >= len) {
                    this.reportNwfName("Illegal surrogate pairing in name: name ends with incomplete surrogate pair");
                }
                ch = this.calcSurrogate(ch, part.charAt(i), " in name");
            }
            if (ch > lastValid) {
                this.reportNwfName("Illegal name character " + XmlChars.getCharDesc(ch) + " (name \"" + part + "\", index #" + i + "): can not be expressed using effective encoding (" + this._config.getActualEncoding() + ")");
            }
            if (!XmlChars.is10NameChar(ch)) {
                this.reportNwfName("Invalid name character " + XmlChars.getCharDesc(ch) + ") in name (\"" + part + "\"), index #" + i);
            }
            ++i;
        }
    }

    protected abstract void outputSurrogates(int var1, int var2) throws IOException, XMLStreamException;

    protected abstract void output2ByteChar(int var1) throws IOException, XMLStreamException;

    protected abstract int outputStrictMultiByteChar(int var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    protected abstract int outputMultiByteChar(int var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    @Override
    public void _releaseBuffers() {
        super._releaseBuffers();
        if (this._outputBuffer != null) {
            this._config.freeFullBBuffer(this._outputBuffer);
            this._outputBuffer = null;
        }
        if (this._copyBuffer != null) {
            this._config.freeFullCBuffer(this._copyBuffer);
            this._copyBuffer = null;
        }
    }

    @Override
    public void _closeTarget(boolean doClose) throws IOException {
        if (this._out != null && doClose) {
            this._out.close();
            this._out = null;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this._out != null) {
            this.flushBuffer();
            this._out.flush();
        }
    }

    @Override
    public final void writeRaw(String text, int offset, int len) throws IOException, XMLStreamException {
        while (len > 0) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            int len2 = len < blen ? len : blen;
            text.getChars(offset, offset + len2, buf, 0);
            this.writeRaw(buf, 0, len2);
            offset += len2;
            len -= len2;
        }
    }

    @Override
    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    @Override
    public final void writeStartTagStart(WName name) throws IOException, XMLStreamException {
        int ptr;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((ptr = this._outputPtr) + name.serializedLength() + 1 > this._outputBufferLen) {
            this.writeName((byte)60, name);
            return;
        }
        byte[] bbuf = this._outputBuffer;
        bbuf[ptr++] = 60;
        ptr += name.appendBytes(bbuf, ptr);
        this._outputPtr = ptr;
    }

    @Override
    public final void writeStartTagEnd() throws IOException, XMLStreamException {
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = 62;
    }

    @Override
    public void writeStartTagEmptyEnd() throws IOException {
        int ptr = this._outputPtr;
        if (ptr + 2 > this._outputBufferLen) {
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        byte[] bbuf = this._outputBuffer;
        bbuf[ptr++] = 47;
        bbuf[ptr++] = 62;
        this._outputPtr = ptr;
    }

    @Override
    public final void writeEndTag(WName name) throws IOException, XMLStreamException {
        int len;
        int ptr;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((ptr = this._outputPtr) + (len = name.serializedLength()) + 3 > this._outputBufferLen) {
            this.flushBuffer();
            if (len + 3 > this._outputBufferLen) {
                this._out.write(60);
                this._out.write(47);
                name.writeBytes(this._out);
                this._outputBuffer[this._outputPtr++] = 62;
                return;
            }
            ptr = this._outputPtr;
        }
        byte[] bbuf = this._outputBuffer;
        bbuf[ptr++] = 60;
        bbuf[ptr++] = 47;
        ptr += name.appendBytes(bbuf, ptr);
        bbuf[ptr++] = 62;
        this._outputPtr = ptr;
    }

    @Override
    public final void writeAttribute(WName name, String value) throws IOException, XMLStreamException {
        int vlen = value.length();
        if (vlen > this._copyBufferLen) {
            this.writeLongAttribute(name, value, vlen);
            return;
        }
        char[] cbuf = this._copyBuffer;
        if (vlen > 0) {
            value.getChars(0, vlen, cbuf, 0);
        }
        this.writeAttribute(name, cbuf, 0, vlen);
    }

    @Override
    public final void writeAttribute(WName name, char[] vbuf, int offset, int vlen) throws IOException, XMLStreamException {
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int ptr = this._outputPtr;
        byte[] bbuf = this._outputBuffer;
        if (ptr + name.serializedLength() >= this._outputBufferLen) {
            this.writeName((byte)32, name);
            ptr = this._outputPtr;
        } else {
            bbuf[ptr++] = 32;
            ptr += name.appendBytes(bbuf, ptr);
        }
        if (ptr + 3 + vlen > this._outputBufferLen) {
            this._outputPtr = ptr;
            this.flushBuffer();
            bbuf[this._outputPtr++] = 61;
            bbuf[this._outputPtr++] = 34;
            if (this._outputPtr + vlen + 1 > this._outputBufferLen) {
                this.writeAttrValue(vbuf, offset, vlen);
                this.writeRaw((byte)34);
                return;
            }
            ptr = this._outputPtr;
        } else {
            bbuf[ptr++] = 61;
            bbuf[ptr++] = 34;
        }
        if (vlen > 0) {
            ptr = this.fastWriteAttrValue(vbuf, offset, vlen, bbuf, ptr);
        }
        bbuf[ptr++] = 34;
        this._outputPtr = ptr;
    }

    protected final int fastWriteAttrValue(char[] vbuf, int offset, int len, byte[] bbuf, int ptr) throws IOException, XMLStreamException {
        len += offset;
        block4: while (offset < len) {
            char ch;
            int[] charTypes = this._charTypes.ATTR_CHARS;
            while ((ch = vbuf[offset]) < '\u0800' && charTypes[ch] == 0) {
                bbuf[ptr++] = (byte)ch;
                if (++offset < len) continue;
                break block4;
            }
            this._outputPtr = ptr;
            if ((ch = vbuf[offset++]) < '\u0800') {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                        break;
                    }
                    case 5: {
                        this.output2ByteChar(ch);
                        break;
                    }
                    default: {
                        this.writeAsEntity(ch);
                        break;
                    }
                }
            } else {
                offset = this.outputMultiByteChar(ch, vbuf, offset, len);
            }
            if (len - offset >= this._outputBufferLen - this._outputPtr) {
                this.flushBuffer();
            }
            ptr = this._outputPtr;
        }
        return ptr;
    }

    protected final void writeAttrValue(char[] vbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._surrogate != 0) {
            this.outputSurrogates(this._surrogate, vbuf[offset]);
            ++offset;
            --len;
        }
        len += offset;
        block4: while (offset < len) {
            char ch;
            int[] charTypes = this._charTypes.ATTR_CHARS;
            while ((ch = vbuf[offset]) < '\u0800' && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)ch;
                if (++offset < len) continue;
                break block4;
            }
            if ((ch = vbuf[offset++]) < '\u0800') {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 5: {
                        this.output2ByteChar(ch);
                        continue block4;
                    }
                }
                this.writeAsEntity(ch);
                continue;
            }
            offset = this.outputMultiByteChar(ch, vbuf, offset, len);
        }
    }

    protected final void writeLongAttribute(WName name, String value, int vlen) throws IOException, XMLStreamException {
        this.writeRaw((byte)32);
        int nlen = name.serializedLength();
        if (this._outputPtr + nlen > this._outputBufferLen) {
            this.flushBuffer();
            if (nlen > this._outputBufferLen) {
                name.writeBytes(this._out);
            } else {
                this._outputPtr += name.appendBytes(this._outputBuffer, this._outputPtr);
            }
        } else {
            this._outputPtr += name.appendBytes(this._outputBuffer, this._outputPtr);
        }
        this.writeRaw((byte)61, (byte)34);
        int offset = 0;
        while (vlen > 0) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            int len2 = vlen < blen ? vlen : blen;
            value.getChars(offset, offset + len2, buf, 0);
            this.writeAttrValue(buf, 0, len2);
            offset += len2;
            vlen -= len2;
        }
        this.writeRaw((byte)34);
    }

    protected final void writeName(WName name) throws IOException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len > this._outputBufferLen) {
            this.flushBuffer();
            if (len >= this._outputBufferLen) {
                name.writeBytes(this._out);
                return;
            }
            ptr = this._outputPtr;
        }
        ptr += name.appendBytes(this._outputBuffer, ptr);
        this._outputPtr = ptr;
    }

    protected final void writeName(byte preChar, WName name) throws IOException {
        this.flushBuffer();
        int len = name.serializedLength();
        if (len >= this._outputBufferLen) {
            this._out.write(preChar);
            name.writeBytes(this._out);
            return;
        }
        int ptr = this._outputPtr;
        byte[] buf = this._outputBuffer;
        buf[ptr++] = preChar;
        ptr += name.appendBytes(buf, ptr);
        this._outputPtr = ptr;
    }

    protected final void writeName(WName name, byte postChar) throws IOException {
        this.flushBuffer();
        if (name.serializedLength() >= this._outputBufferLen) {
            name.writeBytes(this._out);
            this._out.write(postChar);
            return;
        }
        int ptr = this._outputPtr;
        byte[] buf = this._outputBuffer;
        ptr += name.appendBytes(buf, ptr);
        buf[ptr++] = postChar;
        this._outputPtr = ptr;
    }

    private final void writeAttrNameEqQ(WName name) throws IOException, XMLStreamException {
        int nlen;
        int ptr;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((ptr = this._outputPtr) + (nlen = name.serializedLength()) + 3 >= this._outputBufferLen) {
            this.flushBuffer();
            ptr = this._outputPtr;
            if (ptr + nlen + 3 >= this._outputBufferLen) {
                this.writeName((byte)32, name);
                this.writeRaw((byte)61);
                this.writeRaw((byte)34);
                return;
            }
        }
        byte[] bbuf = this._outputBuffer;
        bbuf[ptr++] = 32;
        ptr += name.appendBytes(bbuf, ptr);
        bbuf[ptr++] = 61;
        bbuf[ptr++] = 34;
        this._outputPtr = ptr;
    }

    @Override
    public int writeCData(String data) throws IOException, XMLStreamException {
        int blen;
        this.writeCDataStart();
        int offset = 0;
        for (int len = data.length(); len > 0; len -= blen) {
            char[] buf = this._copyBuffer;
            blen = buf.length;
            if (blen > len) {
                blen = len;
            }
            data.getChars(offset, offset + blen, buf, 0);
            int cix = this.writeCDataContents(buf, 0, blen);
            if (cix >= 0) {
                return offset + cix;
            }
            offset += blen;
        }
        this.writeCDataEnd();
        return -1;
    }

    @Override
    public int writeCData(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        this.writeCDataStart();
        int ix = this.writeCDataContents(cbuf, offset, len);
        if (ix < 0) {
            this.writeCDataEnd();
        }
        return ix;
    }

    protected int writeCDataContents(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block7: while (offset < len) {
            char ch;
            int[] charTypes = this._charTypes.OTHER_CHARS;
            while ((ch = cbuf[offset]) < '\u0800' && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)ch;
                if (++offset < len) continue;
                break block7;
            }
            if ((ch = cbuf[offset++]) < '\u0800') {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        ++this._locRowNr;
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("CDATA", ch);
                    }
                    case 5: {
                        this.output2ByteChar(ch);
                        continue block7;
                    }
                    case 11: {
                        if (offset >= len || cbuf[offset] != ']') break;
                        if (offset + 1 >= len || cbuf[offset + 1] != '>') continue block7;
                        offset += 2;
                        this.writeRaw((byte)93, (byte)93);
                        this.writeCDataEnd();
                        this.writeCDataStart();
                        this.writeRaw((byte)62);
                        continue block7;
                    }
                }
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)ch;
                continue;
            }
            offset = this.outputMultiByteChar(ch, cbuf, offset, len);
        }
        return -1;
    }

    @Override
    public final void writeCharacters(String text) throws IOException, XMLStreamException {
        int len = text.length();
        if (len > this._copyBufferLen) {
            this.longWriteCharacters(text);
            return;
        }
        if (len > 0) {
            char[] buf = this._copyBuffer;
            text.getChars(0, len, buf, 0);
            this.writeCharacters(buf, 0, len);
        }
    }

    private final void longWriteCharacters(String text) throws IOException, XMLStreamException {
        int len2;
        int offset = 0;
        int len = text.length();
        char[] buf = this._copyBuffer;
        do {
            int blen;
            len2 = len < (blen = buf.length) ? len : blen;
            text.getChars(offset, offset + len2, buf, 0);
            this.writeCharacters(buf, 0, len2);
            offset += len2;
        } while ((len -= len2) > 0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void writeCharacters(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._surrogate != 0) {
            this.outputSurrogates(this._surrogate, cbuf[offset]);
            ++offset;
            --len;
        }
        if ((ptr = this._outputPtr) + len > this._outputBufferLen) {
            this.writeSplitCharacters(cbuf, offset, len);
            return;
        }
        len += offset;
        block8: while (offset < len) {
            block15: {
                block14: {
                    charTypes = this._charTypes.TEXT_CHARS;
                    while ((ch = cbuf[offset]) < '\u0800') {
                        if (charTypes[ch] != 0) {
                            if (ch != '\n') break;
                            ++this._locRowNr;
                        }
                        this._outputBuffer[ptr++] = (byte)ch;
                        if (++offset < len) continue;
                        break block8;
                    }
                    if ((ch = cbuf[offset++]) >= '\u0800') break block14;
                    switch (charTypes[ch]) {
                        case 1: {
                            this.reportInvalidChar(ch);
                        }
                        case 2: {
                            if (!this._config.willEscapeCR()) ** GOTO lbl26
                            this._outputPtr = ptr;
                            break block15;
lbl26:
                            // 1 sources

                            this._outputBuffer[ptr++] = (byte)ch;
                            ++this._locRowNr;
                            break;
                        }
                        case 3: {
                            break block15;
                        }
                        case 4: 
                        case 9: 
                        case 10: {
                            this._outputPtr = ptr;
                            this.writeAsEntity(ch);
                            break block15;
                        }
                        case 5: {
                            this._outputPtr = ptr;
                            this.output2ByteChar(ch);
                            break block15;
                        }
                        case 11: {
                            if (offset < len && cbuf[offset] != '>') ** GOTO lbl44
                            this._outputPtr = ptr;
                            this.writeAsEntity(ch);
                            break block15;
                        }
lbl44:
                        // 2 sources

                        default: {
                            this._outputBuffer[ptr++] = (byte)ch;
                            break;
                        }
                    }
                    continue;
                }
                this._outputPtr = ptr;
                offset = this.outputMultiByteChar(ch, cbuf, offset, len);
            }
            if (len - offset >= this._outputBufferLen - this._outputPtr) {
                this.flushBuffer();
            }
            ptr = this._outputPtr;
        }
        this._outputPtr = ptr;
    }

    private final void writeSplitCharacters(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block8: while (offset < len) {
            char ch;
            block16: {
                block15: {
                    int[] charTypes = this._charTypes.TEXT_CHARS;
                    while ((ch = cbuf[offset]) < '\u0800') {
                        if (charTypes[ch] != 0) {
                            if (ch != '\n') break;
                            ++this._locRowNr;
                        }
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = (byte)ch;
                        if (++offset < len) continue;
                        break block8;
                    }
                    if ((ch = cbuf[offset++]) >= '\u0800') break block15;
                    switch (charTypes[ch]) {
                        case 1: {
                            this.reportInvalidChar(ch);
                        }
                        case 2: {
                            if (this._config.willEscapeCR()) {
                                this.writeAsEntity(ch);
                                continue block8;
                            }
                            ++this._locRowNr;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: 
                        case 9: 
                        case 10: {
                            this.writeAsEntity(ch);
                            continue block8;
                        }
                        case 5: {
                            this.output2ByteChar(ch);
                            continue block8;
                        }
                        case 11: {
                            if (offset >= len || cbuf[offset] == '>') {
                                this.writeAsEntity(ch);
                                continue block8;
                            } else {
                                break;
                            }
                        }
                    }
                    break block16;
                }
                this.writeAsEntity(ch);
                continue;
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)ch;
        }
    }

    @Override
    public void writeTypedValue(AsciiValueEncoder enc) throws IOException, XMLStreamException {
        int free;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (enc.bufferNeedsFlush(free = this._outputBufferLen - this._outputPtr)) {
            this.flush();
        }
        while (true) {
            this._outputPtr = enc.encodeMore(this._outputBuffer, this._outputPtr, this._outputBufferLen);
            if (enc.isCompleted()) break;
            this.flushBuffer();
        }
    }

    @Override
    public final void writeAttribute(WName name, AsciiValueEncoder enc) throws IOException, XMLStreamException {
        this.writeAttrNameEqQ(name);
        int free = this._outputBufferLen - this._outputPtr;
        if (enc.bufferNeedsFlush(free)) {
            this.flush();
        }
        while (true) {
            this._outputPtr = enc.encodeMore(this._outputBuffer, this._outputPtr, this._outputBufferLen);
            if (enc.isCompleted()) break;
            this.flushBuffer();
        }
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = 34;
    }

    @Override
    public int writeComment(String data) throws IOException, XMLStreamException {
        int blen;
        this.writeCommentStart();
        int offset = 0;
        for (int len = data.length(); len > 0; len -= blen) {
            char[] buf = this._copyBuffer;
            blen = buf.length;
            int len2 = len < blen ? len : blen;
            data.getChars(offset, offset + len2, buf, 0);
            int cix = this.writeCommentContents(buf, 0, len2);
            if (cix >= 0) {
                return offset + cix;
            }
            offset += blen;
        }
        this.writeCommentEnd();
        return -1;
    }

    protected int writeCommentContents(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block7: while (offset < len) {
            char ch;
            int[] charTypes = this._charTypes.OTHER_CHARS;
            while ((ch = cbuf[offset]) < '\u0800' && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)ch;
                if (++offset < len) continue;
                break block7;
            }
            if ((ch = cbuf[offset++]) < '\u0800') {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        ++this._locRowNr;
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("comment", ch);
                    }
                    case 5: {
                        this.output2ByteChar(ch);
                        continue block7;
                    }
                    case 13: {
                        if (offset < len && cbuf[offset] != '-') break;
                        this.writeRaw((byte)45, (byte)32);
                        continue block7;
                    }
                }
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)ch;
                continue;
            }
            offset = this.outputMultiByteChar(ch, cbuf, offset, len);
        }
        return -1;
    }

    @Override
    public void writeDTD(String data) throws IOException, XMLStreamException {
        this.writeRaw(data, 0, data.length());
    }

    @Override
    public void writeDTD(WName rootName, String systemId, String publicId, String internalSubset) throws IOException, XMLStreamException {
    }

    protected int writePIData(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block7: while (offset < len) {
            char ch;
            int[] charTypes = this._charTypes.OTHER_CHARS;
            while ((ch = cbuf[offset]) < '\u0800' && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)ch;
                if (++offset < len) continue;
                break block7;
            }
            if ((ch = cbuf[offset++]) < '\u0800') {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        ++this._locRowNr;
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("processing instruction", ch);
                    }
                    case 5: {
                        this.output2ByteChar(ch);
                        continue block7;
                    }
                    case 12: {
                        if (offset >= len || cbuf[offset] != '>') break;
                        return offset;
                    }
                }
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)ch;
                continue;
            }
            offset = this.outputMultiByteChar(ch, cbuf, offset, len);
        }
        return -1;
    }

    @Override
    public void writeEntityReference(WName name) throws IOException, XMLStreamException {
        this.writeRaw((byte)38);
        this.writeName(name);
        this.writeRaw((byte)59);
    }

    @Override
    public int writePI(WName target, String data) throws IOException, XMLStreamException {
        this.writeRaw((byte)60, (byte)63);
        this.writeName(target);
        if (data != null) {
            int blen;
            this.writeRaw((byte)32);
            int offset = 0;
            for (int len = data.length(); len > 0; len -= blen) {
                char[] buf = this._copyBuffer;
                blen = buf.length;
                if (blen > len) {
                    blen = len;
                }
                data.getChars(offset, offset + blen, buf, 0);
                int cix = this.writePIData(buf, 0, blen);
                if (cix >= 0) {
                    return offset + cix;
                }
                offset += blen;
            }
        }
        this.writeRaw((byte)63, (byte)62);
        return -1;
    }

    @Override
    public final void writeSpace(String data) throws IOException, XMLStreamException {
        int len2;
        int offset = 0;
        for (int len = data.length(); len > 0; len -= len2) {
            char[] buf = this._copyBuffer;
            int blen = buf.length;
            len2 = len < blen ? len : blen;
            data.getChars(offset, offset + len2, buf, 0);
            this.writeSpace(buf, 0, len2);
            offset += len2;
        }
    }

    @Override
    public void writeSpace(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        if (this._surrogate != 0) {
            this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, this._surrogate, offset - 1);
        }
        len += offset;
        while (offset < len) {
            char ch;
            if ((ch = cbuf[offset++]) > ' ' && (!this._config.isXml11() || ch != '\u0085' && ch != '\u2028')) {
                this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, ch, offset - 1);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)ch;
        }
    }

    @Override
    public void writeXmlDeclaration(String version, String encoding, String standalone) throws IOException, XMLStreamException {
        this.writeRaw(BYTES_XMLDECL_START);
        this.writeRaw(version, 0, version.length());
        this.writeRaw((byte)39);
        if (encoding != null && encoding.length() > 0) {
            this.writeRaw(BYTES_XMLDECL_ENCODING);
            this.writeRaw(encoding, 0, encoding.length());
            this.writeRaw((byte)39);
        }
        if (standalone != null) {
            this.writeRaw(BYTES_XMLDECL_STANDALONE);
            this.writeRaw(standalone, 0, standalone.length());
            this.writeRaw((byte)39);
        }
        this.writeRaw((byte)63, (byte)62);
    }

    protected final void writeCDataStart() throws IOException {
        this.writeRaw(BYTES_CDATA_START);
    }

    protected final void writeCDataEnd() throws IOException {
        this.writeRaw(BYTES_CDATA_END);
    }

    protected final void writeCommentStart() throws IOException {
        this.writeRaw(BYTES_COMMENT_START);
    }

    protected final void writeCommentEnd() throws IOException {
        this.writeRaw(BYTES_COMMENT_END);
    }

    protected final void writeRaw(byte b) throws IOException {
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = b;
    }

    protected final void writeRaw(byte b1, byte b2) throws IOException {
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this._outputPtr + 1 >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = b1;
        this._outputBuffer[this._outputPtr++] = b2;
    }

    protected final void writeRaw(byte[] buf) throws IOException {
        this.writeRaw(buf, 0, buf.length);
    }

    protected final void writeRaw(byte[] buf, int offset, int len) throws IOException {
        int ptr;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((ptr = this._outputPtr) + len <= this._outputBufferLen) {
            System.arraycopy(buf, offset, this._outputBuffer, ptr, len);
            this._outputPtr += len;
            return;
        }
        if (ptr > 0) {
            this.flush();
            ptr = this._outputPtr;
        }
        if (len < 250) {
            System.arraycopy(buf, offset, this._outputBuffer, ptr, len);
            this._outputPtr += len;
        } else {
            this._out.write(buf, offset, len);
        }
    }

    protected final void throwUnpairedSurrogate() throws IOException {
        int surr = this._surrogate;
        this._surrogate = 0;
        this.throwUnpairedSurrogate(surr);
    }

    protected final void throwUnpairedSurrogate(int code) throws IOException {
        this.flush();
        throw new IOException("Unpaired surrogate character (0x" + Integer.toHexString(code) + ")");
    }

    protected final void flushBuffer() throws IOException {
        if (this._outputPtr > 0 && this._out != null) {
            int ptr = this._outputPtr;
            this._locPastChars += ptr;
            this._locRowStartOffset -= ptr;
            this._outputPtr = 0;
            this._out.write(this._outputBuffer, 0, ptr);
        }
    }

    protected final void writeAsEntity(int c) throws IOException {
        int ptr = this._outputPtr;
        byte[] buf = this._outputBuffer;
        if (ptr + 10 >= buf.length) {
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        buf[ptr++] = 38;
        if (c < 256) {
            if (c == 38) {
                buf[ptr++] = 97;
                buf[ptr++] = 109;
                buf[ptr++] = 112;
            } else if (c == 60) {
                buf[ptr++] = 108;
                buf[ptr++] = 116;
            } else if (c == 62) {
                buf[ptr++] = 103;
                buf[ptr++] = 116;
            } else if (c == 39) {
                buf[ptr++] = 97;
                buf[ptr++] = 112;
                buf[ptr++] = 111;
                buf[ptr++] = 115;
            } else if (c == 34) {
                buf[ptr++] = 113;
                buf[ptr++] = 117;
                buf[ptr++] = 111;
                buf[ptr++] = 116;
            } else {
                buf[ptr++] = 35;
                buf[ptr++] = 120;
                if (c >= 16) {
                    int digit = c >> 4;
                    buf[ptr++] = (byte)(digit < 10 ? 48 + digit : 87 + digit);
                    c &= 0xF;
                }
                buf[ptr++] = (byte)(c < 10 ? 48 + c : 87 + c);
            }
        } else {
            buf[ptr++] = 35;
            buf[ptr++] = 120;
            int shift = 20;
            int origPtr = ptr;
            do {
                int digit;
                if ((digit = c >> shift & 0xF) <= 0 && ptr == origPtr) continue;
                buf[ptr++] = (byte)(digit < 10 ? 48 + digit : 87 + digit);
            } while ((shift -= 4) > 0);
            buf[ptr++] = (byte)((c &= 0xF) < 10 ? 48 + c : 87 + c);
        }
        buf[ptr++] = 59;
        this._outputPtr = ptr;
    }

    protected final int calcSurrogate(int surr1, int surr2, String context) throws XMLStreamException {
        int c;
        if (surr2 < 56320 || surr2 > 57343) {
            String msg = "Incomplete surrogate pair" + context + ": first char 0x" + Integer.toHexString(surr1) + ", second 0x" + Integer.toHexString(surr2);
            this.reportNwfContent(msg);
        }
        if ((c = 65536 + (surr1 - 55296 << 10) + (surr2 - 56320)) > 0x10FFFF) {
            this.reportInvalidChar(c);
        }
        return c;
    }

    protected static final byte[] getAscii(String str) {
        int len = str.length();
        byte[] result = new byte[len];
        ByteXmlWriter.getAscii(str, result, 0);
        return result;
    }

    protected static final void getAscii(String str, byte[] result) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            result[i] = (byte)str.charAt(i);
        }
    }

    protected static final void getAscii(String str, byte[] result, int offset) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            result[offset + i] = (byte)str.charAt(i);
        }
    }
}

