/*
 * Decompiled with CFR 0.152.
 */
package com.android.liuzhuang.rcimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.liuzhuang.rcimageview.R;

public class RoundCornerImageView
extends ImageView {
    private float radius = 0.0f;

    public RoundCornerImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public RoundCornerImageView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.init(context, attrs);
    }

    public RoundCornerImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RoundCornerImageView);
        this.radius = typedArray.getDimensionPixelSize(R.styleable.RoundCornerImageView_rciv_radius, 0);
        typedArray.recycle();
    }

    public void draw(Canvas canvas) {
        if (this.isInEditMode()) {
            super.draw(canvas);
            return;
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        Bitmap bitmap = null;
        Drawable drawable = this.getDrawable();
        if (drawable != null) {
            bitmap = RoundCornerImageView.drawableToBitmap(drawable);
        }
        if (bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0) {
            BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            float scale = Math.max((float)this.getWidth() * 1.0f / (float)bitmap.getWidth(), (float)this.getHeight() * 1.0f / (float)bitmap.getHeight());
            Matrix matrix = new Matrix();
            matrix.setScale(scale, scale);
            shader.setLocalMatrix(matrix);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setShader((Shader)shader);
            RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
            canvas.drawRoundRect(rect, this.radius, this.radius, paint);
        } else {
            super.draw(canvas);
        }
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap;
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int width = Math.max(drawable.getIntrinsicWidth(), 2);
        int height = Math.max(drawable.getIntrinsicHeight(), 2);
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }
}

