/*
 * Decompiled with CFR 0.152.
 */
package com.liuzhuang.afgridlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.liuzhuang.afgridlayout.R;
import java.util.ArrayList;

public class AutoFitGridLayout
extends ViewGroup {
    private int verticalSpace;
    private int horizontalSpace;
    private int columnCount;
    private int childWidth;
    private ArrayList<View> notGoneViewList;

    public AutoFitGridLayout(Context context) {
        super(context);
    }

    public AutoFitGridLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AutoFitGridLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoFitGridLayout);
        this.columnCount = a.getInt(R.styleable.AutoFitGridLayout_columnCount, 1);
        this.horizontalSpace = a.getDimensionPixelSize(R.styleable.AutoFitGridLayout_horizontalSpace, 0);
        this.verticalSpace = a.getDimensionPixelSize(R.styleable.AutoFitGridLayout_verticalSpace, 0);
        a.recycle();
    }

    private void refreshNotGoneChildList() {
        if (this.notGoneViewList == null) {
            this.notGoneViewList = new ArrayList();
        }
        this.notGoneViewList.clear();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.notGoneViewList.add(child);
        }
    }

    public int getVerticalSpace() {
        return this.verticalSpace;
    }

    public void setVerticalSpace(int verticalSpace) {
        this.verticalSpace = verticalSpace;
        this.requestLayout();
    }

    public int getHorizontalSpace() {
        return this.horizontalSpace;
    }

    public void setHorizontalSpace(int horizontalSpace) {
        this.horizontalSpace = horizontalSpace;
        this.requestLayout();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount;
        this.refreshNotGoneChildList();
        if (this.childWidth <= 0) {
            int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            this.childWidth = (int)(((float)parentWidth - (float)((this.columnCount - 1) * this.horizontalSpace) * 1.0f) / (float)this.columnCount + 0.5f);
        }
        int line = (childCount = this.notGoneViewList.size()) % this.columnCount == 0 ? childCount / this.columnCount : childCount / this.columnCount + 1;
        int totalHeight = 0;
        int childIndex = 0;
        for (int i = 0; i < line; ++i) {
            int inlineHeight = 0;
            for (int j = 0; j < this.columnCount; ++j) {
                childIndex = i * this.columnCount + j;
                if (childIndex >= childCount) continue;
                View child = this.notGoneViewList.get(childIndex);
                int childWidthWithPadding = this.childWidth;
                if (j == 0) {
                    childWidthWithPadding += this.getPaddingRight();
                } else if (j == this.columnCount - 1) {
                    childWidthWithPadding += this.getPaddingLeft();
                }
                this.measureChild(child, View.MeasureSpec.makeMeasureSpec((int)childWidthWithPadding, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                int totalInlineChildHeight = child.getMeasuredHeight();
                if (totalInlineChildHeight <= inlineHeight) continue;
                inlineHeight = totalInlineChildHeight;
            }
            totalHeight += inlineHeight;
            totalHeight += this.verticalSpace;
        }
        totalHeight -= this.verticalSpace;
        this.setMeasuredDimension(AutoFitGridLayout.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), totalHeight += this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.notGoneViewList.size();
        int line = childCount % this.columnCount == 0 ? childCount / this.columnCount : childCount / this.columnCount + 1;
        int childIndex = 0;
        int lastLeft = this.getPaddingLeft();
        int lastTop = this.getPaddingTop();
        for (int i = 0; i < line; ++i) {
            int inlineHeight = 0;
            for (int j = 0; j < this.columnCount; ++j) {
                childIndex = i * this.columnCount + j;
                if (childIndex >= childCount) continue;
                View child = this.notGoneViewList.get(childIndex);
                int childWidth = child.getMeasuredWidth();
                int childHeight = child.getMeasuredHeight();
                child.layout(lastLeft, lastTop, lastLeft + childWidth, lastTop + childHeight);
                lastLeft += childWidth + this.horizontalSpace;
                int totalInlineChildHeight = child.getMeasuredHeight();
                if (totalInlineChildHeight <= inlineHeight) continue;
                inlineHeight = totalInlineChildHeight;
            }
            lastLeft = this.getPaddingLeft();
            lastTop += inlineHeight + this.verticalSpace;
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
        }
    }
}

