/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.spring;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="centraldogma")
@Validated
public class CentralDogmaSettings {
    private @Nullable String profile;
    private @Nullable List<String> hosts;
    private @Nullable String accessToken;
    private @Nullable Long healthCheckIntervalMillis;
    private @Nullable Boolean useTls;
    private @Nullable Integer maxNumRetriesOnReplicationLag;
    private @Nullable Long retryIntervalOnReplicationLagMillis;
    private @Nullable Long initializationTimeoutMillis;

    public @Nullable String getProfile() {
        return this.profile;
    }

    public void setProfile(@NotBlank String profile) {
        this.profile = profile;
    }

    public @Nullable List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(@NotEmpty List<String> hosts) {
        this.hosts = new ArrayList<String>(hosts);
    }

    public @Nullable String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(@NotBlank String accessToken) {
        this.accessToken = accessToken;
    }

    public @Nullable Long getHealthCheckIntervalMillis() {
        return this.healthCheckIntervalMillis;
    }

    public void setHealthCheckIntervalMillis(@PositiveOrZero long healthCheckIntervalMillis) {
        this.healthCheckIntervalMillis = healthCheckIntervalMillis;
    }

    public @Nullable Boolean getUseTls() {
        return this.useTls;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public @Nullable Integer getMaxNumRetriesOnReplicationLag() {
        return this.maxNumRetriesOnReplicationLag;
    }

    public void setMaxNumRetriesOnReplicationLag(@Nullable Integer maxNumRetriesOnReplicationLag) {
        this.maxNumRetriesOnReplicationLag = maxNumRetriesOnReplicationLag;
    }

    public @Nullable Long getRetryIntervalOnReplicationLagMillis() {
        return this.retryIntervalOnReplicationLagMillis;
    }

    public void setRetryIntervalOnReplicationLagMillis(@Nullable Long retryIntervalOnReplicationLagMillis) {
        this.retryIntervalOnReplicationLagMillis = retryIntervalOnReplicationLagMillis;
    }

    public @Nullable Long getInitializationTimeoutMillis() {
        return this.initializationTimeoutMillis;
    }

    public void setInitializationTimeoutMillis(@Nullable Long initializationTimeoutMillis) {
        this.initializationTimeoutMillis = initializationTimeoutMillis;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("profile", (Object)this.profile).add("hosts", this.hosts).add("accessToken", (Object)(this.accessToken != null ? "********" : null)).add("healthCheckIntervalMillis", (Object)this.healthCheckIntervalMillis).add("initializationTimeoutMillis", (Object)this.initializationTimeoutMillis).add("useTls", (Object)this.useTls).add("maxNumRetriesOnReplicationLag", (Object)this.maxNumRetriesOnReplicationLag).add("retryIntervalOnReplicationLagMillis", (Object)this.retryIntervalOnReplicationLagMillis).toString();
    }
}

