/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.rxjava2;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.rxjava2.RequestContextConditionalSubscriber;
import com.linecorp.armeria.common.rxjava2.RequestContextSubscriber;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.reactivex.Flowable;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class RequestContextCallableFlowable<T>
extends Flowable<T>
implements Callable<T> {
    private final Publisher<T> source;
    private final RequestContext assemblyContext;

    RequestContextCallableFlowable(Publisher<T> source, RequestContext assemblyContext) {
        this.source = source;
        this.assemblyContext = assemblyContext;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            if (s instanceof ConditionalSubscriber) {
                this.source.subscribe(new RequestContextConditionalSubscriber((ConditionalSubscriber)s, this.assemblyContext));
            } else {
                this.source.subscribe(new RequestContextSubscriber<T>(s, this.assemblyContext));
            }
        }
    }

    @Override
    public T call() throws Exception {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            Object v = ((Callable)this.source).call();
            return (T)v;
        }
    }
}

