/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.java.internal;

import java.util.Collections;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentFactory;
import org.gradle.internal.component.local.model.DefaultLibraryComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetaData;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.LocalComponentDependencyMetaData;
import org.gradle.language.java.internal.DefaultJavaSourceSetResolveContext;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.DependencySpecContainer;

public class DefaultJavaLocalComponentFactory
implements LocalComponentFactory {
    private static final ExcludeRule[] EXCLUDE_RULES = new ExcludeRule[0];

    public boolean canConvert(Object source) {
        return source instanceof DefaultJavaSourceSetResolveContext;
    }

    public LocalComponentMetaData convert(Object source) {
        DefaultJavaSourceSetResolveContext context = (DefaultJavaSourceSetResolveContext)source;
        String projectPath = context.getProject().getPath();
        String libraryName = context.getSourceSet().getParentName();
        String version = context.getProject().getVersion().toString();
        DefaultModuleVersionIdentifier id = new DefaultModuleVersionIdentifier(projectPath, libraryName, version);
        DefaultLibraryComponentIdentifier component = new DefaultLibraryComponentIdentifier(projectPath, libraryName);
        DefaultLocalComponentMetaData metaData = new DefaultLocalComponentMetaData((ModuleVersionIdentifier)id, (ComponentIdentifier)component, "release");
        metaData.addConfiguration(context.getName(), "Configuration for " + libraryName, Collections.emptySet(), Collections.singleton(context.getName()), true, true);
        this.addDependencies(projectPath, (ModuleVersionIdentifier)id, metaData, context.getSourceSet().getDependencies());
        return metaData;
    }

    private void addDependencies(String defaultProject, ModuleVersionIdentifier mvi, DefaultLocalComponentMetaData metaData, DependencySpecContainer allDependencies) {
        for (DependencySpec dependency : allDependencies) {
            String projectPath = dependency.getProjectPath();
            if (projectPath == null) {
                projectPath = defaultProject;
            }
            Object selector = dependency.getLibraryName() == null ? new DefaultProjectComponentSelector(dependency.getProjectPath()) : new DefaultLibraryComponentSelector(projectPath, dependency.getLibraryName());
            DefaultModuleVersionSelector requested = new DefaultModuleVersionSelector(projectPath, dependency.getLibraryName(), mvi.getVersion());
            LocalComponentDependencyMetaData localComponentDependencyMetaData = new LocalComponentDependencyMetaData((ComponentSelector)selector, (ModuleVersionSelector)requested, DefaultLibraryComponentIdentifier.libraryToConfigurationName((String)mvi.getGroup(), (String)mvi.getName()), DefaultLibraryComponentIdentifier.libraryToConfigurationName((String)projectPath, (String)dependency.getLibraryName()), Collections.emptySet(), EXCLUDE_RULES, false, false, true);
            metaData.addDependency((DependencyMetaData)localComponentDependencyMetaData);
        }
    }
}

