/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;

public class InterpolationHelper {
    private static final String _DELIM_START = "${";
    private static final String _DELIM_STOP = "}";
    private static final String _ENV_PREFIX = "env:";
    private static final char _ESCAPE_CHAR = '\\';
    private static final String _MARKER = "$__";
    private static final Pattern _escapedClosingCurly = Pattern.compile("\\\\+\\}");
    private static final Pattern _escapedOpeningCurly = Pattern.compile("\\\\+\\{");
    private static final Pattern _existingSubstVar = Pattern.compile(".*\\$\\\\*\\{.*\\}.*");

    public static void performSubstitution(Map<String, String> properties) {
        InterpolationHelper.performSubstitution(properties, (BundleContext)null);
    }

    public static void performSubstitution(Map<String, String> properties, BundleContext bundleContext) {
        InterpolationHelper.performSubstitution(properties, new BundleContextSubstitutionCallback(bundleContext));
    }

    public static void performSubstitution(Map<String, String> properties, SubstitutionCallback substitutionCallback) {
        InterpolationHelper.performSubstitution(properties, substitutionCallback, true, true, true);
    }

    public static void performSubstitution(Map<String, String> properties, SubstitutionCallback callback, boolean substituteFromConfig, boolean substituteFromSystemProperties, boolean defaultsToEmptyString) {
        HashMap<String, String> map = new HashMap<String, String>(properties);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            properties.put(name, InterpolationHelper.substVars(entry.getValue(), name, null, map, callback, substituteFromConfig, substituteFromSystemProperties, defaultsToEmptyString));
        }
    }

    public static String substVars(String value, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps) throws IllegalArgumentException {
        return InterpolationHelper.substVars(value, currentKey, cycleMap, configProps, (SubstitutionCallback)null);
    }

    public static String substVars(String value, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, BundleContext bundleContext) throws IllegalArgumentException {
        return InterpolationHelper.substVars(value, currentKey, cycleMap, configProps, new BundleContextSubstitutionCallback(bundleContext));
    }

    public static String substVars(String value, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, SubstitutionCallback callback) throws IllegalArgumentException {
        return InterpolationHelper.substVars(value, currentKey, cycleMap, configProps, callback, true, true, true);
    }

    public static String substVars(String value, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, SubstitutionCallback callback, boolean substituteFromConfig, boolean substituteFromSystemProperties, boolean defaultsToEmptyString) throws IllegalArgumentException {
        return InterpolationHelper._unescape(InterpolationHelper._substVars(value, currentKey, cycleMap, configProps, callback, substituteFromConfig, substituteFromSystemProperties, defaultsToEmptyString));
    }

    private static int _indexOf(String value, int fromIndex) {
        int index;
        Matcher escapedOpeningCurlyMatcher = _escapedOpeningCurly.matcher(value);
        Matcher escapedClosingCurlyMatcher = _escapedClosingCurly.matcher(value);
        int escapedOpeningCurlyMatcherIndex = Integer.MAX_VALUE;
        if (escapedOpeningCurlyMatcher.find(fromIndex)) {
            escapedOpeningCurlyMatcherIndex = escapedOpeningCurlyMatcher.start();
        }
        int escapedClosingCurlyMatcherIndex = Integer.MAX_VALUE;
        if (escapedClosingCurlyMatcher.find(fromIndex)) {
            escapedClosingCurlyMatcherIndex = escapedClosingCurlyMatcher.start();
        }
        if ((index = Math.min(escapedOpeningCurlyMatcherIndex, escapedClosingCurlyMatcherIndex)) == Integer.MAX_VALUE) {
            return -1;
        }
        return index;
    }

    private static String _substVars(String value, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, SubstitutionCallback callback, boolean substituteFromConfig, boolean substituteFromSystemProperties, boolean defaultsToEmptyString) throws IllegalArgumentException {
        String variable;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int startDelim = value.indexOf(_DELIM_START);
        int stopDelim = value.indexOf(_DELIM_STOP);
        while (startDelim >= 0 && stopDelim >= 0) {
            int index;
            while (stopDelim > 0 && value.charAt(stopDelim - 1) == '\\') {
                stopDelim = value.indexOf(_DELIM_STOP, stopDelim + 1);
            }
            while (stopDelim >= 0 && (index = value.indexOf(_DELIM_START, startDelim + _DELIM_START.length())) >= 0 && index <= stopDelim) {
                if (index >= stopDelim) continue;
                startDelim = index;
            }
            if (startDelim < stopDelim) break;
            stopDelim = value.indexOf(_DELIM_STOP, stopDelim + 1);
            startDelim = value.indexOf(_DELIM_START);
        }
        if (startDelim < 0 || stopDelim < 0) {
            cycleMap.remove(currentKey);
            return value;
        }
        String original = variable = value.substring(startDelim + _DELIM_START.length(), stopDelim);
        int index1 = variable.lastIndexOf(":-");
        int index2 = variable.lastIndexOf(":+");
        int index = -1;
        index = index1 >= 0 && index2 >= 0 ? Math.min(index1, index1) : (index1 >= 0 ? index1 : index2);
        String op = null;
        if (index >= 0 && index < variable.length()) {
            op = variable.substring(index);
            variable = variable.substring(0, index);
        }
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String substValue = null;
        if (substituteFromConfig && configProps != null) {
            substValue = configProps.get(variable);
        }
        if (substValue == null && variable.length() > 0) {
            if (callback != null) {
                substValue = callback.getValue(variable);
            }
            if (substValue == null && substituteFromSystemProperties) {
                substValue = System.getProperty(variable);
            }
        }
        if (op != null) {
            if (op.startsWith(":-")) {
                if (substValue == null || substValue.length() == 0) {
                    substValue = op.substring(":-".length());
                }
            } else if (op.startsWith(":+")) {
                if (substValue != null && substValue.length() != 0) {
                    substValue = op.substring(":+".length());
                }
            } else {
                throw new IllegalArgumentException("Bad substitution: ${" + original + _DELIM_STOP);
            }
        }
        if (substValue == null) {
            substValue = defaultsToEmptyString ? "" : "$__{" + variable + _DELIM_STOP;
        }
        cycleMap.remove(variable);
        value = value.substring(0, startDelim) + substValue + value.substring(stopDelim + _DELIM_STOP.length());
        value = InterpolationHelper._substVars(value, currentKey, cycleMap, configProps, callback, substituteFromConfig, substituteFromSystemProperties, defaultsToEmptyString);
        cycleMap.remove(currentKey);
        return value;
    }

    private static String _unescape(String value) {
        Matcher existingSubstVarMatcher = _existingSubstVar.matcher(value = value.replaceAll("\\$__", "\\$"));
        if (!existingSubstVarMatcher.matches()) {
            return value;
        }
        int escape = InterpolationHelper._indexOf(value, 0);
        while (escape >= 0 && escape < value.length() - 1) {
            char c = value.charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                value = value.substring(0, escape) + value.substring(escape + 1);
            }
            escape = InterpolationHelper._indexOf(value, escape + 1);
        }
        return value;
    }

    private InterpolationHelper() {
    }

    public static interface SubstitutionCallback {
        public String getValue(String var1);
    }

    public static class BundleContextSubstitutionCallback
    implements SubstitutionCallback {
        private final BundleContext _bundleContext;

        public BundleContextSubstitutionCallback(BundleContext context) {
            this._bundleContext = context;
        }

        @Override
        public String getValue(String key) {
            String value = null;
            if (key.startsWith(InterpolationHelper._ENV_PREFIX)) {
                value = System.getenv(key.substring(InterpolationHelper._ENV_PREFIX.length()));
            } else {
                if (this._bundleContext != null) {
                    value = this._bundleContext.getProperty(key);
                }
                if (value == null) {
                    value = System.getProperty(key);
                }
            }
            return value;
        }
    }
}

